/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.inspector.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsRequest;
import software.amazon.awssdk.services.inspector.model.AddAttributesToFindingsResponse;
import software.amazon.awssdk.services.inspector.model.AgentsAlreadyRunningAssessmentException;
import software.amazon.awssdk.services.inspector.model.AssessmentRunInProgressException;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.CreateAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.CreateExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupRequest;
import software.amazon.awssdk.services.inspector.model.CreateResourceGroupResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateRequest;
import software.amazon.awssdk.services.inspector.model.DeleteAssessmentTemplateResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.DescribeCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeFindingsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsRequest;
import software.amazon.awssdk.services.inspector.model.DescribeResourceGroupsResponse;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.DescribeRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportRequest;
import software.amazon.awssdk.services.inspector.model.GetAssessmentReportResponse;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest;
import software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataRequest;
import software.amazon.awssdk.services.inspector.model.GetTelemetryMetadataResponse;
import software.amazon.awssdk.services.inspector.model.InspectorException;
import software.amazon.awssdk.services.inspector.model.InternalException;
import software.amazon.awssdk.services.inspector.model.InvalidCrossAccountRoleException;
import software.amazon.awssdk.services.inspector.model.InvalidInputException;
import software.amazon.awssdk.services.inspector.model.LimitExceededException;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest;
import software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest;
import software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse;
import software.amazon.awssdk.services.inspector.model.ListExclusionsRequest;
import software.amazon.awssdk.services.inspector.model.ListExclusionsResponse;
import software.amazon.awssdk.services.inspector.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest;
import software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.NoSuchEntityException;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse;
import software.amazon.awssdk.services.inspector.model.PreviewGenerationInProgressException;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleRequest;
import software.amazon.awssdk.services.inspector.model.RegisterCrossAccountAccessRoleResponse;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsRequest;
import software.amazon.awssdk.services.inspector.model.RemoveAttributesFromFindingsResponse;
import software.amazon.awssdk.services.inspector.model.ServiceTemporarilyUnavailableException;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceRequest;
import software.amazon.awssdk.services.inspector.model.SetTagsForResourceResponse;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StartAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunRequest;
import software.amazon.awssdk.services.inspector.model.StopAssessmentRunResponse;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventRequest;
import software.amazon.awssdk.services.inspector.model.SubscribeToEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventRequest;
import software.amazon.awssdk.services.inspector.model.UnsubscribeFromEventResponse;
import software.amazon.awssdk.services.inspector.model.UnsupportedFeatureException;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetRequest;
import software.amazon.awssdk.services.inspector.model.UpdateAssessmentTargetResponse;
import software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable;
import software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable;
import software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable;
import software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable;
import software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable;
import software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable;

/**
 * Service client for accessing Amazon Inspector. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Inspector</fullname>
 * <p>
 * Amazon Inspector enables you to analyze the behavior of your AWS resources and to identify potential security issues.
 * For more information, see <a
 * href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_introduction.html"> Amazon Inspector User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface InspectorClient extends SdkClient {
    String SERVICE_NAME = "inspector";

    /**
     * Create a {@link InspectorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static InspectorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link InspectorClient}.
     */
    static InspectorClientBuilder builder() {
        return new DefaultInspectorClientBuilder();
    }

    /**
     * <p>
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     * </p>
     *
     * @param addAttributesToFindingsRequest
     * @return Result of the AddAttributesToFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.AddAttributesToFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/AddAttributesToFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default AddAttributesToFindingsResponse addAttributesToFindings(AddAttributesToFindingsRequest addAttributesToFindingsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddAttributesToFindingsRequest.Builder} avoiding
     * the need to create one manually via {@link AddAttributesToFindingsRequest#builder()}
     * </p>
     *
     * @param addAttributesToFindingsRequest
     *        A {@link Consumer} that will call methods on {@link AddAttributesToFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the AddAttributesToFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.AddAttributesToFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/AddAttributesToFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default AddAttributesToFindingsResponse addAttributesToFindings(
            Consumer<AddAttributesToFindingsRequest.Builder> addAttributesToFindingsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        return addAttributesToFindings(AddAttributesToFindingsRequest.builder().applyMutation(addAttributesToFindingsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new assessment target using the ARN of the resource group that is generated by
     * <a>CreateResourceGroup</a>. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
     * and region are included in the assessment target. If the <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t
     * already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access
     * to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS
     * account. You can run up to 500 concurrent agents per AWS account. For more information, see <a
     * href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html"> Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     *
     * @param createAssessmentTargetRequest
     * @return Result of the CreateAssessmentTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateAssessmentTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentTargetResponse createAssessmentTarget(CreateAssessmentTargetRequest createAssessmentTargetRequest)
            throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException,
            NoSuchEntityException, InvalidCrossAccountRoleException, ServiceTemporarilyUnavailableException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new assessment target using the ARN of the resource group that is generated by
     * <a>CreateResourceGroup</a>. If resourceGroupArn is not specified, all EC2 instances in the current AWS account
     * and region are included in the assessment target. If the <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked role</a> isn’t
     * already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access
     * to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS
     * account. You can run up to 500 concurrent agents per AWS account. For more information, see <a
     * href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html"> Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssessmentTargetRequest#builder()}
     * </p>
     *
     * @param createAssessmentTargetRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentTargetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssessmentTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateAssessmentTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentTargetResponse createAssessmentTarget(
            Consumer<CreateAssessmentTargetRequest.Builder> createAssessmentTargetRequest) throws InternalException,
            InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException,
            InvalidCrossAccountRoleException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException,
            InspectorException {
        return createAssessmentTarget(CreateAssessmentTargetRequest.builder().applyMutation(createAssessmentTargetRequest)
                .build());
    }

    /**
     * <p>
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     * If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked
     * role</a> isn’t already registered, this action also creates and registers a service-linked role to grant Amazon
     * Inspector access to AWS Services needed to perform security assessments.
     * </p>
     *
     * @param createAssessmentTemplateRequest
     * @return Result of the CreateAssessmentTemplate operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateAssessmentTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentTemplateResponse createAssessmentTemplate(
            CreateAssessmentTemplateRequest createAssessmentTemplateRequest) throws InternalException, InvalidInputException,
            LimitExceededException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     * If the <a href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html">service-linked
     * role</a> isn’t already registered, this action also creates and registers a service-linked role to grant Amazon
     * Inspector access to AWS Services needed to perform security assessments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssessmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateAssessmentTemplateRequest#builder()}
     * </p>
     *
     * @param createAssessmentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssessmentTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssessmentTemplate operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateAssessmentTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAssessmentTemplateResponse createAssessmentTemplate(
            Consumer<CreateAssessmentTemplateRequest.Builder> createAssessmentTemplateRequest) throws InternalException,
            InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return createAssessmentTemplate(CreateAssessmentTemplateRequest.builder().applyMutation(createAssessmentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview
     * lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     * </p>
     *
     * @param createExclusionsPreviewRequest
     * @return Result of the CreateExclusionsPreview operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PreviewGenerationInProgressException
     *         The request is rejected. The specified assessment template is currently generating an exclusions preview.
     * @throws InternalException
     *         Internal server error.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateExclusionsPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateExclusionsPreviewResponse createExclusionsPreview(CreateExclusionsPreviewRequest createExclusionsPreviewRequest)
            throws InvalidInputException, PreviewGenerationInProgressException, InternalException, AccessDeniedException,
            NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview
     * lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExclusionsPreviewRequest.Builder} avoiding
     * the need to create one manually via {@link CreateExclusionsPreviewRequest#builder()}
     * </p>
     *
     * @param createExclusionsPreviewRequest
     *        A {@link Consumer} that will call methods on {@link CreateExclusionsPreviewRequest.Builder} to create a
     *        request.
     * @return Result of the CreateExclusionsPreview operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PreviewGenerationInProgressException
     *         The request is rejected. The specified assessment template is currently generating an exclusions preview.
     * @throws InternalException
     *         Internal server error.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateExclusionsPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateExclusionsPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateExclusionsPreviewResponse createExclusionsPreview(
            Consumer<CreateExclusionsPreviewRequest.Builder> createExclusionsPreviewRequest) throws InvalidInputException,
            PreviewGenerationInProgressException, InternalException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return createExclusionsPreview(CreateExclusionsPreviewRequest.builder().applyMutation(createExclusionsPreviewRequest)
                .build());
    }

    /**
     * <p>
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2
     * instances to be included in an Amazon Inspector assessment target. The created resource group is then used to
     * create an Amazon Inspector assessment target. For more information, see <a>CreateAssessmentTarget</a>.
     * </p>
     *
     * @param createResourceGroupRequest
     * @return Result of the CreateResourceGroup operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateResourceGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateResourceGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateResourceGroupResponse createResourceGroup(CreateResourceGroupRequest createResourceGroupRequest)
            throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2
     * instances to be included in an Amazon Inspector assessment target. The created resource group is then used to
     * create an Amazon Inspector assessment target. For more information, see <a>CreateAssessmentTarget</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceGroupRequest#builder()}
     * </p>
     *
     * @param createResourceGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourceGroup operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.CreateResourceGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/CreateResourceGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateResourceGroupResponse createResourceGroup(
            Consumer<CreateResourceGroupRequest.Builder> createResourceGroupRequest) throws InternalException,
            InvalidInputException, LimitExceededException, AccessDeniedException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        return createResourceGroup(CreateResourceGroupRequest.builder().applyMutation(createResourceGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     * </p>
     *
     * @param deleteAssessmentRunRequest
     * @return Result of the DeleteAssessmentRun operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DeleteAssessmentRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssessmentRunResponse deleteAssessmentRun(DeleteAssessmentRunRequest deleteAssessmentRunRequest)
            throws InternalException, InvalidInputException, AssessmentRunInProgressException, AccessDeniedException,
            NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentRunRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAssessmentRunRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentRunRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssessmentRun operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DeleteAssessmentRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAssessmentRunResponse deleteAssessmentRun(
            Consumer<DeleteAssessmentRunRequest.Builder> deleteAssessmentRunRequest) throws InternalException,
            InvalidInputException, AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return deleteAssessmentRun(DeleteAssessmentRunRequest.builder().applyMutation(deleteAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     * </p>
     *
     * @param deleteAssessmentTargetRequest
     * @return Result of the DeleteAssessmentTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DeleteAssessmentTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentTargetResponse deleteAssessmentTarget(DeleteAssessmentTargetRequest deleteAssessmentTargetRequest)
            throws InternalException, InvalidInputException, AssessmentRunInProgressException, AccessDeniedException,
            NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAssessmentTargetRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentTargetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentTargetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssessmentTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DeleteAssessmentTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentTargetResponse deleteAssessmentTarget(
            Consumer<DeleteAssessmentTargetRequest.Builder> deleteAssessmentTargetRequest) throws InternalException,
            InvalidInputException, AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return deleteAssessmentTarget(DeleteAssessmentTargetRequest.builder().applyMutation(deleteAssessmentTargetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     * </p>
     *
     * @param deleteAssessmentTemplateRequest
     * @return Result of the DeleteAssessmentTemplate operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DeleteAssessmentTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentTemplateResponse deleteAssessmentTemplate(
            DeleteAssessmentTemplateRequest deleteAssessmentTemplateRequest) throws InternalException, InvalidInputException,
            AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssessmentTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAssessmentTemplateRequest#builder()}
     * </p>
     *
     * @param deleteAssessmentTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssessmentTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAssessmentTemplate operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DeleteAssessmentTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAssessmentTemplateResponse deleteAssessmentTemplate(
            Consumer<DeleteAssessmentTemplateRequest.Builder> deleteAssessmentTemplateRequest) throws InternalException,
            InvalidInputException, AssessmentRunInProgressException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return deleteAssessmentTemplate(DeleteAssessmentTemplateRequest.builder().applyMutation(deleteAssessmentTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @param describeAssessmentRunsRequest
     * @return Result of the DescribeAssessmentRuns operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeAssessmentRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssessmentRunsResponse describeAssessmentRuns(DescribeAssessmentRunsRequest describeAssessmentRunsRequest)
            throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssessmentRunsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssessmentRunsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAssessmentRuns operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeAssessmentRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssessmentRunsResponse describeAssessmentRuns(
            Consumer<DescribeAssessmentRunsRequest.Builder> describeAssessmentRunsRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeAssessmentRuns(DescribeAssessmentRunsRequest.builder().applyMutation(describeAssessmentRunsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     * </p>
     *
     * @param describeAssessmentTargetsRequest
     * @return Result of the DescribeAssessmentTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeAssessmentTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssessmentTargetsResponse describeAssessmentTargets(
            DescribeAssessmentTargetsRequest describeAssessmentTargetsRequest) throws InternalException, InvalidInputException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssessmentTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAssessmentTargetsRequest#builder()}
     * </p>
     *
     * @param describeAssessmentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssessmentTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAssessmentTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeAssessmentTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssessmentTargetsResponse describeAssessmentTargets(
            Consumer<DescribeAssessmentTargetsRequest.Builder> describeAssessmentTargetsRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeAssessmentTargets(DescribeAssessmentTargetsRequest.builder()
                .applyMutation(describeAssessmentTargetsRequest).build());
    }

    /**
     * <p>
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     * </p>
     *
     * @param describeAssessmentTemplatesRequest
     * @return Result of the DescribeAssessmentTemplates operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeAssessmentTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssessmentTemplatesResponse describeAssessmentTemplates(
            DescribeAssessmentTemplatesRequest describeAssessmentTemplatesRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssessmentTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssessmentTemplatesRequest#builder()}
     * </p>
     *
     * @param describeAssessmentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssessmentTemplatesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAssessmentTemplates operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeAssessmentTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssessmentTemplatesResponse describeAssessmentTemplates(
            Consumer<DescribeAssessmentTemplatesRequest.Builder> describeAssessmentTemplatesRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeAssessmentTemplates(DescribeAssessmentTemplatesRequest.builder()
                .applyMutation(describeAssessmentTemplatesRequest).build());
    }

    /**
     * <p>
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     * </p>
     *
     * @return Result of the DescribeCrossAccountAccessRole operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeCrossAccountAccessRole
     * @see #describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCrossAccountAccessRoleResponse describeCrossAccountAccessRole() throws InternalException,
            AwsServiceException, SdkClientException, InspectorException {
        return describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest.builder().build());
    }

    /**
     * <p>
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     * </p>
     *
     * @param describeCrossAccountAccessRoleRequest
     * @return Result of the DescribeCrossAccountAccessRole operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeCrossAccountAccessRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCrossAccountAccessRoleResponse describeCrossAccountAccessRole(
            DescribeCrossAccountAccessRoleRequest describeCrossAccountAccessRoleRequest) throws InternalException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCrossAccountAccessRoleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCrossAccountAccessRoleRequest#builder()}
     * </p>
     *
     * @param describeCrossAccountAccessRoleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCrossAccountAccessRoleRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeCrossAccountAccessRole operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeCrossAccountAccessRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCrossAccountAccessRoleResponse describeCrossAccountAccessRole(
            Consumer<DescribeCrossAccountAccessRoleRequest.Builder> describeCrossAccountAccessRoleRequest)
            throws InternalException, AwsServiceException, SdkClientException, InspectorException {
        return describeCrossAccountAccessRole(DescribeCrossAccountAccessRoleRequest.builder()
                .applyMutation(describeCrossAccountAccessRoleRequest).build());
    }

    /**
     * <p>
     * Describes the exclusions that are specified by the exclusions' ARNs.
     * </p>
     *
     * @param describeExclusionsRequest
     * @return Result of the DescribeExclusions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeExclusions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExclusionsResponse describeExclusions(DescribeExclusionsRequest describeExclusionsRequest)
            throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the exclusions that are specified by the exclusions' ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExclusionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExclusionsRequest#builder()}
     * </p>
     *
     * @param describeExclusionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExclusionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeExclusions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeExclusions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeExclusions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeExclusionsResponse describeExclusions(Consumer<DescribeExclusionsRequest.Builder> describeExclusionsRequest)
            throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeExclusions(DescribeExclusionsRequest.builder().applyMutation(describeExclusionsRequest).build());
    }

    /**
     * <p>
     * Describes the findings that are specified by the ARNs of the findings.
     * </p>
     *
     * @param describeFindingsRequest
     * @return Result of the DescribeFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFindingsResponse describeFindings(DescribeFindingsRequest describeFindingsRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the findings that are specified by the ARNs of the findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFindingsRequest#builder()}
     * </p>
     *
     * @param describeFindingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFindingsRequest.Builder} to create a request.
     * @return Result of the DescribeFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFindingsResponse describeFindings(Consumer<DescribeFindingsRequest.Builder> describeFindingsRequest)
            throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeFindings(DescribeFindingsRequest.builder().applyMutation(describeFindingsRequest).build());
    }

    /**
     * <p>
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     * </p>
     *
     * @param describeResourceGroupsRequest
     * @return Result of the DescribeResourceGroups operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeResourceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceGroupsResponse describeResourceGroups(DescribeResourceGroupsRequest describeResourceGroupsRequest)
            throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeResourceGroupsRequest#builder()}
     * </p>
     *
     * @param describeResourceGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeResourceGroups operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeResourceGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeResourceGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeResourceGroupsResponse describeResourceGroups(
            Consumer<DescribeResourceGroupsRequest.Builder> describeResourceGroupsRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeResourceGroups(DescribeResourceGroupsRequest.builder().applyMutation(describeResourceGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     * </p>
     *
     * @param describeRulesPackagesRequest
     * @return Result of the DescribeRulesPackages operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeRulesPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeRulesPackages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRulesPackagesResponse describeRulesPackages(DescribeRulesPackagesRequest describeRulesPackagesRequest)
            throws InternalException, InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRulesPackagesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRulesPackagesRequest#builder()}
     * </p>
     *
     * @param describeRulesPackagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRulesPackagesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRulesPackages operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.DescribeRulesPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DescribeRulesPackages"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRulesPackagesResponse describeRulesPackages(
            Consumer<DescribeRulesPackagesRequest.Builder> describeRulesPackagesRequest) throws InternalException,
            InvalidInputException, AwsServiceException, SdkClientException, InspectorException {
        return describeRulesPackages(DescribeRulesPackagesRequest.builder().applyMutation(describeRulesPackagesRequest).build());
    }

    /**
     * <p>
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     * </p>
     *
     * @param getAssessmentReportRequest
     * @return Result of the GetAssessmentReport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws UnsupportedFeatureException
     *         Used by the <a>GetAssessmentReport</a> API. The request was rejected because you tried to generate a
     *         report for an assessment run that existed before reporting was supported in Amazon Inspector. You can
     *         only generate reports for assessment runs that took place or will take place after generating reports in
     *         Amazon Inspector became available.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetAssessmentReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetAssessmentReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAssessmentReportResponse getAssessmentReport(GetAssessmentReportRequest getAssessmentReportRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            AssessmentRunInProgressException, UnsupportedFeatureException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssessmentReportRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssessmentReportRequest#builder()}
     * </p>
     *
     * @param getAssessmentReportRequest
     *        A {@link Consumer} that will call methods on {@link GetAssessmentReportRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssessmentReport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws AssessmentRunInProgressException
     *         You cannot perform a specified action if an assessment run is currently in progress.
     * @throws UnsupportedFeatureException
     *         Used by the <a>GetAssessmentReport</a> API. The request was rejected because you tried to generate a
     *         report for an assessment run that existed before reporting was supported in Amazon Inspector. You can
     *         only generate reports for assessment runs that took place or will take place after generating reports in
     *         Amazon Inspector became available.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetAssessmentReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetAssessmentReport" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAssessmentReportResponse getAssessmentReport(
            Consumer<GetAssessmentReportRequest.Builder> getAssessmentReportRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AssessmentRunInProgressException,
            UnsupportedFeatureException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException,
            InspectorException {
        return getAssessmentReport(GetAssessmentReportRequest.builder().applyMutation(getAssessmentReportRequest).build());
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     *
     * @param getExclusionsPreviewRequest
     * @return Result of the GetExclusionsPreview operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws InternalException
     *         Internal server error.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetExclusionsPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExclusionsPreviewResponse getExclusionsPreview(GetExclusionsPreviewRequest getExclusionsPreviewRequest)
            throws InvalidInputException, InternalException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExclusionsPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link GetExclusionsPreviewRequest#builder()}
     * </p>
     *
     * @param getExclusionsPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetExclusionsPreviewRequest.Builder} to create a
     *        request.
     * @return Result of the GetExclusionsPreview operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws InternalException
     *         Internal server error.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetExclusionsPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExclusionsPreviewResponse getExclusionsPreview(
            Consumer<GetExclusionsPreviewRequest.Builder> getExclusionsPreviewRequest) throws InvalidInputException,
            InternalException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return getExclusionsPreview(GetExclusionsPreviewRequest.builder().applyMutation(getExclusionsPreviewRequest).build());
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable responses = client.getExclusionsPreviewPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable responses = client
     *             .getExclusionsPreviewPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable responses = client.getExclusionsPreviewPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation.</b>
     * </p>
     *
     * @param getExclusionsPreviewRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws InternalException
     *         Internal server error.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetExclusionsPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExclusionsPreviewIterable getExclusionsPreviewPaginator(GetExclusionsPreviewRequest getExclusionsPreviewRequest)
            throws InvalidInputException, InternalException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can
     * obtain the preview token by running the CreateExclusionsPreview API.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable responses = client.getExclusionsPreviewPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable responses = client
     *             .getExclusionsPreviewPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.GetExclusionsPreviewIterable responses = client.getExclusionsPreviewPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExclusionsPreview(software.amazon.awssdk.services.inspector.model.GetExclusionsPreviewRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExclusionsPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link GetExclusionsPreviewRequest#builder()}
     * </p>
     *
     * @param getExclusionsPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetExclusionsPreviewRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws InternalException
     *         Internal server error.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetExclusionsPreview
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetExclusionsPreview" target="_top">AWS
     *      API Documentation</a>
     */
    default GetExclusionsPreviewIterable getExclusionsPreviewPaginator(
            Consumer<GetExclusionsPreviewRequest.Builder> getExclusionsPreviewRequest) throws InvalidInputException,
            InternalException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return getExclusionsPreviewPaginator(GetExclusionsPreviewRequest.builder().applyMutation(getExclusionsPreviewRequest)
                .build());
    }

    /**
     * <p>
     * Information about the data that is collected for the specified assessment run.
     * </p>
     *
     * @param getTelemetryMetadataRequest
     * @return Result of the GetTelemetryMetadata operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetTelemetryMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetTelemetryMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTelemetryMetadataResponse getTelemetryMetadata(GetTelemetryMetadataRequest getTelemetryMetadataRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about the data that is collected for the specified assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTelemetryMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetTelemetryMetadataRequest#builder()}
     * </p>
     *
     * @param getTelemetryMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetTelemetryMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the GetTelemetryMetadata operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.GetTelemetryMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/GetTelemetryMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTelemetryMetadataResponse getTelemetryMetadata(
            Consumer<GetTelemetryMetadataRequest.Builder> getTelemetryMetadataRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return getTelemetryMetadata(GetTelemetryMetadataRequest.builder().applyMutation(getTelemetryMetadataRequest).build());
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     * @return Result of the ListAssessmentRunAgents operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRunAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentRunAgentsResponse listAssessmentRunAgents(ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunAgentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentRunAgentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunAgentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssessmentRunAgents operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRunAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentRunAgentsResponse listAssessmentRunAgents(
            Consumer<ListAssessmentRunAgentsRequest.Builder> listAssessmentRunAgentsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listAssessmentRunAgents(ListAssessmentRunAgentsRequest.builder().applyMutation(listAssessmentRunAgentsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable responses = client.listAssessmentRunAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable responses = client
     *             .listAssessmentRunAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable responses = client.listAssessmentRunAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRunAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentRunAgentsIterable listAssessmentRunAgentsPaginator(
            ListAssessmentRunAgentsRequest listAssessmentRunAgentsRequest) throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable responses = client.listAssessmentRunAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable responses = client
     *             .listAssessmentRunAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunAgentsIterable responses = client.listAssessmentRunAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRunAgents(software.amazon.awssdk.services.inspector.model.ListAssessmentRunAgentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunAgentsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentRunAgentsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunAgentsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunAgentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRunAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRunAgents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentRunAgentsIterable listAssessmentRunAgentsPaginator(
            Consumer<ListAssessmentRunAgentsRequest.Builder> listAssessmentRunAgentsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listAssessmentRunAgentsPaginator(ListAssessmentRunAgentsRequest.builder()
                .applyMutation(listAssessmentRunAgentsRequest).build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     *
     * @return Result of the ListAssessmentRuns operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRuns
     * @see #listAssessmentRuns(ListAssessmentRunsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsResponse listAssessmentRuns() throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentRuns(ListAssessmentRunsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     *
     * @param listAssessmentRunsRequest
     * @return Result of the ListAssessmentRuns operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsResponse listAssessmentRuns(ListAssessmentRunsRequest listAssessmentRunsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssessmentRuns operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsResponse listAssessmentRuns(Consumer<ListAssessmentRunsRequest.Builder> listAssessmentRunsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        return listAssessmentRuns(ListAssessmentRunsRequest.builder().applyMutation(listAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client.listAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client
     *             .listAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client.listAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRuns
     * @see #listAssessmentRunsPaginator(ListAssessmentRunsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsIterable listAssessmentRunsPaginator() throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentRunsPaginator(ListAssessmentRunsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client.listAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client
     *             .listAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client.listAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsIterable listAssessmentRunsPaginator(ListAssessmentRunsRequest listAssessmentRunsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the
     * assessment templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client.listAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client
     *             .listAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentRunsIterable responses = client.listAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentRuns(software.amazon.awssdk.services.inspector.model.ListAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentRunsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param listAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentRunsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentRuns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentRuns" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssessmentRunsIterable listAssessmentRunsPaginator(
            Consumer<ListAssessmentRunsRequest.Builder> listAssessmentRunsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listAssessmentRunsPaginator(ListAssessmentRunsRequest.builder().applyMutation(listAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     *
     * @return Result of the ListAssessmentTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTargets
     * @see #listAssessmentTargets(ListAssessmentTargetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsResponse listAssessmentTargets() throws InternalException, InvalidInputException,
            AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentTargets(ListAssessmentTargetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     *
     * @param listAssessmentTargetsRequest
     * @return Result of the ListAssessmentTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsResponse listAssessmentTargets(ListAssessmentTargetsRequest listAssessmentTargetsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentTargetsRequest#builder()}
     * </p>
     *
     * @param listAssessmentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssessmentTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsResponse listAssessmentTargets(
            Consumer<ListAssessmentTargetsRequest.Builder> listAssessmentTargetsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentTargets(ListAssessmentTargetsRequest.builder().applyMutation(listAssessmentTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client.listAssessmentTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client
     *             .listAssessmentTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client.listAssessmentTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTargets
     * @see #listAssessmentTargetsPaginator(ListAssessmentTargetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsIterable listAssessmentTargetsPaginator() throws InternalException, InvalidInputException,
            AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentTargetsPaginator(ListAssessmentTargetsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client.listAssessmentTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client
     *             .listAssessmentTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client.listAssessmentTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsIterable listAssessmentTargetsPaginator(ListAssessmentTargetsRequest listAssessmentTargetsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets,
     * see <a href="http://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html">Amazon Inspector
     * Assessment Targets</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client.listAssessmentTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client
     *             .listAssessmentTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTargetsIterable responses = client.listAssessmentTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTargets(software.amazon.awssdk.services.inspector.model.ListAssessmentTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssessmentTargetsRequest#builder()}
     * </p>
     *
     * @param listAssessmentTargetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTargetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTargetsIterable listAssessmentTargetsPaginator(
            Consumer<ListAssessmentTargetsRequest.Builder> listAssessmentTargetsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentTargetsPaginator(ListAssessmentTargetsRequest.builder().applyMutation(listAssessmentTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     *
     * @return Result of the ListAssessmentTemplates operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTemplates
     * @see #listAssessmentTemplates(ListAssessmentTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesResponse listAssessmentTemplates() throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentTemplates(ListAssessmentTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     * @return Result of the ListAssessmentTemplates operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesResponse listAssessmentTemplates(ListAssessmentTemplatesRequest listAssessmentTemplatesRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentTemplatesRequest#builder()}
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssessmentTemplates operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesResponse listAssessmentTemplates(
            Consumer<ListAssessmentTemplatesRequest.Builder> listAssessmentTemplatesRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listAssessmentTemplates(ListAssessmentTemplatesRequest.builder().applyMutation(listAssessmentTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client.listAssessmentTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client
     *             .listAssessmentTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client.listAssessmentTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTemplates
     * @see #listAssessmentTemplatesPaginator(ListAssessmentTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesIterable listAssessmentTemplatesPaginator() throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listAssessmentTemplatesPaginator(ListAssessmentTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client.listAssessmentTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client
     *             .listAssessmentTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client.listAssessmentTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesIterable listAssessmentTemplatesPaginator(
            ListAssessmentTemplatesRequest listAssessmentTemplatesRequest) throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the
     * assessment targets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client.listAssessmentTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client
     *             .listAssessmentTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListAssessmentTemplatesIterable responses = client.listAssessmentTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssessmentTemplates(software.amazon.awssdk.services.inspector.model.ListAssessmentTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssessmentTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssessmentTemplatesRequest#builder()}
     * </p>
     *
     * @param listAssessmentTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssessmentTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListAssessmentTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListAssessmentTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssessmentTemplatesIterable listAssessmentTemplatesPaginator(
            Consumer<ListAssessmentTemplatesRequest.Builder> listAssessmentTemplatesRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listAssessmentTemplatesPaginator(ListAssessmentTemplatesRequest.builder()
                .applyMutation(listAssessmentTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     *
     * @return Result of the ListEventSubscriptions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListEventSubscriptions
     * @see #listEventSubscriptions(ListEventSubscriptionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsResponse listEventSubscriptions() throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listEventSubscriptions(ListEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     *
     * @param listEventSubscriptionsRequest
     * @return Result of the ListEventSubscriptions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsResponse listEventSubscriptions(ListEventSubscriptionsRequest listEventSubscriptionsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSubscriptionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventSubscriptions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsResponse listEventSubscriptions(
            Consumer<ListEventSubscriptionsRequest.Builder> listEventSubscriptionsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listEventSubscriptions(ListEventSubscriptionsRequest.builder().applyMutation(listEventSubscriptionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client.listEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client
     *             .listEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client.listEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListEventSubscriptions
     * @see #listEventSubscriptionsPaginator(ListEventSubscriptionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsIterable listEventSubscriptionsPaginator() throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listEventSubscriptionsPaginator(ListEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client.listEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client
     *             .listEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client.listEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsIterable listEventSubscriptionsPaginator(
            ListEventSubscriptionsRequest listEventSubscriptionsRequest) throws InternalException, InvalidInputException,
            AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment
     * template. For more information, see <a>SubscribeToEvent</a> and <a>UnsubscribeFromEvent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client.listEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client
     *             .listEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListEventSubscriptionsIterable responses = client.listEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSubscriptions(software.amazon.awssdk.services.inspector.model.ListEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSubscriptionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListEventSubscriptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventSubscriptionsIterable listEventSubscriptionsPaginator(
            Consumer<ListEventSubscriptionsRequest.Builder> listEventSubscriptionsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listEventSubscriptionsPaginator(ListEventSubscriptionsRequest.builder()
                .applyMutation(listEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     *
     * @param listExclusionsRequest
     * @return Result of the ListExclusions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListExclusions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExclusionsResponse listExclusions(ListExclusionsRequest listExclusionsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExclusionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExclusionsRequest#builder()}
     * </p>
     *
     * @param listExclusionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExclusionsRequest.Builder} to create a request.
     * @return Result of the ListExclusions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListExclusions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExclusionsResponse listExclusions(Consumer<ListExclusionsRequest.Builder> listExclusionsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        return listExclusions(ListExclusionsRequest.builder().applyMutation(listExclusionsRequest).build());
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable responses = client.listExclusionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable responses = client
     *             .listExclusionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListExclusionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable responses = client.listExclusionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation.</b>
     * </p>
     *
     * @param listExclusionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListExclusions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExclusionsIterable listExclusionsPaginator(ListExclusionsRequest listExclusionsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List exclusions that are generated by the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable responses = client.listExclusionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable responses = client
     *             .listExclusionsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListExclusionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListExclusionsIterable responses = client.listExclusionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExclusions(software.amazon.awssdk.services.inspector.model.ListExclusionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExclusionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExclusionsRequest#builder()}
     * </p>
     *
     * @param listExclusionsRequest
     *        A {@link Consumer} that will call methods on {@link ListExclusionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListExclusions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListExclusions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExclusionsIterable listExclusionsPaginator(Consumer<ListExclusionsRequest.Builder> listExclusionsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        return listExclusionsPaginator(ListExclusionsRequest.builder().applyMutation(listExclusionsRequest).build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @return Result of the ListFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListFindings
     * @see #listFindings(ListFindingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings() throws InternalException, InvalidInputException, AccessDeniedException,
            NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listFindings(ListFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     *
     * @param listFindingsRequest
     * @return Result of the ListFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return Result of the ListFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsResponse listFindings(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        return listFindings(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListFindings
     * @see #listFindingsPaginator(ListFindingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator() throws InternalException, InvalidInputException, AccessDeniedException,
            NoSuchEntityException, AwsServiceException, SdkClientException, InspectorException {
        return listFindingsPaginator(ListFindingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListFindingsIterable responses = client.listFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindings(software.amazon.awssdk.services.inspector.model.ListFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFindingsRequest#builder()}
     * </p>
     *
     * @param listFindingsRequest
     *        A {@link Consumer} that will call methods on {@link ListFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFindingsIterable listFindingsPaginator(Consumer<ListFindingsRequest.Builder> listFindingsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        return listFindingsPaginator(ListFindingsRequest.builder().applyMutation(listFindingsRequest).build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     *
     * @return Result of the ListRulesPackages operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListRulesPackages
     * @see #listRulesPackages(ListRulesPackagesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesResponse listRulesPackages() throws InternalException, InvalidInputException, AccessDeniedException,
            AwsServiceException, SdkClientException, InspectorException {
        return listRulesPackages(ListRulesPackagesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     *
     * @param listRulesPackagesRequest
     * @return Result of the ListRulesPackages operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListRulesPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesResponse listRulesPackages(ListRulesPackagesRequest listRulesPackagesRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesPackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRulesPackagesRequest#builder()}
     * </p>
     *
     * @param listRulesPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesPackagesRequest.Builder} to create a request.
     * @return Result of the ListRulesPackages operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListRulesPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesResponse listRulesPackages(Consumer<ListRulesPackagesRequest.Builder> listRulesPackagesRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException,
            InspectorException {
        return listRulesPackages(ListRulesPackagesRequest.builder().applyMutation(listRulesPackagesRequest).build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client.listRulesPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client
     *             .listRulesPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client.listRulesPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListRulesPackages
     * @see #listRulesPackagesPaginator(ListRulesPackagesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesIterable listRulesPackagesPaginator() throws InternalException, InvalidInputException,
            AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        return listRulesPackagesPaginator(ListRulesPackagesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client.listRulesPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client
     *             .listRulesPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client.listRulesPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRulesPackagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListRulesPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesIterable listRulesPackagesPaginator(ListRulesPackagesRequest listRulesPackagesRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, AwsServiceException, SdkClientException,
            InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all available Amazon Inspector rules packages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client.listRulesPackagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client
     *             .listRulesPackagesPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.ListRulesPackagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.ListRulesPackagesIterable responses = client.listRulesPackagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRulesPackages(software.amazon.awssdk.services.inspector.model.ListRulesPackagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesPackagesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRulesPackagesRequest#builder()}
     * </p>
     *
     * @param listRulesPackagesRequest
     *        A {@link Consumer} that will call methods on {@link ListRulesPackagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListRulesPackages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListRulesPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRulesPackagesIterable listRulesPackagesPaginator(
            Consumer<ListRulesPackagesRequest.Builder> listRulesPackagesRequest) throws InternalException, InvalidInputException,
            AccessDeniedException, AwsServiceException, SdkClientException, InspectorException {
        return listRulesPackagesPaginator(ListRulesPackagesRequest.builder().applyMutation(listRulesPackagesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with an assessment template.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException,
            SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with an assessment template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, AwsServiceException, SdkClientException,
            InspectorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     *
     * @param previewAgentsRequest
     * @return Result of the PreviewAgents operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.PreviewAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default PreviewAgentsResponse previewAgents(PreviewAgentsRequest previewAgentsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, InvalidCrossAccountRoleException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PreviewAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link PreviewAgentsRequest#builder()}
     * </p>
     *
     * @param previewAgentsRequest
     *        A {@link Consumer} that will call methods on {@link PreviewAgentsRequest.Builder} to create a request.
     * @return Result of the PreviewAgents operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.PreviewAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default PreviewAgentsResponse previewAgents(Consumer<PreviewAgentsRequest.Builder> previewAgentsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            InvalidCrossAccountRoleException, AwsServiceException, SdkClientException, InspectorException {
        return previewAgents(PreviewAgentsRequest.builder().applyMutation(previewAgentsRequest).build());
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable responses = client.previewAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable responses = client.previewAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable responses = client.previewAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)} operation.</b>
     * </p>
     *
     * @param previewAgentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.PreviewAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default PreviewAgentsIterable previewAgentsPaginator(PreviewAgentsRequest previewAgentsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, InvalidCrossAccountRoleException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable responses = client.previewAgentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable responses = client.previewAgentsPaginator(request);
     *     for (software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.inspector.paginators.PreviewAgentsIterable responses = client.previewAgentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #previewAgents(software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link PreviewAgentsRequest.Builder} avoiding the need to
     * create one manually via {@link PreviewAgentsRequest#builder()}
     * </p>
     *
     * @param previewAgentsRequest
     *        A {@link Consumer} that will call methods on {@link PreviewAgentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.PreviewAgents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/PreviewAgents" target="_top">AWS API
     *      Documentation</a>
     */
    default PreviewAgentsIterable previewAgentsPaginator(Consumer<PreviewAgentsRequest.Builder> previewAgentsRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            InvalidCrossAccountRoleException, AwsServiceException, SdkClientException, InspectorException {
        return previewAgentsPaginator(PreviewAgentsRequest.builder().applyMutation(previewAgentsRequest).build());
    }

    /**
     * <p>
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security
     * assessments.
     * </p>
     *
     * @param registerCrossAccountAccessRoleRequest
     * @return Result of the RegisterCrossAccountAccessRole operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.RegisterCrossAccountAccessRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterCrossAccountAccessRoleResponse registerCrossAccountAccessRole(
            RegisterCrossAccountAccessRoleRequest registerCrossAccountAccessRoleRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, InvalidCrossAccountRoleException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security
     * assessments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterCrossAccountAccessRoleRequest.Builder}
     * avoiding the need to create one manually via {@link RegisterCrossAccountAccessRoleRequest#builder()}
     * </p>
     *
     * @param registerCrossAccountAccessRoleRequest
     *        A {@link Consumer} that will call methods on {@link RegisterCrossAccountAccessRoleRequest.Builder} to
     *        create a request.
     * @return Result of the RegisterCrossAccountAccessRole operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.RegisterCrossAccountAccessRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RegisterCrossAccountAccessRole"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterCrossAccountAccessRoleResponse registerCrossAccountAccessRole(
            Consumer<RegisterCrossAccountAccessRoleRequest.Builder> registerCrossAccountAccessRoleRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, InvalidCrossAccountRoleException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return registerCrossAccountAccessRole(RegisterCrossAccountAccessRoleRequest.builder()
                .applyMutation(registerCrossAccountAccessRoleRequest).build());
    }

    /**
     * <p>
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings
     * where an attribute with the specified key exists.
     * </p>
     *
     * @param removeAttributesFromFindingsRequest
     * @return Result of the RemoveAttributesFromFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.RemoveAttributesFromFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RemoveAttributesFromFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAttributesFromFindingsResponse removeAttributesFromFindings(
            RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings
     * where an attribute with the specified key exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAttributesFromFindingsRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveAttributesFromFindingsRequest#builder()}
     * </p>
     *
     * @param removeAttributesFromFindingsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAttributesFromFindingsRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveAttributesFromFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.RemoveAttributesFromFindings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/RemoveAttributesFromFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveAttributesFromFindingsResponse removeAttributesFromFindings(
            Consumer<RemoveAttributesFromFindingsRequest.Builder> removeAttributesFromFindingsRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        return removeAttributesFromFindings(RemoveAttributesFromFindingsRequest.builder()
                .applyMutation(removeAttributesFromFindingsRequest).build());
    }

    /**
     * <p>
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment
     * template.
     * </p>
     *
     * @param setTagsForResourceRequest
     * @return Result of the SetTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.SetTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SetTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default SetTagsForResourceResponse setTagsForResource(SetTagsForResourceRequest setTagsForResourceRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment
     * template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link SetTagsForResourceRequest#builder()}
     * </p>
     *
     * @param setTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link SetTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the SetTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.SetTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SetTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default SetTagsForResourceResponse setTagsForResource(Consumer<SetTagsForResourceRequest.Builder> setTagsForResourceRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return setTagsForResource(SetTagsForResourceRequest.builder().applyMutation(setTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you
     * must not exceed the limit of running up to 500 concurrent agents per AWS account.
     * </p>
     *
     * @param startAssessmentRunRequest
     * @return Result of the StartAssessmentRun operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws AgentsAlreadyRunningAssessmentException
     *         You started an assessment run, but one of the instances is already participating in another assessment
     *         run.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.StartAssessmentRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StartAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartAssessmentRunResponse startAssessmentRun(StartAssessmentRunRequest startAssessmentRunRequest)
            throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException,
            NoSuchEntityException, InvalidCrossAccountRoleException, AgentsAlreadyRunningAssessmentException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you
     * must not exceed the limit of running up to 500 concurrent agents per AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAssessmentRunRequest.Builder} avoiding the
     * need to create one manually via {@link StartAssessmentRunRequest#builder()}
     * </p>
     *
     * @param startAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link StartAssessmentRunRequest.Builder} to create a
     *        request.
     * @return Result of the StartAssessmentRun operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws InvalidCrossAccountRoleException
     *         Amazon Inspector cannot assume the cross-account role that it needs to list your EC2 instances during the
     *         assessment run.
     * @throws AgentsAlreadyRunningAssessmentException
     *         You started an assessment run, but one of the instances is already participating in another assessment
     *         run.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.StartAssessmentRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StartAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StartAssessmentRunResponse startAssessmentRun(Consumer<StartAssessmentRunRequest.Builder> startAssessmentRunRequest)
            throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException,
            NoSuchEntityException, InvalidCrossAccountRoleException, AgentsAlreadyRunningAssessmentException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return startAssessmentRun(StartAssessmentRunRequest.builder().applyMutation(startAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Stops the assessment run that is specified by the ARN of the assessment run.
     * </p>
     *
     * @param stopAssessmentRunRequest
     * @return Result of the StopAssessmentRun operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.StopAssessmentRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StopAssessmentRunResponse stopAssessmentRun(StopAssessmentRunRequest stopAssessmentRunRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the assessment run that is specified by the ARN of the assessment run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopAssessmentRunRequest.Builder} avoiding the need
     * to create one manually via {@link StopAssessmentRunRequest#builder()}
     * </p>
     *
     * @param stopAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link StopAssessmentRunRequest.Builder} to create a request.
     * @return Result of the StopAssessmentRun operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.StopAssessmentRun
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/StopAssessmentRun" target="_top">AWS
     *      API Documentation</a>
     */
    default StopAssessmentRunResponse stopAssessmentRun(Consumer<StopAssessmentRunRequest.Builder> stopAssessmentRunRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        return stopAssessmentRun(StopAssessmentRunRequest.builder().applyMutation(stopAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     *
     * @param subscribeToEventRequest
     * @return Result of the SubscribeToEvent operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.SubscribeToEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default SubscribeToEventResponse subscribeToEvent(SubscribeToEventRequest subscribeToEventRequest) throws InternalException,
            InvalidInputException, LimitExceededException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubscribeToEventRequest.Builder} avoiding the need
     * to create one manually via {@link SubscribeToEventRequest#builder()}
     * </p>
     *
     * @param subscribeToEventRequest
     *        A {@link Consumer} that will call methods on {@link SubscribeToEventRequest.Builder} to create a request.
     * @return Result of the SubscribeToEvent operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account limits.
     *         The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.SubscribeToEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/SubscribeToEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default SubscribeToEventResponse subscribeToEvent(Consumer<SubscribeToEventRequest.Builder> subscribeToEventRequest)
            throws InternalException, InvalidInputException, LimitExceededException, AccessDeniedException,
            NoSuchEntityException, ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException,
            InspectorException {
        return subscribeToEvent(SubscribeToEventRequest.builder().applyMutation(subscribeToEventRequest).build());
    }

    /**
     * <p>
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     *
     * @param unsubscribeFromEventRequest
     * @return Result of the UnsubscribeFromEvent operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.UnsubscribeFromEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default UnsubscribeFromEventResponse unsubscribeFromEvent(UnsubscribeFromEventRequest unsubscribeFromEventRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to
     * a specified SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnsubscribeFromEventRequest.Builder} avoiding the
     * need to create one manually via {@link UnsubscribeFromEventRequest#builder()}
     * </p>
     *
     * @param unsubscribeFromEventRequest
     *        A {@link Consumer} that will call methods on {@link UnsubscribeFromEventRequest.Builder} to create a
     *        request.
     * @return Result of the UnsubscribeFromEvent operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.UnsubscribeFromEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UnsubscribeFromEvent" target="_top">AWS
     *      API Documentation</a>
     */
    default UnsubscribeFromEventResponse unsubscribeFromEvent(
            Consumer<UnsubscribeFromEventRequest.Builder> unsubscribeFromEventRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        return unsubscribeFromEvent(UnsubscribeFromEventRequest.builder().applyMutation(unsubscribeFromEventRequest).build());
    }

    /**
     * <p>
     * Updates the assessment target that is specified by the ARN of the assessment target.
     * </p>
     * <p>
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the
     * assessment target.
     * </p>
     *
     * @param updateAssessmentTargetRequest
     * @return Result of the UpdateAssessmentTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.UpdateAssessmentTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UpdateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentTargetResponse updateAssessmentTarget(UpdateAssessmentTargetRequest updateAssessmentTargetRequest)
            throws InternalException, InvalidInputException, AccessDeniedException, NoSuchEntityException,
            ServiceTemporarilyUnavailableException, AwsServiceException, SdkClientException, InspectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the assessment target that is specified by the ARN of the assessment target.
     * </p>
     * <p>
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the
     * assessment target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAssessmentTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAssessmentTargetRequest#builder()}
     * </p>
     *
     * @param updateAssessmentTargetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAssessmentTargetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAssessmentTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws AccessDeniedException
     *         You do not have required permissions to access the requested resource.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced an entity that does not exist. The error code describes
     *         the entity.
     * @throws ServiceTemporarilyUnavailableException
     *         The serice is temporary unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws InspectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample InspectorClient.UpdateAssessmentTarget
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/UpdateAssessmentTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAssessmentTargetResponse updateAssessmentTarget(
            Consumer<UpdateAssessmentTargetRequest.Builder> updateAssessmentTargetRequest) throws InternalException,
            InvalidInputException, AccessDeniedException, NoSuchEntityException, ServiceTemporarilyUnavailableException,
            AwsServiceException, SdkClientException, InspectorException {
        return updateAssessmentTarget(UpdateAssessmentTargetRequest.builder().applyMutation(updateAssessmentTargetRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("inspector");
    }
}
