/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Amazon Inspector agent. This data type is used as a request parameter in the
 * <a>ListAssessmentRunAgents</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentFilter implements SdkPojo, Serializable, ToCopyableBuilder<AgentFilter.Builder, AgentFilter> {
    private static final SdkField<List<String>> AGENT_HEALTHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AgentFilter::agentHealthsAsStrings))
            .setter(setter(Builder::agentHealthsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AGENT_HEALTH_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AgentFilter::agentHealthCodesAsStrings))
            .setter(setter(Builder::agentHealthCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHealthCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_HEALTHS_FIELD,
            AGENT_HEALTH_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> agentHealths;

    private final List<String> agentHealthCodes;

    private AgentFilter(BuilderImpl builder) {
        this.agentHealths = builder.agentHealths;
        this.agentHealthCodes = builder.agentHealthCodes;
    }

    /**
     * <p>
     * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     */
    public List<AgentHealth> agentHealths() {
        return TypeConverter.convert(agentHealths, AgentHealth::fromValue);
    }

    /**
     * <p>
     * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
     */
    public List<String> agentHealthsAsStrings() {
        return agentHealths;
    }

    /**
     * <p>
     * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
     * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
     *         <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     */
    public List<AgentHealthCode> agentHealthCodes() {
        return TypeConverter.convert(agentHealthCodes, AgentHealthCode::fromValue);
    }

    /**
     * <p>
     * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
     * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
     *         <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
     */
    public List<String> agentHealthCodesAsStrings() {
        return agentHealthCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentHealthsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(agentHealthCodesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentFilter)) {
            return false;
        }
        AgentFilter other = (AgentFilter) obj;
        return Objects.equals(agentHealthsAsStrings(), other.agentHealthsAsStrings())
                && Objects.equals(agentHealthCodesAsStrings(), other.agentHealthCodesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AgentFilter").add("AgentHealths", agentHealthsAsStrings())
                .add("AgentHealthCodes", agentHealthCodesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentHealths":
            return Optional.ofNullable(clazz.cast(agentHealthsAsStrings()));
        case "agentHealthCodes":
            return Optional.ofNullable(clazz.cast(agentHealthCodesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentFilter, T> g) {
        return obj -> g.apply((AgentFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentFilter> {
        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthsWithStrings(Collection<String> agentHealths);

        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthsWithStrings(String... agentHealths);

        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealths(Collection<AgentHealth> agentHealths);

        /**
         * <p>
         * The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * </p>
         * 
         * @param agentHealths
         *        The current health state of the agent. Values can be set to <b>HEALTHY</b> or <b>UNHEALTHY</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealths(AgentHealth... agentHealths);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodesWithStrings(Collection<String> agentHealthCodes);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodesWithStrings(String... agentHealthCodes);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodes(Collection<AgentHealthCode> agentHealthCodes);

        /**
         * <p>
         * The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>, <b>SHUTDOWN</b>,
         * <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * </p>
         * 
         * @param agentHealthCodes
         *        The detailed health state of the agent. Values can be set to <b>IDLE</b>, <b>RUNNING</b>,
         *        <b>SHUTDOWN</b>, <b>UNHEALTHY</b>, <b>THROTTLED</b>, and <b>UNKNOWN</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHealthCodes(AgentHealthCode... agentHealthCodes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> agentHealths = DefaultSdkAutoConstructList.getInstance();

        private List<String> agentHealthCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentFilter model) {
            agentHealthsWithStrings(model.agentHealths);
            agentHealthCodesWithStrings(model.agentHealthCodes);
        }

        public final Collection<String> getAgentHealthsAsStrings() {
            return agentHealths;
        }

        @Override
        public final Builder agentHealthsWithStrings(Collection<String> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copy(agentHealths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentHealthsWithStrings(String... agentHealths) {
            agentHealthsWithStrings(Arrays.asList(agentHealths));
            return this;
        }

        @Override
        public final Builder agentHealths(Collection<AgentHealth> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copyEnumToString(agentHealths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentHealths(AgentHealth... agentHealths) {
            agentHealths(Arrays.asList(agentHealths));
            return this;
        }

        public final void setAgentHealthsWithStrings(Collection<String> agentHealths) {
            this.agentHealths = AgentHealthListCopier.copy(agentHealths);
        }

        public final Collection<String> getAgentHealthCodesAsStrings() {
            return agentHealthCodes;
        }

        @Override
        public final Builder agentHealthCodesWithStrings(Collection<String> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copy(agentHealthCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentHealthCodesWithStrings(String... agentHealthCodes) {
            agentHealthCodesWithStrings(Arrays.asList(agentHealthCodes));
            return this;
        }

        @Override
        public final Builder agentHealthCodes(Collection<AgentHealthCode> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copyEnumToString(agentHealthCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentHealthCodes(AgentHealthCode... agentHealthCodes) {
            agentHealthCodes(Arrays.asList(agentHealthCodes));
            return this;
        }

        public final void setAgentHealthCodesWithStrings(Collection<String> agentHealthCodes) {
            this.agentHealthCodes = AgentHealthCodeListCopier.copy(agentHealthCodes);
        }

        @Override
        public AgentFilter build() {
            return new AgentFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
