/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssessmentTemplatesResponse extends InspectorResponse implements
        ToCopyableBuilder<ListAssessmentTemplatesResponse.Builder, ListAssessmentTemplatesResponse> {
    private static final SdkField<List<String>> ASSESSMENT_TEMPLATE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListAssessmentTemplatesResponse::assessmentTemplateArns))
            .setter(setter(Builder::assessmentTemplateArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAssessmentTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSESSMENT_TEMPLATE_ARNS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> assessmentTemplateArns;

    private final String nextToken;

    private ListAssessmentTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArns = builder.assessmentTemplateArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of ARNs that specifies the assessment templates returned by the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of ARNs that specifies the assessment templates returned by the action.
     */
    public List<String> assessmentTemplateArns() {
        return assessmentTemplateArns;
    }

    /**
     * <p>
     * When a response is generated, if there is more data to be listed, this parameter is present in the response and
     * contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there is no
     * more data to be listed, this parameter is set to null.
     * </p>
     * 
     * @return When a response is generated, if there is more data to be listed, this parameter is present in the
     *         response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
     *         request. If there is no more data to be listed, this parameter is set to null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTemplateArns());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentTemplatesResponse)) {
            return false;
        }
        ListAssessmentTemplatesResponse other = (ListAssessmentTemplatesResponse) obj;
        return Objects.equals(assessmentTemplateArns(), other.assessmentTemplateArns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAssessmentTemplatesResponse").add("AssessmentTemplateArns", assessmentTemplateArns())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTemplateArns":
            return Optional.ofNullable(clazz.cast(assessmentTemplateArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentTemplatesResponse, T> g) {
        return obj -> g.apply((ListAssessmentTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssessmentTemplatesResponse> {
        /**
         * <p>
         * A list of ARNs that specifies the assessment templates returned by the action.
         * </p>
         * 
         * @param assessmentTemplateArns
         *        A list of ARNs that specifies the assessment templates returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTemplateArns(Collection<String> assessmentTemplateArns);

        /**
         * <p>
         * A list of ARNs that specifies the assessment templates returned by the action.
         * </p>
         * 
         * @param assessmentTemplateArns
         *        A list of ARNs that specifies the assessment templates returned by the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTemplateArns(String... assessmentTemplateArns);

        /**
         * <p>
         * When a response is generated, if there is more data to be listed, this parameter is present in the response
         * and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination request. If there
         * is no more data to be listed, this parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        When a response is generated, if there is more data to be listed, this parameter is present in the
         *        response and contains the value to use for the <b>nextToken</b> parameter in a subsequent pagination
         *        request. If there is no more data to be listed, this parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<String> assessmentTemplateArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentTemplatesResponse model) {
            super(model);
            assessmentTemplateArns(model.assessmentTemplateArns);
            nextToken(model.nextToken);
        }

        public final Collection<String> getAssessmentTemplateArns() {
            return assessmentTemplateArns;
        }

        @Override
        public final Builder assessmentTemplateArns(Collection<String> assessmentTemplateArns) {
            this.assessmentTemplateArns = ListReturnedArnListCopier.copy(assessmentTemplateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTemplateArns(String... assessmentTemplateArns) {
            assessmentTemplateArns(Arrays.asList(assessmentTemplateArns));
            return this;
        }

        public final void setAssessmentTemplateArns(Collection<String> assessmentTemplateArns) {
            this.assessmentTemplateArns = ListReturnedArnListCopier.copy(assessmentTemplateArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAssessmentTemplatesResponse build() {
            return new ListAssessmentTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
