/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used as the request parameter in the <a>ListAssessmentRuns</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentRunFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentRunFilter.Builder, AssessmentRunFilter> {
    private static final SdkField<String> NAME_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssessmentRunFilter::namePattern)).setter(setter(Builder::namePattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namePattern").build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AssessmentRunFilter::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DurationRange> DURATION_RANGE_FIELD = SdkField
            .<DurationRange> builder(MarshallingType.SDK_POJO).getter(getter(AssessmentRunFilter::durationRange))
            .setter(setter(Builder::durationRange)).constructor(DurationRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationRange").build()).build();

    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AssessmentRunFilter::rulesPackageArns))
            .setter(setter(Builder::rulesPackageArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimestampRange> START_TIME_RANGE_FIELD = SdkField
            .<TimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(AssessmentRunFilter::startTimeRange))
            .setter(setter(Builder::startTimeRange)).constructor(TimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeRange").build()).build();

    private static final SdkField<TimestampRange> COMPLETION_TIME_RANGE_FIELD = SdkField
            .<TimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(AssessmentRunFilter::completionTimeRange))
            .setter(setter(Builder::completionTimeRange)).constructor(TimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTimeRange").build())
            .build();

    private static final SdkField<TimestampRange> STATE_CHANGE_TIME_RANGE_FIELD = SdkField
            .<TimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(AssessmentRunFilter::stateChangeTimeRange))
            .setter(setter(Builder::stateChangeTimeRange)).constructor(TimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeTimeRange").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PATTERN_FIELD,
            STATES_FIELD, DURATION_RANGE_FIELD, RULES_PACKAGE_ARNS_FIELD, START_TIME_RANGE_FIELD, COMPLETION_TIME_RANGE_FIELD,
            STATE_CHANGE_TIME_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namePattern;

    private final List<String> states;

    private final DurationRange durationRange;

    private final List<String> rulesPackageArns;

    private final TimestampRange startTimeRange;

    private final TimestampRange completionTimeRange;

    private final TimestampRange stateChangeTimeRange;

    private AssessmentRunFilter(BuilderImpl builder) {
        this.namePattern = builder.namePattern;
        this.states = builder.states;
        this.durationRange = builder.durationRange;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.startTimeRange = builder.startTimeRange;
        this.completionTimeRange = builder.completionTimeRange;
        this.stateChangeTimeRange = builder.stateChangeTimeRange;
    }

    /**
     * <p>
     * For a record to match a filter, an explicit value or a string containing a wildcard that is specified for this
     * data type property must match the value of the <b>assessmentRunName</b> property of the <a>AssessmentRun</a> data
     * type.
     * </p>
     * 
     * @return For a record to match a filter, an explicit value or a string containing a wildcard that is specified for
     *         this data type property must match the value of the <b>assessmentRunName</b> property of the
     *         <a>AssessmentRun</a> data type.
     */
    public String namePattern() {
        return namePattern;
    }

    /**
     * <p>
     * For a record to match a filter, one of the values specified for this data type property must be the exact match
     * of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a record to match a filter, one of the values specified for this data type property must be the exact
     *         match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
     */
    public List<AssessmentRunState> states() {
        return AssessmentRunStateListCopier.copyStringToEnum(states);
    }

    /**
     * <p>
     * For a record to match a filter, one of the values specified for this data type property must be the exact match
     * of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a record to match a filter, one of the values specified for this data type property must be the exact
     *         match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
     */
    public List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * For a record to match a filter, the value that is specified for this data type property must inclusively match
     * any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the
     * <a>AssessmentRun</a> data type.
     * </p>
     * 
     * @return For a record to match a filter, the value that is specified for this data type property must inclusively
     *         match any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property
     *         of the <a>AssessmentRun</a> data type.
     */
    public DurationRange durationRange() {
        return durationRange;
    }

    /**
     * <p>
     * For a record to match a filter, the value that is specified for this data type property must be contained in the
     * list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a record to match a filter, the value that is specified for this data type property must be contained
     *         in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data type.
     */
    public List<String> rulesPackageArns() {
        return rulesPackageArns;
    }

    /**
     * <p>
     * For a record to match a filter, the value that is specified for this data type property must inclusively match
     * any value between the specified minimum and maximum values of the <b>startTime</b> property of the
     * <a>AssessmentRun</a> data type.
     * </p>
     * 
     * @return For a record to match a filter, the value that is specified for this data type property must inclusively
     *         match any value between the specified minimum and maximum values of the <b>startTime</b> property of the
     *         <a>AssessmentRun</a> data type.
     */
    public TimestampRange startTimeRange() {
        return startTimeRange;
    }

    /**
     * <p>
     * For a record to match a filter, the value that is specified for this data type property must inclusively match
     * any value between the specified minimum and maximum values of the <b>completedAt</b> property of the
     * <a>AssessmentRun</a> data type.
     * </p>
     * 
     * @return For a record to match a filter, the value that is specified for this data type property must inclusively
     *         match any value between the specified minimum and maximum values of the <b>completedAt</b> property of
     *         the <a>AssessmentRun</a> data type.
     */
    public TimestampRange completionTimeRange() {
        return completionTimeRange;
    }

    /**
     * <p>
     * For a record to match a filter, the value that is specified for this data type property must match the
     * <b>stateChangedAt</b> property of the <a>AssessmentRun</a> data type.
     * </p>
     * 
     * @return For a record to match a filter, the value that is specified for this data type property must match the
     *         <b>stateChangedAt</b> property of the <a>AssessmentRun</a> data type.
     */
    public TimestampRange stateChangeTimeRange() {
        return stateChangeTimeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namePattern());
        hashCode = 31 * hashCode + Objects.hashCode(statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(durationRange());
        hashCode = 31 * hashCode + Objects.hashCode(rulesPackageArns());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(completionTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(stateChangeTimeRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentRunFilter)) {
            return false;
        }
        AssessmentRunFilter other = (AssessmentRunFilter) obj;
        return Objects.equals(namePattern(), other.namePattern()) && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && Objects.equals(durationRange(), other.durationRange())
                && Objects.equals(rulesPackageArns(), other.rulesPackageArns())
                && Objects.equals(startTimeRange(), other.startTimeRange())
                && Objects.equals(completionTimeRange(), other.completionTimeRange())
                && Objects.equals(stateChangeTimeRange(), other.stateChangeTimeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssessmentRunFilter").add("NamePattern", namePattern()).add("States", statesAsStrings())
                .add("DurationRange", durationRange()).add("RulesPackageArns", rulesPackageArns())
                .add("StartTimeRange", startTimeRange()).add("CompletionTimeRange", completionTimeRange())
                .add("StateChangeTimeRange", stateChangeTimeRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namePattern":
            return Optional.ofNullable(clazz.cast(namePattern()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "durationRange":
            return Optional.ofNullable(clazz.cast(durationRange()));
        case "rulesPackageArns":
            return Optional.ofNullable(clazz.cast(rulesPackageArns()));
        case "startTimeRange":
            return Optional.ofNullable(clazz.cast(startTimeRange()));
        case "completionTimeRange":
            return Optional.ofNullable(clazz.cast(completionTimeRange()));
        case "stateChangeTimeRange":
            return Optional.ofNullable(clazz.cast(stateChangeTimeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentRunFilter, T> g) {
        return obj -> g.apply((AssessmentRunFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentRunFilter> {
        /**
         * <p>
         * For a record to match a filter, an explicit value or a string containing a wildcard that is specified for
         * this data type property must match the value of the <b>assessmentRunName</b> property of the
         * <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param namePattern
         *        For a record to match a filter, an explicit value or a string containing a wildcard that is specified
         *        for this data type property must match the value of the <b>assessmentRunName</b> property of the
         *        <a>AssessmentRun</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePattern(String namePattern);

        /**
         * <p>
         * For a record to match a filter, one of the values specified for this data type property must be the exact
         * match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param states
         *        For a record to match a filter, one of the values specified for this data type property must be the
         *        exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * For a record to match a filter, one of the values specified for this data type property must be the exact
         * match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param states
         *        For a record to match a filter, one of the values specified for this data type property must be the
         *        exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * For a record to match a filter, one of the values specified for this data type property must be the exact
         * match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param states
         *        For a record to match a filter, one of the values specified for this data type property must be the
         *        exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<AssessmentRunState> states);

        /**
         * <p>
         * For a record to match a filter, one of the values specified for this data type property must be the exact
         * match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param states
         *        For a record to match a filter, one of the values specified for this data type property must be the
         *        exact match of the value of the <b>assessmentRunState</b> property of the <a>AssessmentRun</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(AssessmentRunState... states);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must inclusively
         * match any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of
         * the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param durationRange
         *        For a record to match a filter, the value that is specified for this data type property must
         *        inclusively match any value between the specified minimum and maximum values of the
         *        <b>durationInSeconds</b> property of the <a>AssessmentRun</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationRange(DurationRange durationRange);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must inclusively
         * match any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of
         * the <a>AssessmentRun</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link DurationRange.Builder} avoiding the need to
         * create one manually via {@link DurationRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DurationRange.Builder#build()} is called immediately and its
         * result is passed to {@link #durationRange(DurationRange)}.
         * 
         * @param durationRange
         *        a consumer that will call methods on {@link DurationRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #durationRange(DurationRange)
         */
        default Builder durationRange(Consumer<DurationRange.Builder> durationRange) {
            return durationRange(DurationRange.builder().applyMutation(durationRange).build());
        }

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must be contained in
         * the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param rulesPackageArns
         *        For a record to match a filter, the value that is specified for this data type property must be
         *        contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(Collection<String> rulesPackageArns);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must be contained in
         * the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param rulesPackageArns
         *        For a record to match a filter, the value that is specified for this data type property must be
         *        contained in the list of values of the <b>rulesPackages</b> property of the <a>AssessmentRun</a> data
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(String... rulesPackageArns);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must inclusively
         * match any value between the specified minimum and maximum values of the <b>startTime</b> property of the
         * <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param startTimeRange
         *        For a record to match a filter, the value that is specified for this data type property must
         *        inclusively match any value between the specified minimum and maximum values of the <b>startTime</b>
         *        property of the <a>AssessmentRun</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeRange(TimestampRange startTimeRange);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must inclusively
         * match any value between the specified minimum and maximum values of the <b>startTime</b> property of the
         * <a>AssessmentRun</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampRange.Builder} avoiding the need to
         * create one manually via {@link TimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #startTimeRange(TimestampRange)}.
         * 
         * @param startTimeRange
         *        a consumer that will call methods on {@link TimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startTimeRange(TimestampRange)
         */
        default Builder startTimeRange(Consumer<TimestampRange.Builder> startTimeRange) {
            return startTimeRange(TimestampRange.builder().applyMutation(startTimeRange).build());
        }

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must inclusively
         * match any value between the specified minimum and maximum values of the <b>completedAt</b> property of the
         * <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param completionTimeRange
         *        For a record to match a filter, the value that is specified for this data type property must
         *        inclusively match any value between the specified minimum and maximum values of the <b>completedAt</b>
         *        property of the <a>AssessmentRun</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTimeRange(TimestampRange completionTimeRange);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must inclusively
         * match any value between the specified minimum and maximum values of the <b>completedAt</b> property of the
         * <a>AssessmentRun</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampRange.Builder} avoiding the need to
         * create one manually via {@link TimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #completionTimeRange(TimestampRange)}.
         * 
         * @param completionTimeRange
         *        a consumer that will call methods on {@link TimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionTimeRange(TimestampRange)
         */
        default Builder completionTimeRange(Consumer<TimestampRange.Builder> completionTimeRange) {
            return completionTimeRange(TimestampRange.builder().applyMutation(completionTimeRange).build());
        }

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must match the
         * <b>stateChangedAt</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * 
         * @param stateChangeTimeRange
         *        For a record to match a filter, the value that is specified for this data type property must match the
         *        <b>stateChangedAt</b> property of the <a>AssessmentRun</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateChangeTimeRange(TimestampRange stateChangeTimeRange);

        /**
         * <p>
         * For a record to match a filter, the value that is specified for this data type property must match the
         * <b>stateChangedAt</b> property of the <a>AssessmentRun</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampRange.Builder} avoiding the need to
         * create one manually via {@link TimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #stateChangeTimeRange(TimestampRange)}.
         * 
         * @param stateChangeTimeRange
         *        a consumer that will call methods on {@link TimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateChangeTimeRange(TimestampRange)
         */
        default Builder stateChangeTimeRange(Consumer<TimestampRange.Builder> stateChangeTimeRange) {
            return stateChangeTimeRange(TimestampRange.builder().applyMutation(stateChangeTimeRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String namePattern;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private DurationRange durationRange;

        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private TimestampRange startTimeRange;

        private TimestampRange completionTimeRange;

        private TimestampRange stateChangeTimeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentRunFilter model) {
            namePattern(model.namePattern);
            statesWithStrings(model.states);
            durationRange(model.durationRange);
            rulesPackageArns(model.rulesPackageArns);
            startTimeRange(model.startTimeRange);
            completionTimeRange(model.completionTimeRange);
            stateChangeTimeRange(model.stateChangeTimeRange);
        }

        public final String getNamePattern() {
            return namePattern;
        }

        @Override
        public final Builder namePattern(String namePattern) {
            this.namePattern = namePattern;
            return this;
        }

        public final void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }

        public final Collection<String> getStatesAsStrings() {
            return states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = AssessmentRunStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<AssessmentRunState> states) {
            this.states = AssessmentRunStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(AssessmentRunState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final void setStatesWithStrings(Collection<String> states) {
            this.states = AssessmentRunStateListCopier.copy(states);
        }

        public final DurationRange.Builder getDurationRange() {
            return durationRange != null ? durationRange.toBuilder() : null;
        }

        @Override
        public final Builder durationRange(DurationRange durationRange) {
            this.durationRange = durationRange;
            return this;
        }

        public final void setDurationRange(DurationRange.BuilderImpl durationRange) {
            this.durationRange = durationRange != null ? durationRange.build() : null;
        }

        public final Collection<String> getRulesPackageArns() {
            return rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String... rulesPackageArns) {
            rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final TimestampRange.Builder getStartTimeRange() {
            return startTimeRange != null ? startTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder startTimeRange(TimestampRange startTimeRange) {
            this.startTimeRange = startTimeRange;
            return this;
        }

        public final void setStartTimeRange(TimestampRange.BuilderImpl startTimeRange) {
            this.startTimeRange = startTimeRange != null ? startTimeRange.build() : null;
        }

        public final TimestampRange.Builder getCompletionTimeRange() {
            return completionTimeRange != null ? completionTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder completionTimeRange(TimestampRange completionTimeRange) {
            this.completionTimeRange = completionTimeRange;
            return this;
        }

        public final void setCompletionTimeRange(TimestampRange.BuilderImpl completionTimeRange) {
            this.completionTimeRange = completionTimeRange != null ? completionTimeRange.build() : null;
        }

        public final TimestampRange.Builder getStateChangeTimeRange() {
            return stateChangeTimeRange != null ? stateChangeTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeTimeRange(TimestampRange stateChangeTimeRange) {
            this.stateChangeTimeRange = stateChangeTimeRange;
            return this;
        }

        public final void setStateChangeTimeRange(TimestampRange.BuilderImpl stateChangeTimeRange) {
            this.stateChangeTimeRange = stateChangeTimeRange != null ? stateChangeTimeRange.build() : null;
        }

        @Override
        public AssessmentRunFilter build() {
            return new AssessmentRunFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
