/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used as the request parameter in the <a>ListAssessmentTemplates</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentTemplateFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentTemplateFilter.Builder, AssessmentTemplateFilter> {
    private static final SdkField<String> NAME_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssessmentTemplateFilter::namePattern)).setter(setter(Builder::namePattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namePattern").build()).build();

    private static final SdkField<DurationRange> DURATION_RANGE_FIELD = SdkField
            .<DurationRange> builder(MarshallingType.SDK_POJO).getter(getter(AssessmentTemplateFilter::durationRange))
            .setter(setter(Builder::durationRange)).constructor(DurationRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationRange").build()).build();

    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AssessmentTemplateFilter::rulesPackageArns))
            .setter(setter(Builder::rulesPackageArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PATTERN_FIELD,
            DURATION_RANGE_FIELD, RULES_PACKAGE_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namePattern;

    private final DurationRange durationRange;

    private final List<String> rulesPackageArns;

    private AssessmentTemplateFilter(BuilderImpl builder) {
        this.namePattern = builder.namePattern;
        this.durationRange = builder.durationRange;
        this.rulesPackageArns = builder.rulesPackageArns;
    }

    /**
     * <p>
     * For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this
     * data type property must match the value of the <b>assessmentTemplateName</b> property of the
     * <a>AssessmentTemplate</a> data type.
     * </p>
     * 
     * @return For a record to match a filter, an explicit value or a string that contains a wildcard that is specified
     *         for this data type property must match the value of the <b>assessmentTemplateName</b> property of the
     *         <a>AssessmentTemplate</a> data type.
     */
    public String namePattern() {
        return namePattern;
    }

    /**
     * <p>
     * For a record to match a filter, the value specified for this data type property must inclusively match any value
     * between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the
     * <a>AssessmentTemplate</a> data type.
     * </p>
     * 
     * @return For a record to match a filter, the value specified for this data type property must inclusively match
     *         any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of
     *         the <a>AssessmentTemplate</a> data type.
     */
    public DurationRange durationRange() {
        return durationRange;
    }

    /**
     * <p>
     * For a record to match a filter, the values that are specified for this data type property must be contained in
     * the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For a record to match a filter, the values that are specified for this data type property must be
     *         contained in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a>
     *         data type.
     */
    public List<String> rulesPackageArns() {
        return rulesPackageArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namePattern());
        hashCode = 31 * hashCode + Objects.hashCode(durationRange());
        hashCode = 31 * hashCode + Objects.hashCode(rulesPackageArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentTemplateFilter)) {
            return false;
        }
        AssessmentTemplateFilter other = (AssessmentTemplateFilter) obj;
        return Objects.equals(namePattern(), other.namePattern()) && Objects.equals(durationRange(), other.durationRange())
                && Objects.equals(rulesPackageArns(), other.rulesPackageArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssessmentTemplateFilter").add("NamePattern", namePattern())
                .add("DurationRange", durationRange()).add("RulesPackageArns", rulesPackageArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namePattern":
            return Optional.ofNullable(clazz.cast(namePattern()));
        case "durationRange":
            return Optional.ofNullable(clazz.cast(durationRange()));
        case "rulesPackageArns":
            return Optional.ofNullable(clazz.cast(rulesPackageArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentTemplateFilter, T> g) {
        return obj -> g.apply((AssessmentTemplateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentTemplateFilter> {
        /**
         * <p>
         * For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for
         * this data type property must match the value of the <b>assessmentTemplateName</b> property of the
         * <a>AssessmentTemplate</a> data type.
         * </p>
         * 
         * @param namePattern
         *        For a record to match a filter, an explicit value or a string that contains a wildcard that is
         *        specified for this data type property must match the value of the <b>assessmentTemplateName</b>
         *        property of the <a>AssessmentTemplate</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePattern(String namePattern);

        /**
         * <p>
         * For a record to match a filter, the value specified for this data type property must inclusively match any
         * value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the
         * <a>AssessmentTemplate</a> data type.
         * </p>
         * 
         * @param durationRange
         *        For a record to match a filter, the value specified for this data type property must inclusively match
         *        any value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of
         *        the <a>AssessmentTemplate</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationRange(DurationRange durationRange);

        /**
         * <p>
         * For a record to match a filter, the value specified for this data type property must inclusively match any
         * value between the specified minimum and maximum values of the <b>durationInSeconds</b> property of the
         * <a>AssessmentTemplate</a> data type.
         * </p>
         * This is a convenience that creates an instance of the {@link DurationRange.Builder} avoiding the need to
         * create one manually via {@link DurationRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DurationRange.Builder#build()} is called immediately and its
         * result is passed to {@link #durationRange(DurationRange)}.
         * 
         * @param durationRange
         *        a consumer that will call methods on {@link DurationRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #durationRange(DurationRange)
         */
        default Builder durationRange(Consumer<DurationRange.Builder> durationRange) {
            return durationRange(DurationRange.builder().applyMutation(durationRange).build());
        }

        /**
         * <p>
         * For a record to match a filter, the values that are specified for this data type property must be contained
         * in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data type.
         * </p>
         * 
         * @param rulesPackageArns
         *        For a record to match a filter, the values that are specified for this data type property must be
         *        contained in the list of values of the <b>rulesPackageArns</b> property of the
         *        <a>AssessmentTemplate</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(Collection<String> rulesPackageArns);

        /**
         * <p>
         * For a record to match a filter, the values that are specified for this data type property must be contained
         * in the list of values of the <b>rulesPackageArns</b> property of the <a>AssessmentTemplate</a> data type.
         * </p>
         * 
         * @param rulesPackageArns
         *        For a record to match a filter, the values that are specified for this data type property must be
         *        contained in the list of values of the <b>rulesPackageArns</b> property of the
         *        <a>AssessmentTemplate</a> data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(String... rulesPackageArns);
    }

    static final class BuilderImpl implements Builder {
        private String namePattern;

        private DurationRange durationRange;

        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentTemplateFilter model) {
            namePattern(model.namePattern);
            durationRange(model.durationRange);
            rulesPackageArns(model.rulesPackageArns);
        }

        public final String getNamePattern() {
            return namePattern;
        }

        @Override
        public final Builder namePattern(String namePattern) {
            this.namePattern = namePattern;
            return this;
        }

        public final void setNamePattern(String namePattern) {
            this.namePattern = namePattern;
        }

        public final DurationRange.Builder getDurationRange() {
            return durationRange != null ? durationRange.toBuilder() : null;
        }

        @Override
        public final Builder durationRange(DurationRange durationRange) {
            this.durationRange = durationRange;
            return this;
        }

        public final void setDurationRange(DurationRange.BuilderImpl durationRange) {
            this.durationRange = durationRange != null ? durationRange.build() : null;
        }

        public final Collection<String> getRulesPackageArns() {
            return rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String... rulesPackageArns) {
            rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = FilterRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        @Override
        public AssessmentTemplateFilter build() {
            return new AssessmentTemplateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
