/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentTargetResponse extends InspectorResponse implements
        ToCopyableBuilder<CreateAssessmentTargetResponse.Builder, CreateAssessmentTargetResponse> {
    private static final SdkField<String> ASSESSMENT_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAssessmentTargetResponse::assessmentTargetArn)).setter(setter(Builder::assessmentTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARN_FIELD));

    private final String assessmentTargetArn;

    private CreateAssessmentTargetResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArn = builder.assessmentTargetArn;
    }

    /**
     * <p>
     * The ARN that specifies the assessment target that is created.
     * </p>
     * 
     * @return The ARN that specifies the assessment target that is created.
     */
    public String assessmentTargetArn() {
        return assessmentTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTargetArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentTargetResponse)) {
            return false;
        }
        CreateAssessmentTargetResponse other = (CreateAssessmentTargetResponse) obj;
        return Objects.equals(assessmentTargetArn(), other.assessmentTargetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAssessmentTargetResponse").add("AssessmentTargetArn", assessmentTargetArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargetArn":
            return Optional.ofNullable(clazz.cast(assessmentTargetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentTargetResponse, T> g) {
        return obj -> g.apply((CreateAssessmentTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssessmentTargetResponse> {
        /**
         * <p>
         * The ARN that specifies the assessment target that is created.
         * </p>
         * 
         * @param assessmentTargetArn
         *        The ARN that specifies the assessment target that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArn(String assessmentTargetArn);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private String assessmentTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentTargetResponse model) {
            super(model);
            assessmentTargetArn(model.assessmentTargetArn);
        }

        public final String getAssessmentTargetArn() {
            return assessmentTargetArn;
        }

        @Override
        public final Builder assessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
            return this;
        }

        public final void setAssessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
        }

        @Override
        public CreateAssessmentTargetResponse build() {
            return new CreateAssessmentTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
