/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssessmentRunsResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeAssessmentRunsResponse.Builder, DescribeAssessmentRunsResponse> {
    private static final SdkField<List<AssessmentRun>> ASSESSMENT_RUNS_FIELD = SdkField
            .<List<AssessmentRun>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssessmentRunsResponse::assessmentRuns))
            .setter(setter(Builder::assessmentRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField
            .<Map<String, FailedItemDetails>> builder(MarshallingType.MAP)
            .getter(getter(DescribeAssessmentRunsResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailedItemDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItemDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUNS_FIELD,
            FAILED_ITEMS_FIELD));

    private final List<AssessmentRun> assessmentRuns;

    private final Map<String, FailedItemDetails> failedItems;

    private DescribeAssessmentRunsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentRuns = builder.assessmentRuns;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * Information about the assessment run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the assessment run.
     */
    public List<AssessmentRun> assessmentRuns() {
        return assessmentRuns;
    }

    /**
     * <p>
     * Assessment run details that cannot be described. An error code is provided for each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Assessment run details that cannot be described. An error code is provided for each failed item.
     */
    public Map<String, FailedItemDetails> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRuns());
        hashCode = 31 * hashCode + Objects.hashCode(failedItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentRunsResponse)) {
            return false;
        }
        DescribeAssessmentRunsResponse other = (DescribeAssessmentRunsResponse) obj;
        return Objects.equals(assessmentRuns(), other.assessmentRuns()) && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAssessmentRunsResponse").add("AssessmentRuns", assessmentRuns())
                .add("FailedItems", failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRuns":
            return Optional.ofNullable(clazz.cast(assessmentRuns()));
        case "failedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentRunsResponse, T> g) {
        return obj -> g.apply((DescribeAssessmentRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAssessmentRunsResponse> {
        /**
         * <p>
         * Information about the assessment run.
         * </p>
         * 
         * @param assessmentRuns
         *        Information about the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRuns(Collection<AssessmentRun> assessmentRuns);

        /**
         * <p>
         * Information about the assessment run.
         * </p>
         * 
         * @param assessmentRuns
         *        Information about the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRuns(AssessmentRun... assessmentRuns);

        /**
         * <p>
         * Information about the assessment run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssessmentRun>.Builder} avoiding the need
         * to create one manually via {@link List<AssessmentRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentRun>.Builder#build()} is called immediately and
         * its result is passed to {@link #assessmentRuns(List<AssessmentRun>)}.
         * 
         * @param assessmentRuns
         *        a consumer that will call methods on {@link List<AssessmentRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentRuns(List<AssessmentRun>)
         */
        Builder assessmentRuns(Consumer<AssessmentRun.Builder>... assessmentRuns);

        /**
         * <p>
         * Assessment run details that cannot be described. An error code is provided for each failed item.
         * </p>
         * 
         * @param failedItems
         *        Assessment run details that cannot be described. An error code is provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Map<String, FailedItemDetails> failedItems);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<AssessmentRun> assessmentRuns = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentRunsResponse model) {
            super(model);
            assessmentRuns(model.assessmentRuns);
            failedItems(model.failedItems);
        }

        public final Collection<AssessmentRun.Builder> getAssessmentRuns() {
            return assessmentRuns != null ? assessmentRuns.stream().map(AssessmentRun::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder assessmentRuns(Collection<AssessmentRun> assessmentRuns) {
            this.assessmentRuns = AssessmentRunListCopier.copy(assessmentRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRuns(AssessmentRun... assessmentRuns) {
            assessmentRuns(Arrays.asList(assessmentRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRuns(Consumer<AssessmentRun.Builder>... assessmentRuns) {
            assessmentRuns(Stream.of(assessmentRuns).map(c -> AssessmentRun.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssessmentRuns(Collection<AssessmentRun.BuilderImpl> assessmentRuns) {
            this.assessmentRuns = AssessmentRunListCopier.copyFromBuilder(assessmentRuns);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return failedItems != null ? CollectionUtils.mapValues(failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeAssessmentRunsResponse build() {
            return new DescribeAssessmentRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
