/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopAssessmentRunRequest extends InspectorRequest implements
        ToCopyableBuilder<StopAssessmentRunRequest.Builder, StopAssessmentRunRequest> {
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopAssessmentRunRequest::assessmentRunArn)).setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final SdkField<String> STOP_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StopAssessmentRunRequest::stopActionAsString)).setter(setter(Builder::stopAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARN_FIELD,
            STOP_ACTION_FIELD));

    private final String assessmentRunArn;

    private final String stopAction;

    private StopAssessmentRunRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArn = builder.assessmentRunArn;
        this.stopAction = builder.stopAction;
    }

    /**
     * <p>
     * The ARN of the assessment run that you want to stop.
     * </p>
     * 
     * @return The ARN of the assessment run that you want to stop.
     */
    public String assessmentRunArn() {
        return assessmentRunArn;
    }

    /**
     * <p>
     * An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default
     * value), stops the AWS agent from collecting data and begins the results evaluation and the findings generation
     * process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopAction} will
     * return {@link StopAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopActionAsString}.
     * </p>
     * 
     * @return An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the
     *         default value), stops the AWS agent from collecting data and begins the results evaluation and the
     *         findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no
     *         findings are generated.
     * @see StopAction
     */
    public StopAction stopAction() {
        return StopAction.fromValue(stopAction);
    }

    /**
     * <p>
     * An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default
     * value), stops the AWS agent from collecting data and begins the results evaluation and the findings generation
     * process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopAction} will
     * return {@link StopAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopActionAsString}.
     * </p>
     * 
     * @return An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the
     *         default value), stops the AWS agent from collecting data and begins the results evaluation and the
     *         findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no
     *         findings are generated.
     * @see StopAction
     */
    public String stopActionAsString() {
        return stopAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(stopActionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopAssessmentRunRequest)) {
            return false;
        }
        StopAssessmentRunRequest other = (StopAssessmentRunRequest) obj;
        return Objects.equals(assessmentRunArn(), other.assessmentRunArn())
                && Objects.equals(stopActionAsString(), other.stopActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StopAssessmentRunRequest").add("AssessmentRunArn", assessmentRunArn())
                .add("StopAction", stopActionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        case "stopAction":
            return Optional.ofNullable(clazz.cast(stopActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopAssessmentRunRequest, T> g) {
        return obj -> g.apply((StopAssessmentRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopAssessmentRunRequest> {
        /**
         * <p>
         * The ARN of the assessment run that you want to stop.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN of the assessment run that you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);

        /**
         * <p>
         * An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default
         * value), stops the AWS agent from collecting data and begins the results evaluation and the findings
         * generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are
         * generated.
         * </p>
         * 
         * @param stopAction
         *        An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the
         *        default value), stops the AWS agent from collecting data and begins the results evaluation and the
         *        findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no
         *        findings are generated.
         * @see StopAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopAction
         */
        Builder stopAction(String stopAction);

        /**
         * <p>
         * An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the default
         * value), stops the AWS agent from collecting data and begins the results evaluation and the findings
         * generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no findings are
         * generated.
         * </p>
         * 
         * @param stopAction
         *        An input option that can be set to either START_EVALUATION or SKIP_EVALUATION. START_EVALUATION (the
         *        default value), stops the AWS agent from collecting data and begins the results evaluation and the
         *        findings generation process. SKIP_EVALUATION cancels the assessment run immediately, after which no
         *        findings are generated.
         * @see StopAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopAction
         */
        Builder stopAction(StopAction stopAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentRunArn;

        private String stopAction;

        private BuilderImpl() {
        }

        private BuilderImpl(StopAssessmentRunRequest model) {
            super(model);
            assessmentRunArn(model.assessmentRunArn);
            stopAction(model.stopAction);
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        public final String getStopActionAsString() {
            return stopAction;
        }

        @Override
        public final Builder stopAction(String stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        @Override
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction(stopAction.toString());
            return this;
        }

        public final void setStopAction(String stopAction) {
            this.stopAction = stopAction;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopAssessmentRunRequest build() {
            return new StopAssessmentRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
