/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReportFileFormat {
    HTML("HTML"),
    PDF("PDF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReportFileFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportFileFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReportFileFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportFileFormat> knownValues() {
        return Stream.of(ReportFileFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

