/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ScopeType {
    INSTANCE_ID("INSTANCE_ID"),
    RULES_PACKAGE_ARN("RULES_PACKAGE_ARN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScopeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScopeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScopeType> knownValues() {
        return Stream.of(ScopeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

