/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector.model.InspectorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssessmentRunRequest
extends InspectorRequest
implements ToCopyableBuilder<Builder, StartAssessmentRunRequest> {
    private static final SdkField<String> ASSESSMENT_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAssessmentRunRequest.getter(StartAssessmentRunRequest::assessmentTemplateArn)).setter(StartAssessmentRunRequest.setter(Builder::assessmentTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_RUN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartAssessmentRunRequest.getter(StartAssessmentRunRequest::assessmentRunName)).setter(StartAssessmentRunRequest.setter(Builder::assessmentRunName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TEMPLATE_ARN_FIELD, ASSESSMENT_RUN_NAME_FIELD));
    private final String assessmentTemplateArn;
    private final String assessmentRunName;

    private StartAssessmentRunRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTemplateArn = builder.assessmentTemplateArn;
        this.assessmentRunName = builder.assessmentRunName;
    }

    public String assessmentTemplateArn() {
        return this.assessmentTemplateArn;
    }

    public String assessmentRunName() {
        return this.assessmentRunName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentRunRequest)) {
            return false;
        }
        StartAssessmentRunRequest other = (StartAssessmentRunRequest)((Object)obj);
        return Objects.equals(this.assessmentTemplateArn(), other.assessmentTemplateArn()) && Objects.equals(this.assessmentRunName(), other.assessmentRunName());
    }

    public String toString() {
        return ToString.builder((String)"StartAssessmentRunRequest").add("AssessmentTemplateArn", (Object)this.assessmentTemplateArn()).add("AssessmentRunName", (Object)this.assessmentRunName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentTemplateArn()));
            }
            case "assessmentRunName": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentRunRequest, T> g) {
        return obj -> g.apply((StartAssessmentRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends InspectorRequest.BuilderImpl
    implements Builder {
        private String assessmentTemplateArn;
        private String assessmentRunName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentRunRequest model) {
            super(model);
            this.assessmentTemplateArn(model.assessmentTemplateArn);
            this.assessmentRunName(model.assessmentRunName);
        }

        public final String getAssessmentTemplateArn() {
            return this.assessmentTemplateArn;
        }

        @Override
        public final Builder assessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
            return this;
        }

        public final void setAssessmentTemplateArn(String assessmentTemplateArn) {
            this.assessmentTemplateArn = assessmentTemplateArn;
        }

        public final String getAssessmentRunName() {
            return this.assessmentRunName;
        }

        @Override
        public final Builder assessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
            return this;
        }

        public final void setAssessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentRunRequest build() {
            return new StartAssessmentRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends InspectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssessmentRunRequest> {
        public Builder assessmentTemplateArn(String var1);

        public Builder assessmentRunName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

