/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceGroupRequest extends InspectorRequest implements
        ToCopyableBuilder<CreateResourceGroupRequest.Builder, CreateResourceGroupRequest> {
    private static final SdkField<List<ResourceGroupTag>> RESOURCE_GROUP_TAGS_FIELD = SdkField
            .<List<ResourceGroupTag>> builder(MarshallingType.LIST)
            .getter(getter(CreateResourceGroupRequest::resourceGroupTags))
            .setter(setter(Builder::resourceGroupTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceGroupTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceGroupTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_TAGS_FIELD));

    private final List<ResourceGroupTag> resourceGroupTags;

    private CreateResourceGroupRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupTags = builder.resourceGroupTags;
    }

    /**
     * <p>
     * A collection of keys and an array of possible values,
     * '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.
     * </p>
     * <p>
     * For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A collection of keys and an array of possible values,
     *         '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
     *         <p>
     *         For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
     */
    public List<ResourceGroupTag> resourceGroupTags() {
        return resourceGroupTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupTags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceGroupRequest)) {
            return false;
        }
        CreateResourceGroupRequest other = (CreateResourceGroupRequest) obj;
        return Objects.equals(resourceGroupTags(), other.resourceGroupTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateResourceGroupRequest").add("ResourceGroupTags", resourceGroupTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceGroupTags":
            return Optional.ofNullable(clazz.cast(resourceGroupTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceGroupRequest, T> g) {
        return obj -> g.apply((CreateResourceGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceGroupRequest> {
        /**
         * <p>
         * A collection of keys and an array of possible values,
         * '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.
         * </p>
         * <p>
         * For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
         * </p>
         * 
         * @param resourceGroupTags
         *        A collection of keys and an array of possible values,
         *        '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
         *        <p>
         *        For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupTags(Collection<ResourceGroupTag> resourceGroupTags);

        /**
         * <p>
         * A collection of keys and an array of possible values,
         * '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.
         * </p>
         * <p>
         * For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
         * </p>
         * 
         * @param resourceGroupTags
         *        A collection of keys and an array of possible values,
         *        '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.</p>
         *        <p>
         *        For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupTags(ResourceGroupTag... resourceGroupTags);

        /**
         * <p>
         * A collection of keys and an array of possible values,
         * '[{"key":"key1","values":["Value1","Value2"]},{"key":"Key2","values":["Value3"]}]'.
         * </p>
         * <p>
         * For example,'[{"key":"Name","values":["TestEC2Instance"]}]'.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceGroupTag>.Builder} avoiding the
         * need to create one manually via {@link List<ResourceGroupTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceGroupTag>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceGroupTags(List<ResourceGroupTag>)}.
         * 
         * @param resourceGroupTags
         *        a consumer that will call methods on {@link List<ResourceGroupTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceGroupTags(List<ResourceGroupTag>)
         */
        Builder resourceGroupTags(Consumer<ResourceGroupTag.Builder>... resourceGroupTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<ResourceGroupTag> resourceGroupTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceGroupRequest model) {
            super(model);
            resourceGroupTags(model.resourceGroupTags);
        }

        public final Collection<ResourceGroupTag.Builder> getResourceGroupTags() {
            return resourceGroupTags != null ? resourceGroupTags.stream().map(ResourceGroupTag::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceGroupTags(Collection<ResourceGroupTag> resourceGroupTags) {
            this.resourceGroupTags = ResourceGroupTagsCopier.copy(resourceGroupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupTags(ResourceGroupTag... resourceGroupTags) {
            resourceGroupTags(Arrays.asList(resourceGroupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupTags(Consumer<ResourceGroupTag.Builder>... resourceGroupTags) {
            resourceGroupTags(Stream.of(resourceGroupTags).map(c -> ResourceGroupTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceGroupTags(Collection<ResourceGroupTag.BuilderImpl> resourceGroupTags) {
            this.resourceGroupTags = ResourceGroupTagsCopier.copyFromBuilder(resourceGroupTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceGroupRequest build() {
            return new CreateResourceGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
