/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssessmentTargetsRequest extends InspectorRequest implements
        ToCopyableBuilder<DescribeAssessmentTargetsRequest.Builder, DescribeAssessmentTargetsRequest> {
    private static final SdkField<List<String>> ASSESSMENT_TARGET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssessmentTargetsRequest::assessmentTargetArns))
            .setter(setter(Builder::assessmentTargetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARNS_FIELD));

    private final List<String> assessmentTargetArns;

    private DescribeAssessmentTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArns = builder.assessmentTargetArns;
    }

    /**
     * <p>
     * The ARNs that specifies the assessment targets that you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ARNs that specifies the assessment targets that you want to describe.
     */
    public List<String> assessmentTargetArns() {
        return assessmentTargetArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTargetArns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTargetsRequest)) {
            return false;
        }
        DescribeAssessmentTargetsRequest other = (DescribeAssessmentTargetsRequest) obj;
        return Objects.equals(assessmentTargetArns(), other.assessmentTargetArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAssessmentTargetsRequest").add("AssessmentTargetArns", assessmentTargetArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargetArns":
            return Optional.ofNullable(clazz.cast(assessmentTargetArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentTargetsRequest, T> g) {
        return obj -> g.apply((DescribeAssessmentTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssessmentTargetsRequest> {
        /**
         * <p>
         * The ARNs that specifies the assessment targets that you want to describe.
         * </p>
         * 
         * @param assessmentTargetArns
         *        The ARNs that specifies the assessment targets that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArns(Collection<String> assessmentTargetArns);

        /**
         * <p>
         * The ARNs that specifies the assessment targets that you want to describe.
         * </p>
         * 
         * @param assessmentTargetArns
         *        The ARNs that specifies the assessment targets that you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArns(String... assessmentTargetArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<String> assessmentTargetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentTargetsRequest model) {
            super(model);
            assessmentTargetArns(model.assessmentTargetArns);
        }

        public final Collection<String> getAssessmentTargetArns() {
            return assessmentTargetArns;
        }

        @Override
        public final Builder assessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = BatchDescribeArnListCopier.copy(assessmentTargetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargetArns(String... assessmentTargetArns) {
            assessmentTargetArns(Arrays.asList(assessmentTargetArns));
            return this;
        }

        public final void setAssessmentTargetArns(Collection<String> assessmentTargetArns) {
            this.assessmentTargetArns = BatchDescribeArnListCopier.copy(assessmentTargetArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssessmentTargetsRequest build() {
            return new DescribeAssessmentTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
