/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssessmentReportRequest extends InspectorRequest implements
        ToCopyableBuilder<GetAssessmentReportRequest.Builder, GetAssessmentReportRequest> {
    private static final SdkField<String> ASSESSMENT_RUN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssessmentReportRequest::assessmentRunArn)).setter(setter(Builder::assessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArn").build()).build();

    private static final SdkField<String> REPORT_FILE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssessmentReportRequest::reportFileFormatAsString)).setter(setter(Builder::reportFileFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFileFormat").build()).build();

    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAssessmentReportRequest::reportTypeAsString)).setter(setter(Builder::reportType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARN_FIELD,
            REPORT_FILE_FORMAT_FIELD, REPORT_TYPE_FIELD));

    private final String assessmentRunArn;

    private final String reportFileFormat;

    private final String reportType;

    private GetAssessmentReportRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArn = builder.assessmentRunArn;
        this.reportFileFormat = builder.reportFileFormat;
        this.reportType = builder.reportType;
    }

    /**
     * <p>
     * The ARN that specifies the assessment run for which you want to generate a report.
     * </p>
     * 
     * @return The ARN that specifies the assessment run for which you want to generate a report.
     */
    public String assessmentRunArn() {
        return assessmentRunArn;
    }

    /**
     * <p>
     * Specifies the file format (html or pdf) of the assessment report that you want to generate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFileFormat}
     * will return {@link ReportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportFileFormatAsString}.
     * </p>
     * 
     * @return Specifies the file format (html or pdf) of the assessment report that you want to generate.
     * @see ReportFileFormat
     */
    public ReportFileFormat reportFileFormat() {
        return ReportFileFormat.fromValue(reportFileFormat);
    }

    /**
     * <p>
     * Specifies the file format (html or pdf) of the assessment report that you want to generate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportFileFormat}
     * will return {@link ReportFileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reportFileFormatAsString}.
     * </p>
     * 
     * @return Specifies the file format (html or pdf) of the assessment report that you want to generate.
     * @see ReportFileFormat
     */
    public String reportFileFormatAsString() {
        return reportFileFormat;
    }

    /**
     * <p>
     * Specifies the type of the assessment report that you want to generate. There are two types of assessment reports:
     * a finding report and a full report. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportType} will
     * return {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the assessment report that you want to generate. There are two types of assessment
     *         reports: a finding report and a full report. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment
     *         Reports</a>.
     * @see ReportType
     */
    public ReportType reportType() {
        return ReportType.fromValue(reportType);
    }

    /**
     * <p>
     * Specifies the type of the assessment report that you want to generate. There are two types of assessment reports:
     * a finding report and a full report. For more information, see <a
     * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reportType} will
     * return {@link ReportType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reportTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of the assessment report that you want to generate. There are two types of assessment
     *         reports: a finding report and a full report. For more information, see <a
     *         href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment
     *         Reports</a>.
     * @see ReportType
     */
    public String reportTypeAsString() {
        return reportType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(reportFileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reportTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentReportRequest)) {
            return false;
        }
        GetAssessmentReportRequest other = (GetAssessmentReportRequest) obj;
        return Objects.equals(assessmentRunArn(), other.assessmentRunArn())
                && Objects.equals(reportFileFormatAsString(), other.reportFileFormatAsString())
                && Objects.equals(reportTypeAsString(), other.reportTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAssessmentReportRequest").add("AssessmentRunArn", assessmentRunArn())
                .add("ReportFileFormat", reportFileFormatAsString()).add("ReportType", reportTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunArn":
            return Optional.ofNullable(clazz.cast(assessmentRunArn()));
        case "reportFileFormat":
            return Optional.ofNullable(clazz.cast(reportFileFormatAsString()));
        case "reportType":
            return Optional.ofNullable(clazz.cast(reportTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentReportRequest, T> g) {
        return obj -> g.apply((GetAssessmentReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAssessmentReportRequest> {
        /**
         * <p>
         * The ARN that specifies the assessment run for which you want to generate a report.
         * </p>
         * 
         * @param assessmentRunArn
         *        The ARN that specifies the assessment run for which you want to generate a report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArn(String assessmentRunArn);

        /**
         * <p>
         * Specifies the file format (html or pdf) of the assessment report that you want to generate.
         * </p>
         * 
         * @param reportFileFormat
         *        Specifies the file format (html or pdf) of the assessment report that you want to generate.
         * @see ReportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFileFormat
         */
        Builder reportFileFormat(String reportFileFormat);

        /**
         * <p>
         * Specifies the file format (html or pdf) of the assessment report that you want to generate.
         * </p>
         * 
         * @param reportFileFormat
         *        Specifies the file format (html or pdf) of the assessment report that you want to generate.
         * @see ReportFileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFileFormat
         */
        Builder reportFileFormat(ReportFileFormat reportFileFormat);

        /**
         * <p>
         * Specifies the type of the assessment report that you want to generate. There are two types of assessment
         * reports: a finding report and a full report. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>.
         * </p>
         * 
         * @param reportType
         *        Specifies the type of the assessment report that you want to generate. There are two types of
         *        assessment reports: a finding report and a full report. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment
         *        Reports</a>.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder reportType(String reportType);

        /**
         * <p>
         * Specifies the type of the assessment report that you want to generate. There are two types of assessment
         * reports: a finding report and a full report. For more information, see <a
         * href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment Reports</a>.
         * </p>
         * 
         * @param reportType
         *        Specifies the type of the assessment report that you want to generate. There are two types of
         *        assessment reports: a finding report and a full report. For more information, see <a
         *        href="https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html">Assessment
         *        Reports</a>.
         * @see ReportType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportType
         */
        Builder reportType(ReportType reportType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentRunArn;

        private String reportFileFormat;

        private String reportType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentReportRequest model) {
            super(model);
            assessmentRunArn(model.assessmentRunArn);
            reportFileFormat(model.reportFileFormat);
            reportType(model.reportType);
        }

        public final String getAssessmentRunArn() {
            return assessmentRunArn;
        }

        @Override
        public final Builder assessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
            return this;
        }

        public final void setAssessmentRunArn(String assessmentRunArn) {
            this.assessmentRunArn = assessmentRunArn;
        }

        public final String getReportFileFormatAsString() {
            return reportFileFormat;
        }

        @Override
        public final Builder reportFileFormat(String reportFileFormat) {
            this.reportFileFormat = reportFileFormat;
            return this;
        }

        @Override
        public final Builder reportFileFormat(ReportFileFormat reportFileFormat) {
            this.reportFileFormat(reportFileFormat.toString());
            return this;
        }

        public final void setReportFileFormat(String reportFileFormat) {
            this.reportFileFormat = reportFileFormat;
        }

        public final String getReportTypeAsString() {
            return reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        @Override
        public final Builder reportType(ReportType reportType) {
            this.reportType(reportType.toString());
            return this;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssessmentReportRequest build() {
            return new GetAssessmentReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
