/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnsubscribeFromEventRequest extends InspectorRequest implements
        ToCopyableBuilder<UnsubscribeFromEventRequest.Builder, UnsubscribeFromEventRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnsubscribeFromEventRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnsubscribeFromEventRequest::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnsubscribeFromEventRequest::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            EVENT_FIELD, TOPIC_ARN_FIELD));

    private final String resourceArn;

    private final String event;

    private final String topicArn;

    private UnsubscribeFromEventRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.event = builder.event;
        this.topicArn = builder.topicArn;
    }

    /**
     * <p>
     * The ARN of the assessment template that is used during the event for which you want to stop receiving SNS
     * notifications.
     * </p>
     * 
     * @return The ARN of the assessment template that is used during the event for which you want to stop receiving SNS
     *         notifications.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The event for which you want to stop receiving SNS notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link InspectorEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event for which you want to stop receiving SNS notifications.
     * @see InspectorEvent
     */
    public InspectorEvent event() {
        return InspectorEvent.fromValue(event);
    }

    /**
     * <p>
     * The event for which you want to stop receiving SNS notifications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link InspectorEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return The event for which you want to stop receiving SNS notifications.
     * @see InspectorEvent
     */
    public String eventAsString() {
        return event;
    }

    /**
     * <p>
     * The ARN of the SNS topic to which SNS notifications are sent.
     * </p>
     * 
     * @return The ARN of the SNS topic to which SNS notifications are sent.
     */
    public String topicArn() {
        return topicArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsubscribeFromEventRequest)) {
            return false;
        }
        UnsubscribeFromEventRequest other = (UnsubscribeFromEventRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(eventAsString(), other.eventAsString())
                && Objects.equals(topicArn(), other.topicArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnsubscribeFromEventRequest").add("ResourceArn", resourceArn()).add("Event", eventAsString())
                .add("TopicArn", topicArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "topicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnsubscribeFromEventRequest, T> g) {
        return obj -> g.apply((UnsubscribeFromEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UnsubscribeFromEventRequest> {
        /**
         * <p>
         * The ARN of the assessment template that is used during the event for which you want to stop receiving SNS
         * notifications.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the assessment template that is used during the event for which you want to stop receiving
         *        SNS notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The event for which you want to stop receiving SNS notifications.
         * </p>
         * 
         * @param event
         *        The event for which you want to stop receiving SNS notifications.
         * @see InspectorEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectorEvent
         */
        Builder event(String event);

        /**
         * <p>
         * The event for which you want to stop receiving SNS notifications.
         * </p>
         * 
         * @param event
         *        The event for which you want to stop receiving SNS notifications.
         * @see InspectorEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InspectorEvent
         */
        Builder event(InspectorEvent event);

        /**
         * <p>
         * The ARN of the SNS topic to which SNS notifications are sent.
         * </p>
         * 
         * @param topicArn
         *        The ARN of the SNS topic to which SNS notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String event;

        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsubscribeFromEventRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            event(model.event);
            topicArn(model.topicArn);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getEventAsString() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(InspectorEvent event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnsubscribeFromEventRequest build() {
            return new UnsubscribeFromEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
