/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssessmentTemplateRequest extends InspectorRequest implements
        ToCopyableBuilder<CreateAssessmentTemplateRequest.Builder, CreateAssessmentTemplateRequest> {
    private static final SdkField<String> ASSESSMENT_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAssessmentTemplateRequest::assessmentTargetArn)).setter(setter(Builder::assessmentTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargetArn").build())
            .build();

    private static final SdkField<String> ASSESSMENT_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateAssessmentTemplateRequest::assessmentTemplateName))
            .setter(setter(Builder::assessmentTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTemplateName").build())
            .build();

    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateAssessmentTemplateRequest::durationInSeconds)).setter(setter(Builder::durationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInSeconds").build()).build();

    private static final SdkField<List<String>> RULES_PACKAGE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateAssessmentTemplateRequest::rulesPackageArns))
            .setter(setter(Builder::rulesPackageArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rulesPackageArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> USER_ATTRIBUTES_FOR_FINDINGS_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .getter(getter(CreateAssessmentTemplateRequest::userAttributesForFindings))
            .setter(setter(Builder::userAttributesForFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttributesForFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGET_ARN_FIELD,
            ASSESSMENT_TEMPLATE_NAME_FIELD, DURATION_IN_SECONDS_FIELD, RULES_PACKAGE_ARNS_FIELD,
            USER_ATTRIBUTES_FOR_FINDINGS_FIELD));

    private final String assessmentTargetArn;

    private final String assessmentTemplateName;

    private final Integer durationInSeconds;

    private final List<String> rulesPackageArns;

    private final List<Attribute> userAttributesForFindings;

    private CreateAssessmentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentTargetArn = builder.assessmentTargetArn;
        this.assessmentTemplateName = builder.assessmentTemplateName;
        this.durationInSeconds = builder.durationInSeconds;
        this.rulesPackageArns = builder.rulesPackageArns;
        this.userAttributesForFindings = builder.userAttributesForFindings;
    }

    /**
     * <p>
     * The ARN that specifies the assessment target for which you want to create the assessment template.
     * </p>
     * 
     * @return The ARN that specifies the assessment target for which you want to create the assessment template.
     */
    public String assessmentTargetArn() {
        return assessmentTargetArn;
    }

    /**
     * <p>
     * The user-defined name that identifies the assessment template that you want to create. You can create several
     * assessment templates for an assessment target. The names of the assessment templates that correspond to a
     * particular assessment target must be unique.
     * </p>
     * 
     * @return The user-defined name that identifies the assessment template that you want to create. You can create
     *         several assessment templates for an assessment target. The names of the assessment templates that
     *         correspond to a particular assessment target must be unique.
     */
    public String assessmentTemplateName() {
        return assessmentTemplateName;
    }

    /**
     * <p>
     * The duration of the assessment run in seconds.
     * </p>
     * 
     * @return The duration of the assessment run in seconds.
     */
    public Integer durationInSeconds() {
        return durationInSeconds;
    }

    /**
     * <p>
     * The ARNs that specify the rules packages that you want to attach to the assessment template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ARNs that specify the rules packages that you want to attach to the assessment template.
     */
    public List<String> rulesPackageArns() {
        return rulesPackageArns;
    }

    /**
     * <p>
     * The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses
     * this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object). Within an assessment
     * template, each key must be unique.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The user-defined attributes that are assigned to every finding that is generated by the assessment run
     *         that uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object).
     *         Within an assessment template, each key must be unique.
     */
    public List<Attribute> userAttributesForFindings() {
        return userAttributesForFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(rulesPackageArns());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributesForFindings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssessmentTemplateRequest)) {
            return false;
        }
        CreateAssessmentTemplateRequest other = (CreateAssessmentTemplateRequest) obj;
        return Objects.equals(assessmentTargetArn(), other.assessmentTargetArn())
                && Objects.equals(assessmentTemplateName(), other.assessmentTemplateName())
                && Objects.equals(durationInSeconds(), other.durationInSeconds())
                && Objects.equals(rulesPackageArns(), other.rulesPackageArns())
                && Objects.equals(userAttributesForFindings(), other.userAttributesForFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateAssessmentTemplateRequest").add("AssessmentTargetArn", assessmentTargetArn())
                .add("AssessmentTemplateName", assessmentTemplateName()).add("DurationInSeconds", durationInSeconds())
                .add("RulesPackageArns", rulesPackageArns()).add("UserAttributesForFindings", userAttributesForFindings())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargetArn":
            return Optional.ofNullable(clazz.cast(assessmentTargetArn()));
        case "assessmentTemplateName":
            return Optional.ofNullable(clazz.cast(assessmentTemplateName()));
        case "durationInSeconds":
            return Optional.ofNullable(clazz.cast(durationInSeconds()));
        case "rulesPackageArns":
            return Optional.ofNullable(clazz.cast(rulesPackageArns()));
        case "userAttributesForFindings":
            return Optional.ofNullable(clazz.cast(userAttributesForFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssessmentTemplateRequest, T> g) {
        return obj -> g.apply((CreateAssessmentTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssessmentTemplateRequest> {
        /**
         * <p>
         * The ARN that specifies the assessment target for which you want to create the assessment template.
         * </p>
         * 
         * @param assessmentTargetArn
         *        The ARN that specifies the assessment target for which you want to create the assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargetArn(String assessmentTargetArn);

        /**
         * <p>
         * The user-defined name that identifies the assessment template that you want to create. You can create several
         * assessment templates for an assessment target. The names of the assessment templates that correspond to a
         * particular assessment target must be unique.
         * </p>
         * 
         * @param assessmentTemplateName
         *        The user-defined name that identifies the assessment template that you want to create. You can create
         *        several assessment templates for an assessment target. The names of the assessment templates that
         *        correspond to a particular assessment target must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTemplateName(String assessmentTemplateName);

        /**
         * <p>
         * The duration of the assessment run in seconds.
         * </p>
         * 
         * @param durationInSeconds
         *        The duration of the assessment run in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInSeconds(Integer durationInSeconds);

        /**
         * <p>
         * The ARNs that specify the rules packages that you want to attach to the assessment template.
         * </p>
         * 
         * @param rulesPackageArns
         *        The ARNs that specify the rules packages that you want to attach to the assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(Collection<String> rulesPackageArns);

        /**
         * <p>
         * The ARNs that specify the rules packages that you want to attach to the assessment template.
         * </p>
         * 
         * @param rulesPackageArns
         *        The ARNs that specify the rules packages that you want to attach to the assessment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesPackageArns(String... rulesPackageArns);

        /**
         * <p>
         * The user-defined attributes that are assigned to every finding that is generated by the assessment run that
         * uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object). Within an
         * assessment template, each key must be unique.
         * </p>
         * 
         * @param userAttributesForFindings
         *        The user-defined attributes that are assigned to every finding that is generated by the assessment run
         *        that uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object).
         *        Within an assessment template, each key must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings);

        /**
         * <p>
         * The user-defined attributes that are assigned to every finding that is generated by the assessment run that
         * uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object). Within an
         * assessment template, each key must be unique.
         * </p>
         * 
         * @param userAttributesForFindings
         *        The user-defined attributes that are assigned to every finding that is generated by the assessment run
         *        that uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object).
         *        Within an assessment template, each key must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributesForFindings(Attribute... userAttributesForFindings);

        /**
         * <p>
         * The user-defined attributes that are assigned to every finding that is generated by the assessment run that
         * uses this assessment template. An attribute is a key and value pair (an <a>Attribute</a> object). Within an
         * assessment template, each key must be unique.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Attribute>.Builder} avoiding the need to
         * create one manually via {@link List<Attribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Attribute>.Builder#build()} is called immediately and its
         * result is passed to {@link #userAttributesForFindings(List<Attribute>)}.
         * 
         * @param userAttributesForFindings
         *        a consumer that will call methods on {@link List<Attribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributesForFindings(List<Attribute>)
         */
        Builder userAttributesForFindings(Consumer<Attribute.Builder>... userAttributesForFindings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private String assessmentTargetArn;

        private String assessmentTemplateName;

        private Integer durationInSeconds;

        private List<String> rulesPackageArns = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> userAttributesForFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssessmentTemplateRequest model) {
            super(model);
            assessmentTargetArn(model.assessmentTargetArn);
            assessmentTemplateName(model.assessmentTemplateName);
            durationInSeconds(model.durationInSeconds);
            rulesPackageArns(model.rulesPackageArns);
            userAttributesForFindings(model.userAttributesForFindings);
        }

        public final String getAssessmentTargetArn() {
            return assessmentTargetArn;
        }

        @Override
        public final Builder assessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
            return this;
        }

        public final void setAssessmentTargetArn(String assessmentTargetArn) {
            this.assessmentTargetArn = assessmentTargetArn;
        }

        public final String getAssessmentTemplateName() {
            return assessmentTemplateName;
        }

        @Override
        public final Builder assessmentTemplateName(String assessmentTemplateName) {
            this.assessmentTemplateName = assessmentTemplateName;
            return this;
        }

        public final void setAssessmentTemplateName(String assessmentTemplateName) {
            this.assessmentTemplateName = assessmentTemplateName;
        }

        public final Integer getDurationInSeconds() {
            return durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        public final Collection<String> getRulesPackageArns() {
            return rulesPackageArns;
        }

        @Override
        public final Builder rulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesPackageArns(String... rulesPackageArns) {
            rulesPackageArns(Arrays.asList(rulesPackageArns));
            return this;
        }

        public final void setRulesPackageArns(Collection<String> rulesPackageArns) {
            this.rulesPackageArns = AssessmentTemplateRulesPackageArnListCopier.copy(rulesPackageArns);
        }

        public final Collection<Attribute.Builder> getUserAttributesForFindings() {
            return userAttributesForFindings != null ? userAttributesForFindings.stream().map(Attribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributesForFindings(Collection<Attribute> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copy(userAttributesForFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Attribute... userAttributesForFindings) {
            userAttributesForFindings(Arrays.asList(userAttributesForFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributesForFindings(Consumer<Attribute.Builder>... userAttributesForFindings) {
            userAttributesForFindings(Stream.of(userAttributesForFindings).map(c -> Attribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributesForFindings(Collection<Attribute.BuilderImpl> userAttributesForFindings) {
            this.userAttributesForFindings = UserAttributeListCopier.copyFromBuilder(userAttributesForFindings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssessmentTemplateRequest build() {
            return new CreateAssessmentTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
