/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssessmentTargetsResponse extends InspectorResponse implements
        ToCopyableBuilder<DescribeAssessmentTargetsResponse.Builder, DescribeAssessmentTargetsResponse> {
    private static final SdkField<List<AssessmentTarget>> ASSESSMENT_TARGETS_FIELD = SdkField
            .<List<AssessmentTarget>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAssessmentTargetsResponse::assessmentTargets))
            .setter(setter(Builder::assessmentTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, FailedItemDetails>> FAILED_ITEMS_FIELD = SdkField
            .<Map<String, FailedItemDetails>> builder(MarshallingType.MAP)
            .getter(getter(DescribeAssessmentTargetsResponse::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedItems").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailedItemDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedItemDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_TARGETS_FIELD,
            FAILED_ITEMS_FIELD));

    private final List<AssessmentTarget> assessmentTargets;

    private final Map<String, FailedItemDetails> failedItems;

    private DescribeAssessmentTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentTargets = builder.assessmentTargets;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * Information about the assessment targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the assessment targets.
     */
    public List<AssessmentTarget> assessmentTargets() {
        return assessmentTargets;
    }

    /**
     * <p>
     * Assessment target details that cannot be described. An error code is provided for each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Assessment target details that cannot be described. An error code is provided for each failed item.
     */
    public Map<String, FailedItemDetails> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentTargets());
        hashCode = 31 * hashCode + Objects.hashCode(failedItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssessmentTargetsResponse)) {
            return false;
        }
        DescribeAssessmentTargetsResponse other = (DescribeAssessmentTargetsResponse) obj;
        return Objects.equals(assessmentTargets(), other.assessmentTargets())
                && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAssessmentTargetsResponse").add("AssessmentTargets", assessmentTargets())
                .add("FailedItems", failedItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentTargets":
            return Optional.ofNullable(clazz.cast(assessmentTargets()));
        case "failedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssessmentTargetsResponse, T> g) {
        return obj -> g.apply((DescribeAssessmentTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssessmentTargetsResponse> {
        /**
         * <p>
         * Information about the assessment targets.
         * </p>
         * 
         * @param assessmentTargets
         *        Information about the assessment targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets);

        /**
         * <p>
         * Information about the assessment targets.
         * </p>
         * 
         * @param assessmentTargets
         *        Information about the assessment targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentTargets(AssessmentTarget... assessmentTargets);

        /**
         * <p>
         * Information about the assessment targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AssessmentTarget>.Builder} avoiding the
         * need to create one manually via {@link List<AssessmentTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssessmentTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #assessmentTargets(List<AssessmentTarget>)}.
         * 
         * @param assessmentTargets
         *        a consumer that will call methods on {@link List<AssessmentTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentTargets(List<AssessmentTarget>)
         */
        Builder assessmentTargets(Consumer<AssessmentTarget.Builder>... assessmentTargets);

        /**
         * <p>
         * Assessment target details that cannot be described. An error code is provided for each failed item.
         * </p>
         * 
         * @param failedItems
         *        Assessment target details that cannot be described. An error code is provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Map<String, FailedItemDetails> failedItems);
    }

    static final class BuilderImpl extends InspectorResponse.BuilderImpl implements Builder {
        private List<AssessmentTarget> assessmentTargets = DefaultSdkAutoConstructList.getInstance();

        private Map<String, FailedItemDetails> failedItems = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssessmentTargetsResponse model) {
            super(model);
            assessmentTargets(model.assessmentTargets);
            failedItems(model.failedItems);
        }

        public final Collection<AssessmentTarget.Builder> getAssessmentTargets() {
            return assessmentTargets != null ? assessmentTargets.stream().map(AssessmentTarget::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder assessmentTargets(Collection<AssessmentTarget> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetListCopier.copy(assessmentTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(AssessmentTarget... assessmentTargets) {
            assessmentTargets(Arrays.asList(assessmentTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentTargets(Consumer<AssessmentTarget.Builder>... assessmentTargets) {
            assessmentTargets(Stream.of(assessmentTargets).map(c -> AssessmentTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssessmentTargets(Collection<AssessmentTarget.BuilderImpl> assessmentTargets) {
            this.assessmentTargets = AssessmentTargetListCopier.copyFromBuilder(assessmentTargets);
        }

        public final Map<String, FailedItemDetails.Builder> getFailedItems() {
            return failedItems != null ? CollectionUtils.mapValues(failedItems, FailedItemDetails::toBuilder) : null;
        }

        @Override
        public final Builder failedItems(Map<String, FailedItemDetails> failedItems) {
            this.failedItems = FailedItemsCopier.copy(failedItems);
            return this;
        }

        public final void setFailedItems(Map<String, FailedItemDetails.BuilderImpl> failedItems) {
            this.failedItems = FailedItemsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public DescribeAssessmentTargetsResponse build() {
            return new DescribeAssessmentTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
