/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsRequest extends InspectorRequest implements
        ToCopyableBuilder<ListFindingsRequest.Builder, ListFindingsRequest> {
    private static final SdkField<List<String>> ASSESSMENT_RUN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListFindingsRequest::assessmentRunArns))
            .setter(setter(Builder::assessmentRunArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentRunArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FindingFilter> FILTER_FIELD = SdkField.<FindingFilter> builder(MarshallingType.SDK_POJO)
            .getter(getter(ListFindingsRequest::filter)).setter(setter(Builder::filter)).constructor(FindingFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFindingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListFindingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_RUN_ARNS_FIELD,
            FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> assessmentRunArns;

    private final FindingFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentRunArns = builder.assessmentRunArns;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ARNs of the assessment runs that generate the findings that you want to list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ARNs of the assessment runs that generate the findings that you want to list.
     */
    public List<String> assessmentRunArns() {
        return assessmentRunArns;
    }

    /**
     * <p>
     * You can use this parameter to specify a subset of data to be included in the action's response.
     * </p>
     * <p>
     * For a record to match a filter, all specified filter attributes must match. When multiple values are specified
     * for a filter attribute, any of the values can match.
     * </p>
     * 
     * @return You can use this parameter to specify a subset of data to be included in the action's response.</p>
     *         <p>
     *         For a record to match a filter, all specified filter attributes must match. When multiple values are
     *         specified for a filter attribute, any of the values can match.
     */
    public FindingFilter filter() {
        return filter;
    }

    /**
     * <p>
     * You can use this parameter when paginating results. Set the value of this parameter to null on your first call to
     * the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request with the
     * value of <b>NextToken</b> from the previous response to continue listing data.
     * </p>
     * 
     * @return You can use this parameter when paginating results. Set the value of this parameter to null on your first
     *         call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the
     *         request with the value of <b>NextToken</b> from the previous response to continue listing data.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * You can use this parameter to indicate the maximum number of items you want in the response. The default value is
     * 10. The maximum value is 500.
     * </p>
     * 
     * @return You can use this parameter to indicate the maximum number of items you want in the response. The default
     *         value is 10. The maximum value is 500.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunArns());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsRequest)) {
            return false;
        }
        ListFindingsRequest other = (ListFindingsRequest) obj;
        return Objects.equals(assessmentRunArns(), other.assessmentRunArns()) && Objects.equals(filter(), other.filter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFindingsRequest").add("AssessmentRunArns", assessmentRunArns()).add("Filter", filter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentRunArns":
            return Optional.ofNullable(clazz.cast(assessmentRunArns()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsRequest, T> g) {
        return obj -> g.apply((ListFindingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends InspectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingsRequest> {
        /**
         * <p>
         * The ARNs of the assessment runs that generate the findings that you want to list.
         * </p>
         * 
         * @param assessmentRunArns
         *        The ARNs of the assessment runs that generate the findings that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArns(Collection<String> assessmentRunArns);

        /**
         * <p>
         * The ARNs of the assessment runs that generate the findings that you want to list.
         * </p>
         * 
         * @param assessmentRunArns
         *        The ARNs of the assessment runs that generate the findings that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunArns(String... assessmentRunArns);

        /**
         * <p>
         * You can use this parameter to specify a subset of data to be included in the action's response.
         * </p>
         * <p>
         * For a record to match a filter, all specified filter attributes must match. When multiple values are
         * specified for a filter attribute, any of the values can match.
         * </p>
         * 
         * @param filter
         *        You can use this parameter to specify a subset of data to be included in the action's response.</p>
         *        <p>
         *        For a record to match a filter, all specified filter attributes must match. When multiple values are
         *        specified for a filter attribute, any of the values can match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(FindingFilter filter);

        /**
         * <p>
         * You can use this parameter to specify a subset of data to be included in the action's response.
         * </p>
         * <p>
         * For a record to match a filter, all specified filter attributes must match. When multiple values are
         * specified for a filter attribute, any of the values can match.
         * </p>
         * This is a convenience that creates an instance of the {@link FindingFilter.Builder} avoiding the need to
         * create one manually via {@link FindingFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(FindingFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link FindingFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(FindingFilter)
         */
        default Builder filter(Consumer<FindingFilter.Builder> filter) {
            return filter(FindingFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * You can use this parameter when paginating results. Set the value of this parameter to null on your first
         * call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in the request
         * with the value of <b>NextToken</b> from the previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        You can use this parameter when paginating results. Set the value of this parameter to null on your
         *        first call to the <b>ListFindings</b> action. Subsequent calls to the action fill <b>nextToken</b> in
         *        the request with the value of <b>NextToken</b> from the previous response to continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * You can use this parameter to indicate the maximum number of items you want in the response. The default
         * value is 10. The maximum value is 500.
         * </p>
         * 
         * @param maxResults
         *        You can use this parameter to indicate the maximum number of items you want in the response. The
         *        default value is 10. The maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends InspectorRequest.BuilderImpl implements Builder {
        private List<String> assessmentRunArns = DefaultSdkAutoConstructList.getInstance();

        private FindingFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsRequest model) {
            super(model);
            assessmentRunArns(model.assessmentRunArns);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getAssessmentRunArns() {
            return assessmentRunArns;
        }

        @Override
        public final Builder assessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = ListParentArnListCopier.copy(assessmentRunArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentRunArns(String... assessmentRunArns) {
            assessmentRunArns(Arrays.asList(assessmentRunArns));
            return this;
        }

        public final void setAssessmentRunArns(Collection<String> assessmentRunArns) {
            this.assessmentRunArns = ListParentArnListCopier.copy(assessmentRunArns);
        }

        public final FindingFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(FindingFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(FindingFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingsRequest build() {
            return new ListFindingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
