/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.AccountAggregation;
import software.amazon.awssdk.services.inspector2.model.AmiAggregation;
import software.amazon.awssdk.services.inspector2.model.AwsEcrContainerAggregation;
import software.amazon.awssdk.services.inspector2.model.Ec2InstanceAggregation;
import software.amazon.awssdk.services.inspector2.model.FindingTypeAggregation;
import software.amazon.awssdk.services.inspector2.model.ImageLayerAggregation;
import software.amazon.awssdk.services.inspector2.model.PackageAggregation;
import software.amazon.awssdk.services.inspector2.model.RepositoryAggregation;
import software.amazon.awssdk.services.inspector2.model.TitleAggregation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationRequest> {
    private static final SdkField<AccountAggregation> ACCOUNT_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accountAggregation").getter(AggregationRequest.getter(AggregationRequest::accountAggregation)).setter(AggregationRequest.setter(Builder::accountAggregation)).constructor(AccountAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAggregation").build()}).build();
    private static final SdkField<AmiAggregation> AMI_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("amiAggregation").getter(AggregationRequest.getter(AggregationRequest::amiAggregation)).setter(AggregationRequest.setter(Builder::amiAggregation)).constructor(AmiAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiAggregation").build()}).build();
    private static final SdkField<AwsEcrContainerAggregation> AWS_ECR_CONTAINER_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsEcrContainerAggregation").getter(AggregationRequest.getter(AggregationRequest::awsEcrContainerAggregation)).setter(AggregationRequest.setter(Builder::awsEcrContainerAggregation)).constructor(AwsEcrContainerAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcrContainerAggregation").build()}).build();
    private static final SdkField<Ec2InstanceAggregation> EC2_INSTANCE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2InstanceAggregation").getter(AggregationRequest.getter(AggregationRequest::ec2InstanceAggregation)).setter(AggregationRequest.setter(Builder::ec2InstanceAggregation)).constructor(Ec2InstanceAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceAggregation").build()}).build();
    private static final SdkField<FindingTypeAggregation> FINDING_TYPE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("findingTypeAggregation").getter(AggregationRequest.getter(AggregationRequest::findingTypeAggregation)).setter(AggregationRequest.setter(Builder::findingTypeAggregation)).constructor(FindingTypeAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTypeAggregation").build()}).build();
    private static final SdkField<ImageLayerAggregation> IMAGE_LAYER_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageLayerAggregation").getter(AggregationRequest.getter(AggregationRequest::imageLayerAggregation)).setter(AggregationRequest.setter(Builder::imageLayerAggregation)).constructor(ImageLayerAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageLayerAggregation").build()}).build();
    private static final SdkField<PackageAggregation> PACKAGE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageAggregation").getter(AggregationRequest.getter(AggregationRequest::packageAggregation)).setter(AggregationRequest.setter(Builder::packageAggregation)).constructor(PackageAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageAggregation").build()}).build();
    private static final SdkField<RepositoryAggregation> REPOSITORY_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryAggregation").getter(AggregationRequest.getter(AggregationRequest::repositoryAggregation)).setter(AggregationRequest.setter(Builder::repositoryAggregation)).constructor(RepositoryAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryAggregation").build()}).build();
    private static final SdkField<TitleAggregation> TITLE_AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("titleAggregation").getter(AggregationRequest.getter(AggregationRequest::titleAggregation)).setter(AggregationRequest.setter(Builder::titleAggregation)).constructor(TitleAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleAggregation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_AGGREGATION_FIELD, AMI_AGGREGATION_FIELD, AWS_ECR_CONTAINER_AGGREGATION_FIELD, EC2_INSTANCE_AGGREGATION_FIELD, FINDING_TYPE_AGGREGATION_FIELD, IMAGE_LAYER_AGGREGATION_FIELD, PACKAGE_AGGREGATION_FIELD, REPOSITORY_AGGREGATION_FIELD, TITLE_AGGREGATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccountAggregation accountAggregation;
    private final AmiAggregation amiAggregation;
    private final AwsEcrContainerAggregation awsEcrContainerAggregation;
    private final Ec2InstanceAggregation ec2InstanceAggregation;
    private final FindingTypeAggregation findingTypeAggregation;
    private final ImageLayerAggregation imageLayerAggregation;
    private final PackageAggregation packageAggregation;
    private final RepositoryAggregation repositoryAggregation;
    private final TitleAggregation titleAggregation;

    private AggregationRequest(BuilderImpl builder) {
        this.accountAggregation = builder.accountAggregation;
        this.amiAggregation = builder.amiAggregation;
        this.awsEcrContainerAggregation = builder.awsEcrContainerAggregation;
        this.ec2InstanceAggregation = builder.ec2InstanceAggregation;
        this.findingTypeAggregation = builder.findingTypeAggregation;
        this.imageLayerAggregation = builder.imageLayerAggregation;
        this.packageAggregation = builder.packageAggregation;
        this.repositoryAggregation = builder.repositoryAggregation;
        this.titleAggregation = builder.titleAggregation;
    }

    public final AccountAggregation accountAggregation() {
        return this.accountAggregation;
    }

    public final AmiAggregation amiAggregation() {
        return this.amiAggregation;
    }

    public final AwsEcrContainerAggregation awsEcrContainerAggregation() {
        return this.awsEcrContainerAggregation;
    }

    public final Ec2InstanceAggregation ec2InstanceAggregation() {
        return this.ec2InstanceAggregation;
    }

    public final FindingTypeAggregation findingTypeAggregation() {
        return this.findingTypeAggregation;
    }

    public final ImageLayerAggregation imageLayerAggregation() {
        return this.imageLayerAggregation;
    }

    public final PackageAggregation packageAggregation() {
        return this.packageAggregation;
    }

    public final RepositoryAggregation repositoryAggregation() {
        return this.repositoryAggregation;
    }

    public final TitleAggregation titleAggregation() {
        return this.titleAggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEcrContainerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTypeAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageLayerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.titleAggregation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationRequest)) {
            return false;
        }
        AggregationRequest other = (AggregationRequest)obj;
        return Objects.equals(this.accountAggregation(), other.accountAggregation()) && Objects.equals(this.amiAggregation(), other.amiAggregation()) && Objects.equals(this.awsEcrContainerAggregation(), other.awsEcrContainerAggregation()) && Objects.equals(this.ec2InstanceAggregation(), other.ec2InstanceAggregation()) && Objects.equals(this.findingTypeAggregation(), other.findingTypeAggregation()) && Objects.equals(this.imageLayerAggregation(), other.imageLayerAggregation()) && Objects.equals(this.packageAggregation(), other.packageAggregation()) && Objects.equals(this.repositoryAggregation(), other.repositoryAggregation()) && Objects.equals(this.titleAggregation(), other.titleAggregation());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationRequest").add("AccountAggregation", (Object)this.accountAggregation()).add("AmiAggregation", (Object)this.amiAggregation()).add("AwsEcrContainerAggregation", (Object)this.awsEcrContainerAggregation()).add("Ec2InstanceAggregation", (Object)this.ec2InstanceAggregation()).add("FindingTypeAggregation", (Object)this.findingTypeAggregation()).add("ImageLayerAggregation", (Object)this.imageLayerAggregation()).add("PackageAggregation", (Object)this.packageAggregation()).add("RepositoryAggregation", (Object)this.repositoryAggregation()).add("TitleAggregation", (Object)this.titleAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountAggregation": {
                return Optional.ofNullable(clazz.cast(this.accountAggregation()));
            }
            case "amiAggregation": {
                return Optional.ofNullable(clazz.cast(this.amiAggregation()));
            }
            case "awsEcrContainerAggregation": {
                return Optional.ofNullable(clazz.cast(this.awsEcrContainerAggregation()));
            }
            case "ec2InstanceAggregation": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceAggregation()));
            }
            case "findingTypeAggregation": {
                return Optional.ofNullable(clazz.cast(this.findingTypeAggregation()));
            }
            case "imageLayerAggregation": {
                return Optional.ofNullable(clazz.cast(this.imageLayerAggregation()));
            }
            case "packageAggregation": {
                return Optional.ofNullable(clazz.cast(this.packageAggregation()));
            }
            case "repositoryAggregation": {
                return Optional.ofNullable(clazz.cast(this.repositoryAggregation()));
            }
            case "titleAggregation": {
                return Optional.ofNullable(clazz.cast(this.titleAggregation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationRequest, T> g) {
        return obj -> g.apply((AggregationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccountAggregation accountAggregation;
        private AmiAggregation amiAggregation;
        private AwsEcrContainerAggregation awsEcrContainerAggregation;
        private Ec2InstanceAggregation ec2InstanceAggregation;
        private FindingTypeAggregation findingTypeAggregation;
        private ImageLayerAggregation imageLayerAggregation;
        private PackageAggregation packageAggregation;
        private RepositoryAggregation repositoryAggregation;
        private TitleAggregation titleAggregation;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationRequest model) {
            this.accountAggregation(model.accountAggregation);
            this.amiAggregation(model.amiAggregation);
            this.awsEcrContainerAggregation(model.awsEcrContainerAggregation);
            this.ec2InstanceAggregation(model.ec2InstanceAggregation);
            this.findingTypeAggregation(model.findingTypeAggregation);
            this.imageLayerAggregation(model.imageLayerAggregation);
            this.packageAggregation(model.packageAggregation);
            this.repositoryAggregation(model.repositoryAggregation);
            this.titleAggregation(model.titleAggregation);
        }

        public final AccountAggregation.Builder getAccountAggregation() {
            return this.accountAggregation != null ? this.accountAggregation.toBuilder() : null;
        }

        public final void setAccountAggregation(AccountAggregation.BuilderImpl accountAggregation) {
            this.accountAggregation = accountAggregation != null ? accountAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder accountAggregation(AccountAggregation accountAggregation) {
            this.accountAggregation = accountAggregation;
            return this;
        }

        public final AmiAggregation.Builder getAmiAggregation() {
            return this.amiAggregation != null ? this.amiAggregation.toBuilder() : null;
        }

        public final void setAmiAggregation(AmiAggregation.BuilderImpl amiAggregation) {
            this.amiAggregation = amiAggregation != null ? amiAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder amiAggregation(AmiAggregation amiAggregation) {
            this.amiAggregation = amiAggregation;
            return this;
        }

        public final AwsEcrContainerAggregation.Builder getAwsEcrContainerAggregation() {
            return this.awsEcrContainerAggregation != null ? this.awsEcrContainerAggregation.toBuilder() : null;
        }

        public final void setAwsEcrContainerAggregation(AwsEcrContainerAggregation.BuilderImpl awsEcrContainerAggregation) {
            this.awsEcrContainerAggregation = awsEcrContainerAggregation != null ? awsEcrContainerAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder awsEcrContainerAggregation(AwsEcrContainerAggregation awsEcrContainerAggregation) {
            this.awsEcrContainerAggregation = awsEcrContainerAggregation;
            return this;
        }

        public final Ec2InstanceAggregation.Builder getEc2InstanceAggregation() {
            return this.ec2InstanceAggregation != null ? this.ec2InstanceAggregation.toBuilder() : null;
        }

        public final void setEc2InstanceAggregation(Ec2InstanceAggregation.BuilderImpl ec2InstanceAggregation) {
            this.ec2InstanceAggregation = ec2InstanceAggregation != null ? ec2InstanceAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder ec2InstanceAggregation(Ec2InstanceAggregation ec2InstanceAggregation) {
            this.ec2InstanceAggregation = ec2InstanceAggregation;
            return this;
        }

        public final FindingTypeAggregation.Builder getFindingTypeAggregation() {
            return this.findingTypeAggregation != null ? this.findingTypeAggregation.toBuilder() : null;
        }

        public final void setFindingTypeAggregation(FindingTypeAggregation.BuilderImpl findingTypeAggregation) {
            this.findingTypeAggregation = findingTypeAggregation != null ? findingTypeAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder findingTypeAggregation(FindingTypeAggregation findingTypeAggregation) {
            this.findingTypeAggregation = findingTypeAggregation;
            return this;
        }

        public final ImageLayerAggregation.Builder getImageLayerAggregation() {
            return this.imageLayerAggregation != null ? this.imageLayerAggregation.toBuilder() : null;
        }

        public final void setImageLayerAggregation(ImageLayerAggregation.BuilderImpl imageLayerAggregation) {
            this.imageLayerAggregation = imageLayerAggregation != null ? imageLayerAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder imageLayerAggregation(ImageLayerAggregation imageLayerAggregation) {
            this.imageLayerAggregation = imageLayerAggregation;
            return this;
        }

        public final PackageAggregation.Builder getPackageAggregation() {
            return this.packageAggregation != null ? this.packageAggregation.toBuilder() : null;
        }

        public final void setPackageAggregation(PackageAggregation.BuilderImpl packageAggregation) {
            this.packageAggregation = packageAggregation != null ? packageAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder packageAggregation(PackageAggregation packageAggregation) {
            this.packageAggregation = packageAggregation;
            return this;
        }

        public final RepositoryAggregation.Builder getRepositoryAggregation() {
            return this.repositoryAggregation != null ? this.repositoryAggregation.toBuilder() : null;
        }

        public final void setRepositoryAggregation(RepositoryAggregation.BuilderImpl repositoryAggregation) {
            this.repositoryAggregation = repositoryAggregation != null ? repositoryAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder repositoryAggregation(RepositoryAggregation repositoryAggregation) {
            this.repositoryAggregation = repositoryAggregation;
            return this;
        }

        public final TitleAggregation.Builder getTitleAggregation() {
            return this.titleAggregation != null ? this.titleAggregation.toBuilder() : null;
        }

        public final void setTitleAggregation(TitleAggregation.BuilderImpl titleAggregation) {
            this.titleAggregation = titleAggregation != null ? titleAggregation.build() : null;
        }

        @Override
        @Transient
        public final Builder titleAggregation(TitleAggregation titleAggregation) {
            this.titleAggregation = titleAggregation;
            return this;
        }

        public AggregationRequest build() {
            return new AggregationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationRequest> {
        public Builder accountAggregation(AccountAggregation var1);

        default public Builder accountAggregation(Consumer<AccountAggregation.Builder> accountAggregation) {
            return this.accountAggregation((AccountAggregation)((AccountAggregation.Builder)AccountAggregation.builder().applyMutation(accountAggregation)).build());
        }

        public Builder amiAggregation(AmiAggregation var1);

        default public Builder amiAggregation(Consumer<AmiAggregation.Builder> amiAggregation) {
            return this.amiAggregation((AmiAggregation)((AmiAggregation.Builder)AmiAggregation.builder().applyMutation(amiAggregation)).build());
        }

        public Builder awsEcrContainerAggregation(AwsEcrContainerAggregation var1);

        default public Builder awsEcrContainerAggregation(Consumer<AwsEcrContainerAggregation.Builder> awsEcrContainerAggregation) {
            return this.awsEcrContainerAggregation((AwsEcrContainerAggregation)((AwsEcrContainerAggregation.Builder)AwsEcrContainerAggregation.builder().applyMutation(awsEcrContainerAggregation)).build());
        }

        public Builder ec2InstanceAggregation(Ec2InstanceAggregation var1);

        default public Builder ec2InstanceAggregation(Consumer<Ec2InstanceAggregation.Builder> ec2InstanceAggregation) {
            return this.ec2InstanceAggregation((Ec2InstanceAggregation)((Ec2InstanceAggregation.Builder)Ec2InstanceAggregation.builder().applyMutation(ec2InstanceAggregation)).build());
        }

        public Builder findingTypeAggregation(FindingTypeAggregation var1);

        default public Builder findingTypeAggregation(Consumer<FindingTypeAggregation.Builder> findingTypeAggregation) {
            return this.findingTypeAggregation((FindingTypeAggregation)((FindingTypeAggregation.Builder)FindingTypeAggregation.builder().applyMutation(findingTypeAggregation)).build());
        }

        public Builder imageLayerAggregation(ImageLayerAggregation var1);

        default public Builder imageLayerAggregation(Consumer<ImageLayerAggregation.Builder> imageLayerAggregation) {
            return this.imageLayerAggregation((ImageLayerAggregation)((ImageLayerAggregation.Builder)ImageLayerAggregation.builder().applyMutation(imageLayerAggregation)).build());
        }

        public Builder packageAggregation(PackageAggregation var1);

        default public Builder packageAggregation(Consumer<PackageAggregation.Builder> packageAggregation) {
            return this.packageAggregation((PackageAggregation)((PackageAggregation.Builder)PackageAggregation.builder().applyMutation(packageAggregation)).build());
        }

        public Builder repositoryAggregation(RepositoryAggregation var1);

        default public Builder repositoryAggregation(Consumer<RepositoryAggregation.Builder> repositoryAggregation) {
            return this.repositoryAggregation((RepositoryAggregation)((RepositoryAggregation.Builder)RepositoryAggregation.builder().applyMutation(repositoryAggregation)).build());
        }

        public Builder titleAggregation(TitleAggregation var1);

        default public Builder titleAggregation(Consumer<TitleAggregation.Builder> titleAggregation) {
            return this.titleAggregation((TitleAggregation)((TitleAggregation.Builder)TitleAggregation.builder().applyMutation(titleAggregation)).build());
        }
    }
}

