/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Destination;
import software.amazon.awssdk.services.inspector2.model.FilterCriteria;
import software.amazon.awssdk.services.inspector2.model.Inspector2Request;
import software.amazon.awssdk.services.inspector2.model.ReportFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFindingsReportRequest
extends Inspector2Request
implements ToCopyableBuilder<Builder, CreateFindingsReportRequest> {
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterCriteria").getter(CreateFindingsReportRequest.getter(CreateFindingsReportRequest::filterCriteria)).setter(CreateFindingsReportRequest.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()}).build();
    private static final SdkField<String> REPORT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportFormat").getter(CreateFindingsReportRequest.getter(CreateFindingsReportRequest::reportFormatAsString)).setter(CreateFindingsReportRequest.setter(Builder::reportFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFormat").build()}).build();
    private static final SdkField<Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(CreateFindingsReportRequest.getter(CreateFindingsReportRequest::s3Destination)).setter(CreateFindingsReportRequest.setter(Builder::s3Destination)).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD, REPORT_FORMAT_FIELD, S3_DESTINATION_FIELD));
    private final FilterCriteria filterCriteria;
    private final String reportFormat;
    private final Destination s3Destination;

    private CreateFindingsReportRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.reportFormat = builder.reportFormat;
        this.s3Destination = builder.s3Destination;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final ReportFormat reportFormat() {
        return ReportFormat.fromValue(this.reportFormat);
    }

    public final String reportFormatAsString() {
        return this.reportFormat;
    }

    public final Destination s3Destination() {
        return this.s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFindingsReportRequest)) {
            return false;
        }
        CreateFindingsReportRequest other = (CreateFindingsReportRequest)((Object)obj);
        return Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.reportFormatAsString(), other.reportFormatAsString()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFindingsReportRequest").add("FilterCriteria", (Object)this.filterCriteria()).add("ReportFormat", (Object)this.reportFormatAsString()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "reportFormat": {
                return Optional.ofNullable(clazz.cast(this.reportFormatAsString()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFindingsReportRequest, T> g) {
        return obj -> g.apply((CreateFindingsReportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Request.BuilderImpl
    implements Builder {
        private FilterCriteria filterCriteria;
        private String reportFormat;
        private Destination s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFindingsReportRequest model) {
            super(model);
            this.filterCriteria(model.filterCriteria);
            this.reportFormat(model.reportFormat);
            this.s3Destination(model.s3Destination);
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getReportFormat() {
            return this.reportFormat;
        }

        public final void setReportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
        }

        @Override
        @Transient
        public final Builder reportFormat(String reportFormat) {
            this.reportFormat = reportFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder reportFormat(ReportFormat reportFormat) {
            this.reportFormat(reportFormat == null ? null : reportFormat.toString());
            return this;
        }

        public final Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        @Transient
        public final Builder s3Destination(Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFindingsReportRequest build() {
            return new CreateFindingsReportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFindingsReportRequest> {
        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder reportFormat(String var1);

        public Builder reportFormat(ReportFormat var1);

        public Builder s3Destination(Destination var1);

        default public Builder s3Destination(Consumer<Destination.Builder> s3Destination) {
            return this.s3Destination((Destination)((Destination.Builder)Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

