/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.Account;
import software.amazon.awssdk.services.inspector2.model.AccountListCopier;
import software.amazon.awssdk.services.inspector2.model.FailedAccount;
import software.amazon.awssdk.services.inspector2.model.FailedAccountListCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, EnableResponse> {
    private static final SdkField<List<Account>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accounts").getter(EnableResponse.getter(EnableResponse::accounts)).setter(EnableResponse.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Account::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedAccount>> FAILED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedAccounts").getter(EnableResponse.getter(EnableResponse::failedAccounts)).setter(EnableResponse.setter(Builder::failedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD, FAILED_ACCOUNTS_FIELD));
    private final List<Account> accounts;
    private final List<FailedAccount> failedAccounts;

    private EnableResponse(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.failedAccounts = builder.failedAccounts;
    }

    public final boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public final List<Account> accounts() {
        return this.accounts;
    }

    public final boolean hasFailedAccounts() {
        return this.failedAccounts != null && !(this.failedAccounts instanceof SdkAutoConstructList);
    }

    public final List<FailedAccount> failedAccounts() {
        return this.failedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedAccounts() ? this.failedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableResponse)) {
            return false;
        }
        EnableResponse other = (EnableResponse)((Object)obj);
        return this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && this.hasFailedAccounts() == other.hasFailedAccounts() && Objects.equals(this.failedAccounts(), other.failedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"EnableResponse").add("Accounts", this.hasAccounts() ? this.accounts() : null).add("FailedAccounts", this.hasFailedAccounts() ? this.failedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "failedAccounts": {
                return Optional.ofNullable(clazz.cast(this.failedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableResponse, T> g) {
        return obj -> g.apply((EnableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<Account> accounts = DefaultSdkAutoConstructList.getInstance();
        private List<FailedAccount> failedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableResponse model) {
            super(model);
            this.accounts(model.accounts);
            this.failedAccounts(model.failedAccounts);
        }

        public final List<Account.Builder> getAccounts() {
            List<Account.Builder> result = AccountListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<Account.BuilderImpl> accounts) {
            this.accounts = AccountListCopier.copyFromBuilder(accounts);
        }

        @Override
        @Transient
        public final Builder accounts(Collection<Account> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accounts(Account ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accounts(Consumer<Account.Builder> ... accounts) {
            this.accounts(Stream.of(accounts).map(c -> (Account)((Account.Builder)Account.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedAccount.Builder> getFailedAccounts() {
            List<FailedAccount.Builder> result = FailedAccountListCopier.copyToBuilder(this.failedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAccounts(Collection<FailedAccount.BuilderImpl> failedAccounts) {
            this.failedAccounts = FailedAccountListCopier.copyFromBuilder(failedAccounts);
        }

        @Override
        @Transient
        public final Builder failedAccounts(Collection<FailedAccount> failedAccounts) {
            this.failedAccounts = FailedAccountListCopier.copy(failedAccounts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedAccounts(FailedAccount ... failedAccounts) {
            this.failedAccounts(Arrays.asList(failedAccounts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failedAccounts(Consumer<FailedAccount.Builder> ... failedAccounts) {
            this.failedAccounts(Stream.of(failedAccounts).map(c -> (FailedAccount)((FailedAccount.Builder)FailedAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnableResponse build() {
            return new EnableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableResponse> {
        public Builder accounts(Collection<Account> var1);

        public Builder accounts(Account ... var1);

        public Builder accounts(Consumer<Account.Builder> ... var1);

        public Builder failedAccounts(Collection<FailedAccount> var1);

        public Builder failedAccounts(FailedAccount ... var1);

        public Builder failedAccounts(Consumer<FailedAccount.Builder> ... var1);
    }
}

