/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.inspector2.model.CoveredResource;
import software.amazon.awssdk.services.inspector2.model.CoveredResourcesCopier;
import software.amazon.awssdk.services.inspector2.model.Inspector2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCoverageResponse
extends Inspector2Response
implements ToCopyableBuilder<Builder, ListCoverageResponse> {
    private static final SdkField<List<CoveredResource>> COVERED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("coveredResources").getter(ListCoverageResponse.getter(ListCoverageResponse::coveredResources)).setter(ListCoverageResponse.setter(Builder::coveredResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coveredResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoveredResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCoverageResponse.getter(ListCoverageResponse::nextToken)).setter(ListCoverageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERED_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CoveredResource> coveredResources;
    private final String nextToken;

    private ListCoverageResponse(BuilderImpl builder) {
        super(builder);
        this.coveredResources = builder.coveredResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCoveredResources() {
        return this.coveredResources != null && !(this.coveredResources instanceof SdkAutoConstructList);
    }

    public final List<CoveredResource> coveredResources() {
        return this.coveredResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCoveredResources() ? this.coveredResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageResponse)) {
            return false;
        }
        ListCoverageResponse other = (ListCoverageResponse)((Object)obj);
        return this.hasCoveredResources() == other.hasCoveredResources() && Objects.equals(this.coveredResources(), other.coveredResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCoverageResponse").add("CoveredResources", this.hasCoveredResources() ? this.coveredResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coveredResources": {
                return Optional.ofNullable(clazz.cast(this.coveredResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageResponse, T> g) {
        return obj -> g.apply((ListCoverageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Inspector2Response.BuilderImpl
    implements Builder {
        private List<CoveredResource> coveredResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageResponse model) {
            super(model);
            this.coveredResources(model.coveredResources);
            this.nextToken(model.nextToken);
        }

        public final List<CoveredResource.Builder> getCoveredResources() {
            List<CoveredResource.Builder> result = CoveredResourcesCopier.copyToBuilder(this.coveredResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCoveredResources(Collection<CoveredResource.BuilderImpl> coveredResources) {
            this.coveredResources = CoveredResourcesCopier.copyFromBuilder(coveredResources);
        }

        @Override
        @Transient
        public final Builder coveredResources(Collection<CoveredResource> coveredResources) {
            this.coveredResources = CoveredResourcesCopier.copy(coveredResources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder coveredResources(CoveredResource ... coveredResources) {
            this.coveredResources(Arrays.asList(coveredResources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder coveredResources(Consumer<CoveredResource.Builder> ... coveredResources) {
            this.coveredResources(Stream.of(coveredResources).map(c -> (CoveredResource)((CoveredResource.Builder)CoveredResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCoverageResponse build() {
            return new ListCoverageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Inspector2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCoverageResponse> {
        public Builder coveredResources(Collection<CoveredResource> var1);

        public Builder coveredResources(CoveredResource ... var1);

        public Builder coveredResources(Consumer<CoveredResource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

