/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.SeverityCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageAggregationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(PackageAggregationResponse.getter(PackageAggregationResponse::accountId)).setter(PackageAggregationResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(PackageAggregationResponse.getter(PackageAggregationResponse::packageName)).setter(PackageAggregationResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("severityCounts").getter(PackageAggregationResponse.getter(PackageAggregationResponse::severityCounts)).setter(PackageAggregationResponse.setter(Builder::severityCounts)).constructor(SeverityCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, PACKAGE_NAME_FIELD, SEVERITY_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String packageName;
    private final SeverityCounts severityCounts;

    private PackageAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.packageName = builder.packageName;
        this.severityCounts = builder.severityCounts;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final SeverityCounts severityCounts() {
        return this.severityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageAggregationResponse)) {
            return false;
        }
        PackageAggregationResponse other = (PackageAggregationResponse)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.severityCounts(), other.severityCounts());
    }

    public final String toString() {
        return ToString.builder((String)"PackageAggregationResponse").add("AccountId", (Object)this.accountId()).add("PackageName", (Object)this.packageName()).add("SeverityCounts", (Object)this.severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "severityCounts": {
                return Optional.ofNullable(clazz.cast(this.severityCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageAggregationResponse, T> g) {
        return obj -> g.apply((PackageAggregationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String packageName;
        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageAggregationResponse model) {
            this.accountId(model.accountId);
            this.packageName(model.packageName);
            this.severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        @Transient
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return this.severityCounts != null ? this.severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        @Transient
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public PackageAggregationResponse build() {
            return new PackageAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageAggregationResponse> {
        public Builder accountId(String var1);

        public Builder packageName(String var1);

        public Builder severityCounts(SeverityCounts var1);

        default public Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return this.severityCounts((SeverityCounts)((SeverityCounts.Builder)SeverityCounts.builder().applyMutation(severityCounts)).build());
        }
    }
}

