/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.Ec2Metadata;
import software.amazon.awssdk.services.inspector2.model.EcrContainerImageMetadata;
import software.amazon.awssdk.services.inspector2.model.EcrRepositoryMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceScanMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceScanMetadata> {
    private static final SdkField<Ec2Metadata> EC2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2").getter(ResourceScanMetadata.getter(ResourceScanMetadata::ec2)).setter(ResourceScanMetadata.setter(Builder::ec2)).constructor(Ec2Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()}).build();
    private static final SdkField<EcrContainerImageMetadata> ECR_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecrImage").getter(ResourceScanMetadata.getter(ResourceScanMetadata::ecrImage)).setter(ResourceScanMetadata.setter(Builder::ecrImage)).constructor(EcrContainerImageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImage").build()}).build();
    private static final SdkField<EcrRepositoryMetadata> ECR_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecrRepository").getter(ResourceScanMetadata.getter(ResourceScanMetadata::ecrRepository)).setter(ResourceScanMetadata.setter(Builder::ecrRepository)).constructor(EcrRepositoryMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepository").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_IMAGE_FIELD, ECR_REPOSITORY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Ec2Metadata ec2;
    private final EcrContainerImageMetadata ecrImage;
    private final EcrRepositoryMetadata ecrRepository;

    private ResourceScanMetadata(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecrImage = builder.ecrImage;
        this.ecrRepository = builder.ecrRepository;
    }

    public final Ec2Metadata ec2() {
        return this.ec2;
    }

    public final EcrContainerImageMetadata ecrImage() {
        return this.ecrImage;
    }

    public final EcrRepositoryMetadata ecrRepository() {
        return this.ecrRepository;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepository());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceScanMetadata)) {
            return false;
        }
        ResourceScanMetadata other = (ResourceScanMetadata)obj;
        return Objects.equals(this.ec2(), other.ec2()) && Objects.equals(this.ecrImage(), other.ecrImage()) && Objects.equals(this.ecrRepository(), other.ecrRepository());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceScanMetadata").add("Ec2", (Object)this.ec2()).add("EcrImage", (Object)this.ecrImage()).add("EcrRepository", (Object)this.ecrRepository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2": {
                return Optional.ofNullable(clazz.cast(this.ec2()));
            }
            case "ecrImage": {
                return Optional.ofNullable(clazz.cast(this.ecrImage()));
            }
            case "ecrRepository": {
                return Optional.ofNullable(clazz.cast(this.ecrRepository()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceScanMetadata, T> g) {
        return obj -> g.apply((ResourceScanMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Ec2Metadata ec2;
        private EcrContainerImageMetadata ecrImage;
        private EcrRepositoryMetadata ecrRepository;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceScanMetadata model) {
            this.ec2(model.ec2);
            this.ecrImage(model.ecrImage);
            this.ecrRepository(model.ecrRepository);
        }

        public final Ec2Metadata.Builder getEc2() {
            return this.ec2 != null ? this.ec2.toBuilder() : null;
        }

        public final void setEc2(Ec2Metadata.BuilderImpl ec2) {
            this.ec2 = ec2 != null ? ec2.build() : null;
        }

        @Override
        @Transient
        public final Builder ec2(Ec2Metadata ec2) {
            this.ec2 = ec2;
            return this;
        }

        public final EcrContainerImageMetadata.Builder getEcrImage() {
            return this.ecrImage != null ? this.ecrImage.toBuilder() : null;
        }

        public final void setEcrImage(EcrContainerImageMetadata.BuilderImpl ecrImage) {
            this.ecrImage = ecrImage != null ? ecrImage.build() : null;
        }

        @Override
        @Transient
        public final Builder ecrImage(EcrContainerImageMetadata ecrImage) {
            this.ecrImage = ecrImage;
            return this;
        }

        public final EcrRepositoryMetadata.Builder getEcrRepository() {
            return this.ecrRepository != null ? this.ecrRepository.toBuilder() : null;
        }

        public final void setEcrRepository(EcrRepositoryMetadata.BuilderImpl ecrRepository) {
            this.ecrRepository = ecrRepository != null ? ecrRepository.build() : null;
        }

        @Override
        @Transient
        public final Builder ecrRepository(EcrRepositoryMetadata ecrRepository) {
            this.ecrRepository = ecrRepository;
            return this;
        }

        public ResourceScanMetadata build() {
            return new ResourceScanMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceScanMetadata> {
        public Builder ec2(Ec2Metadata var1);

        default public Builder ec2(Consumer<Ec2Metadata.Builder> ec2) {
            return this.ec2((Ec2Metadata)((Ec2Metadata.Builder)Ec2Metadata.builder().applyMutation(ec2)).build());
        }

        public Builder ecrImage(EcrContainerImageMetadata var1);

        default public Builder ecrImage(Consumer<EcrContainerImageMetadata.Builder> ecrImage) {
            return this.ecrImage((EcrContainerImageMetadata)((EcrContainerImageMetadata.Builder)EcrContainerImageMetadata.builder().applyMutation(ecrImage)).build());
        }

        public Builder ecrRepository(EcrRepositoryMetadata var1);

        default public Builder ecrRepository(Consumer<EcrRepositoryMetadata.Builder> ecrRepository) {
            return this.ecrRepository((EcrRepositoryMetadata)((EcrRepositoryMetadata.Builder)EcrRepositoryMetadata.builder().applyMutation(ecrRepository)).build());
        }
    }
}

