/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation of information about Amazon ECR containers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcrContainerAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcrContainerAggregation.Builder, AwsEcrContainerAggregation> {
    private static final SdkField<List<StringFilter>> ARCHITECTURES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("architectures")
            .getter(getter(AwsEcrContainerAggregation::architectures))
            .setter(setter(Builder::architectures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> IMAGE_SHAS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("imageShas")
            .getter(getter(AwsEcrContainerAggregation::imageShas))
            .setter(setter(Builder::imageShas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageShas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> IMAGE_TAGS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("imageTags")
            .getter(getter(AwsEcrContainerAggregation::imageTags))
            .setter(setter(Builder::imageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> REPOSITORIES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("repositories")
            .getter(getter(AwsEcrContainerAggregation::repositories))
            .setter(setter(Builder::repositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceIds")
            .getter(getter(AwsEcrContainerAggregation::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(AwsEcrContainerAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(AwsEcrContainerAggregation::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURES_FIELD,
            IMAGE_SHAS_FIELD, IMAGE_TAGS_FIELD, REPOSITORIES_FIELD, RESOURCE_IDS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> architectures;

    private final List<StringFilter> imageShas;

    private final List<StringFilter> imageTags;

    private final List<StringFilter> repositories;

    private final List<StringFilter> resourceIds;

    private final String sortBy;

    private final String sortOrder;

    private AwsEcrContainerAggregation(BuilderImpl builder) {
        this.architectures = builder.architectures;
        this.imageShas = builder.imageShas;
        this.imageTags = builder.imageTags;
        this.repositories = builder.repositories;
        this.resourceIds = builder.resourceIds;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the Architectures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectures() {
        return architectures != null && !(architectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The architecture of the containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The architecture of the containers.
     */
    public final List<StringFilter> architectures() {
        return architectures;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageShas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageShas() {
        return imageShas != null && !(imageShas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The image SHA values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageShas} method.
     * </p>
     * 
     * @return The image SHA values.
     */
    public final List<StringFilter> imageShas() {
        return imageShas;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageTags() {
        return imageTags != null && !(imageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The image tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageTags} method.
     * </p>
     * 
     * @return The image tags.
     */
    public final List<StringFilter> imageTags() {
        return imageTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Repositories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositories() {
        return repositories != null && !(repositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositories} method.
     * </p>
     * 
     * @return The container repositories.
     */
    public final List<StringFilter> repositories() {
        return repositories;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container resource IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return The container resource IDs.
     */
    public final List<StringFilter> resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The value to sort by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AwsEcrContainerSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort by.
     * @see AwsEcrContainerSortBy
     */
    public final AwsEcrContainerSortBy sortBy() {
        return AwsEcrContainerSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AwsEcrContainerSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort by.
     * @see AwsEcrContainerSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order (ascending or descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order (ascending or descending).
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order (ascending or descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order (ascending or descending).
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectures() ? architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImageShas() ? imageShas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImageTags() ? imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositories() ? repositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerAggregation)) {
            return false;
        }
        AwsEcrContainerAggregation other = (AwsEcrContainerAggregation) obj;
        return hasArchitectures() == other.hasArchitectures() && Objects.equals(architectures(), other.architectures())
                && hasImageShas() == other.hasImageShas() && Objects.equals(imageShas(), other.imageShas())
                && hasImageTags() == other.hasImageTags() && Objects.equals(imageTags(), other.imageTags())
                && hasRepositories() == other.hasRepositories() && Objects.equals(repositories(), other.repositories())
                && hasResourceIds() == other.hasResourceIds() && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcrContainerAggregation").add("Architectures", hasArchitectures() ? architectures() : null)
                .add("ImageShas", hasImageShas() ? imageShas() : null).add("ImageTags", hasImageTags() ? imageTags() : null)
                .add("Repositories", hasRepositories() ? repositories() : null)
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "architectures":
            return Optional.ofNullable(clazz.cast(architectures()));
        case "imageShas":
            return Optional.ofNullable(clazz.cast(imageShas()));
        case "imageTags":
            return Optional.ofNullable(clazz.cast(imageTags()));
        case "repositories":
            return Optional.ofNullable(clazz.cast(repositories()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerAggregation, T> g) {
        return obj -> g.apply((AwsEcrContainerAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcrContainerAggregation> {
        /**
         * <p>
         * The architecture of the containers.
         * </p>
         * 
         * @param architectures
         *        The architecture of the containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Collection<StringFilter> architectures);

        /**
         * <p>
         * The architecture of the containers.
         * </p>
         * 
         * @param architectures
         *        The architecture of the containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(StringFilter... architectures);

        /**
         * <p>
         * The architecture of the containers.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StringFilter>.Builder} avoiding the
         * need to create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #architectures(List<StringFilter>)}.
         * 
         * @param architectures
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #architectures(List<StringFilter>)
         */
        Builder architectures(Consumer<StringFilter.Builder>... architectures);

        /**
         * <p>
         * The image SHA values.
         * </p>
         * 
         * @param imageShas
         *        The image SHA values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageShas(Collection<StringFilter> imageShas);

        /**
         * <p>
         * The image SHA values.
         * </p>
         * 
         * @param imageShas
         *        The image SHA values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageShas(StringFilter... imageShas);

        /**
         * <p>
         * The image SHA values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StringFilter>.Builder} avoiding the
         * need to create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #imageShas(List<StringFilter>)}.
         * 
         * @param imageShas
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageShas(List<StringFilter>)
         */
        Builder imageShas(Consumer<StringFilter.Builder>... imageShas);

        /**
         * <p>
         * The image tags.
         * </p>
         * 
         * @param imageTags
         *        The image tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(Collection<StringFilter> imageTags);

        /**
         * <p>
         * The image tags.
         * </p>
         * 
         * @param imageTags
         *        The image tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(StringFilter... imageTags);

        /**
         * <p>
         * The image tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StringFilter>.Builder} avoiding the
         * need to create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #imageTags(List<StringFilter>)}.
         * 
         * @param imageTags
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageTags(List<StringFilter>)
         */
        Builder imageTags(Consumer<StringFilter.Builder>... imageTags);

        /**
         * <p>
         * The container repositories.
         * </p>
         * 
         * @param repositories
         *        The container repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(Collection<StringFilter> repositories);

        /**
         * <p>
         * The container repositories.
         * </p>
         * 
         * @param repositories
         *        The container repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositories(StringFilter... repositories);

        /**
         * <p>
         * The container repositories.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StringFilter>.Builder} avoiding the
         * need to create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #repositories(List<StringFilter>)}.
         * 
         * @param repositories
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositories(List<StringFilter>)
         */
        Builder repositories(Consumer<StringFilter.Builder>... repositories);

        /**
         * <p>
         * The container resource IDs.
         * </p>
         * 
         * @param resourceIds
         *        The container resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<StringFilter> resourceIds);

        /**
         * <p>
         * The container resource IDs.
         * </p>
         * 
         * @param resourceIds
         *        The container resource IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(StringFilter... resourceIds);

        /**
         * <p>
         * The container resource IDs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StringFilter>.Builder} avoiding the
         * need to create one manually via {@link List<StringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StringFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceIds(List<StringFilter>)}.
         * 
         * @param resourceIds
         *        a consumer that will call methods on {@link List<StringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIds(List<StringFilter>)
         */
        Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds);

        /**
         * <p>
         * The value to sort by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort by.
         * @see AwsEcrContainerSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsEcrContainerSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort by.
         * @see AwsEcrContainerSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsEcrContainerSortBy
         */
        Builder sortBy(AwsEcrContainerSortBy sortBy);

        /**
         * <p>
         * The sort order (ascending or descending).
         * </p>
         * 
         * @param sortOrder
         *        The sort order (ascending or descending).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order (ascending or descending).
         * </p>
         * 
         * @param sortOrder
         *        The sort order (ascending or descending).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> architectures = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> imageShas = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> imageTags = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> repositories = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerAggregation model) {
            architectures(model.architectures);
            imageShas(model.imageShas);
            imageTags(model.imageTags);
            repositories(model.repositories);
            resourceIds(model.resourceIds);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getArchitectures() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.architectures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArchitectures(Collection<StringFilter.BuilderImpl> architectures) {
            this.architectures = StringFilterListCopier.copyFromBuilder(architectures);
        }

        @Override
        public final Builder architectures(Collection<StringFilter> architectures) {
            this.architectures = StringFilterListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(StringFilter... architectures) {
            architectures(Arrays.asList(architectures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Consumer<StringFilter.Builder>... architectures) {
            architectures(Stream.of(architectures).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getImageShas() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.imageShas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageShas(Collection<StringFilter.BuilderImpl> imageShas) {
            this.imageShas = StringFilterListCopier.copyFromBuilder(imageShas);
        }

        @Override
        public final Builder imageShas(Collection<StringFilter> imageShas) {
            this.imageShas = StringFilterListCopier.copy(imageShas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageShas(StringFilter... imageShas) {
            imageShas(Arrays.asList(imageShas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageShas(Consumer<StringFilter.Builder>... imageShas) {
            imageShas(Stream.of(imageShas).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getImageTags() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.imageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageTags(Collection<StringFilter.BuilderImpl> imageTags) {
            this.imageTags = StringFilterListCopier.copyFromBuilder(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<StringFilter> imageTags) {
            this.imageTags = StringFilterListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(StringFilter... imageTags) {
            imageTags(Arrays.asList(imageTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(Consumer<StringFilter.Builder>... imageTags) {
            imageTags(Stream.of(imageTags).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRepositories() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.repositories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositories(Collection<StringFilter.BuilderImpl> repositories) {
            this.repositories = StringFilterListCopier.copyFromBuilder(repositories);
        }

        @Override
        public final Builder repositories(Collection<StringFilter> repositories) {
            this.repositories = StringFilterListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(StringFilter... repositories) {
            repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<StringFilter.Builder>... repositories) {
            repositories(Stream.of(repositories).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds) {
            resourceIds(Stream.of(resourceIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(AwsEcrContainerSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public AwsEcrContainerAggregation build() {
            return new AwsEcrContainerAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
