/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReportingErrorCode {
    INTERNAL_ERROR("INTERNAL_ERROR"),
    INVALID_PERMISSIONS("INVALID_PERMISSIONS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReportingErrorCode> VALUE_MAP;
    private final String value;

    private ReportingErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportingErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportingErrorCode> knownValues() {
        EnumSet<ReportingErrorCode> knownValues = EnumSet.allOf(ReportingErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReportingErrorCode.class, ReportingErrorCode::toString);
    }
}

