/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Web Services account within your environment that Amazon Inspector has been enabled for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Account implements SdkPojo, Serializable, ToCopyableBuilder<Account.Builder, Account> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(Account::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<ResourceStatus> RESOURCE_STATUS_FIELD = SdkField
            .<ResourceStatus> builder(MarshallingType.SDK_POJO).memberName("resourceStatus")
            .getter(getter(Account::resourceStatus)).setter(setter(Builder::resourceStatus)).constructor(ResourceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceStatus").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Account::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RESOURCE_STATUS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final ResourceStatus resourceStatus;

    private final String status;

    private Account(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.resourceStatus = builder.resourceStatus;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Details of the status of Amazon Inspector scans by resource type.
     * </p>
     * 
     * @return Details of the status of Amazon Inspector scans by resource type.
     */
    public final ResourceStatus resourceStatus() {
        return resourceStatus;
    }

    /**
     * <p>
     * The status of Amazon Inspector for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector for the account.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of Amazon Inspector for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of Amazon Inspector for the account.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceStatus(), other.resourceStatus())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Account").add("AccountId", accountId()).add("ResourceStatus", resourceStatus())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "resourceStatus":
            return Optional.ofNullable(clazz.cast(resourceStatus()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Account, T> g) {
        return obj -> g.apply((Account) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Account> {
        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Details of the status of Amazon Inspector scans by resource type.
         * </p>
         * 
         * @param resourceStatus
         *        Details of the status of Amazon Inspector scans by resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceStatus(ResourceStatus resourceStatus);

        /**
         * <p>
         * Details of the status of Amazon Inspector scans by resource type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceStatus.Builder} avoiding the need
         * to create one manually via {@link ResourceStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceStatus(ResourceStatus)}.
         * 
         * @param resourceStatus
         *        a consumer that will call methods on {@link ResourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceStatus(ResourceStatus)
         */
        default Builder resourceStatus(Consumer<ResourceStatus.Builder> resourceStatus) {
            return resourceStatus(ResourceStatus.builder().applyMutation(resourceStatus).build());
        }

        /**
         * <p>
         * The status of Amazon Inspector for the account.
         * </p>
         * 
         * @param status
         *        The status of Amazon Inspector for the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of Amazon Inspector for the account.
         * </p>
         * 
         * @param status
         *        The status of Amazon Inspector for the account.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private ResourceStatus resourceStatus;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Account model) {
            accountId(model.accountId);
            resourceStatus(model.resourceStatus);
            status(model.status);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final ResourceStatus.Builder getResourceStatus() {
            return resourceStatus != null ? resourceStatus.toBuilder() : null;
        }

        public final void setResourceStatus(ResourceStatus.BuilderImpl resourceStatus) {
            this.resourceStatus = resourceStatus != null ? resourceStatus.build() : null;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Account build() {
            return new Account(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
