/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains details about the results of an aggregation type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregationResponse.Builder, AggregationResponse> {
    private static final SdkField<AccountAggregationResponse> ACCOUNT_AGGREGATION_FIELD = SdkField
            .<AccountAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("accountAggregation")
            .getter(getter(AggregationResponse::accountAggregation)).setter(setter(Builder::accountAggregation))
            .constructor(AccountAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAggregation").build())
            .build();

    private static final SdkField<AmiAggregationResponse> AMI_AGGREGATION_FIELD = SdkField
            .<AmiAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("amiAggregation")
            .getter(getter(AggregationResponse::amiAggregation)).setter(setter(Builder::amiAggregation))
            .constructor(AmiAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amiAggregation").build()).build();

    private static final SdkField<AwsEcrContainerAggregationResponse> AWS_ECR_CONTAINER_AGGREGATION_FIELD = SdkField
            .<AwsEcrContainerAggregationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("awsEcrContainerAggregation")
            .getter(getter(AggregationResponse::awsEcrContainerAggregation))
            .setter(setter(Builder::awsEcrContainerAggregation))
            .constructor(AwsEcrContainerAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcrContainerAggregation").build())
            .build();

    private static final SdkField<Ec2InstanceAggregationResponse> EC2_INSTANCE_AGGREGATION_FIELD = SdkField
            .<Ec2InstanceAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("ec2InstanceAggregation")
            .getter(getter(AggregationResponse::ec2InstanceAggregation)).setter(setter(Builder::ec2InstanceAggregation))
            .constructor(Ec2InstanceAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceAggregation").build())
            .build();

    private static final SdkField<FindingTypeAggregationResponse> FINDING_TYPE_AGGREGATION_FIELD = SdkField
            .<FindingTypeAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("findingTypeAggregation")
            .getter(getter(AggregationResponse::findingTypeAggregation)).setter(setter(Builder::findingTypeAggregation))
            .constructor(FindingTypeAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingTypeAggregation").build())
            .build();

    private static final SdkField<ImageLayerAggregationResponse> IMAGE_LAYER_AGGREGATION_FIELD = SdkField
            .<ImageLayerAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("imageLayerAggregation")
            .getter(getter(AggregationResponse::imageLayerAggregation)).setter(setter(Builder::imageLayerAggregation))
            .constructor(ImageLayerAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageLayerAggregation").build())
            .build();

    private static final SdkField<PackageAggregationResponse> PACKAGE_AGGREGATION_FIELD = SdkField
            .<PackageAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("packageAggregation")
            .getter(getter(AggregationResponse::packageAggregation)).setter(setter(Builder::packageAggregation))
            .constructor(PackageAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageAggregation").build())
            .build();

    private static final SdkField<RepositoryAggregationResponse> REPOSITORY_AGGREGATION_FIELD = SdkField
            .<RepositoryAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("repositoryAggregation")
            .getter(getter(AggregationResponse::repositoryAggregation)).setter(setter(Builder::repositoryAggregation))
            .constructor(RepositoryAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryAggregation").build())
            .build();

    private static final SdkField<TitleAggregationResponse> TITLE_AGGREGATION_FIELD = SdkField
            .<TitleAggregationResponse> builder(MarshallingType.SDK_POJO).memberName("titleAggregation")
            .getter(getter(AggregationResponse::titleAggregation)).setter(setter(Builder::titleAggregation))
            .constructor(TitleAggregationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleAggregation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_AGGREGATION_FIELD,
            AMI_AGGREGATION_FIELD, AWS_ECR_CONTAINER_AGGREGATION_FIELD, EC2_INSTANCE_AGGREGATION_FIELD,
            FINDING_TYPE_AGGREGATION_FIELD, IMAGE_LAYER_AGGREGATION_FIELD, PACKAGE_AGGREGATION_FIELD,
            REPOSITORY_AGGREGATION_FIELD, TITLE_AGGREGATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AccountAggregationResponse accountAggregation;

    private final AmiAggregationResponse amiAggregation;

    private final AwsEcrContainerAggregationResponse awsEcrContainerAggregation;

    private final Ec2InstanceAggregationResponse ec2InstanceAggregation;

    private final FindingTypeAggregationResponse findingTypeAggregation;

    private final ImageLayerAggregationResponse imageLayerAggregation;

    private final PackageAggregationResponse packageAggregation;

    private final RepositoryAggregationResponse repositoryAggregation;

    private final TitleAggregationResponse titleAggregation;

    private final Type type;

    private AggregationResponse(BuilderImpl builder) {
        this.accountAggregation = builder.accountAggregation;
        this.amiAggregation = builder.amiAggregation;
        this.awsEcrContainerAggregation = builder.awsEcrContainerAggregation;
        this.ec2InstanceAggregation = builder.ec2InstanceAggregation;
        this.findingTypeAggregation = builder.findingTypeAggregation;
        this.imageLayerAggregation = builder.imageLayerAggregation;
        this.packageAggregation = builder.packageAggregation;
        this.repositoryAggregation = builder.repositoryAggregation;
        this.titleAggregation = builder.titleAggregation;
        this.type = builder.type;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on Amazon Web Services account IDs.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on Amazon Web Services account IDs.
     */
    public final AccountAggregationResponse accountAggregation() {
        return accountAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
     */
    public final AmiAggregationResponse amiAggregation() {
        return amiAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on Amazon ECR container images.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on Amazon ECR container images.
     */
    public final AwsEcrContainerAggregationResponse awsEcrContainerAggregation() {
        return awsEcrContainerAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on Amazon EC2 instances.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on Amazon EC2 instances.
     */
    public final Ec2InstanceAggregationResponse ec2InstanceAggregation() {
        return ec2InstanceAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on finding types.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on finding types.
     */
    public final FindingTypeAggregationResponse findingTypeAggregation() {
        return findingTypeAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on container image layers.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on container image layers.
     */
    public final ImageLayerAggregationResponse imageLayerAggregation() {
        return imageLayerAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on operating system package type.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on operating system package type.
     */
    public final PackageAggregationResponse packageAggregation() {
        return packageAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on Amazon ECR repositories.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on Amazon ECR repositories.
     */
    public final RepositoryAggregationResponse repositoryAggregation() {
        return repositoryAggregation;
    }

    /**
     * <p>
     * An object that contains details about an aggregation response based on finding title.
     * </p>
     * 
     * @return An object that contains details about an aggregation response based on finding title.
     */
    public final TitleAggregationResponse titleAggregation() {
        return titleAggregation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(amiAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(awsEcrContainerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(imageLayerAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(packageAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryAggregation());
        hashCode = 31 * hashCode + Objects.hashCode(titleAggregation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationResponse)) {
            return false;
        }
        AggregationResponse other = (AggregationResponse) obj;
        return Objects.equals(accountAggregation(), other.accountAggregation())
                && Objects.equals(amiAggregation(), other.amiAggregation())
                && Objects.equals(awsEcrContainerAggregation(), other.awsEcrContainerAggregation())
                && Objects.equals(ec2InstanceAggregation(), other.ec2InstanceAggregation())
                && Objects.equals(findingTypeAggregation(), other.findingTypeAggregation())
                && Objects.equals(imageLayerAggregation(), other.imageLayerAggregation())
                && Objects.equals(packageAggregation(), other.packageAggregation())
                && Objects.equals(repositoryAggregation(), other.repositoryAggregation())
                && Objects.equals(titleAggregation(), other.titleAggregation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregationResponse").add("AccountAggregation", accountAggregation())
                .add("AmiAggregation", amiAggregation()).add("AwsEcrContainerAggregation", awsEcrContainerAggregation())
                .add("Ec2InstanceAggregation", ec2InstanceAggregation()).add("FindingTypeAggregation", findingTypeAggregation())
                .add("ImageLayerAggregation", imageLayerAggregation()).add("PackageAggregation", packageAggregation())
                .add("RepositoryAggregation", repositoryAggregation()).add("TitleAggregation", titleAggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountAggregation":
            return Optional.ofNullable(clazz.cast(accountAggregation()));
        case "amiAggregation":
            return Optional.ofNullable(clazz.cast(amiAggregation()));
        case "awsEcrContainerAggregation":
            return Optional.ofNullable(clazz.cast(awsEcrContainerAggregation()));
        case "ec2InstanceAggregation":
            return Optional.ofNullable(clazz.cast(ec2InstanceAggregation()));
        case "findingTypeAggregation":
            return Optional.ofNullable(clazz.cast(findingTypeAggregation()));
        case "imageLayerAggregation":
            return Optional.ofNullable(clazz.cast(imageLayerAggregation()));
        case "packageAggregation":
            return Optional.ofNullable(clazz.cast(packageAggregation()));
        case "repositoryAggregation":
            return Optional.ofNullable(clazz.cast(repositoryAggregation()));
        case "titleAggregation":
            return Optional.ofNullable(clazz.cast(titleAggregation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #accountAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon Web Services account IDs.
     * </p>
     * 
     * @param accountAggregation
     *        An object that contains details about an aggregation response based on Amazon Web Services account IDs.
     */
    public static AggregationResponse fromAccountAggregation(AccountAggregationResponse accountAggregation) {
        return builder().accountAggregation(accountAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #accountAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon Web Services account IDs.
     * </p>
     * 
     * @param accountAggregation
     *        An object that contains details about an aggregation response based on Amazon Web Services account IDs.
     */
    public static AggregationResponse fromAccountAggregation(Consumer<AccountAggregationResponse.Builder> accountAggregation) {
        AccountAggregationResponse.Builder builder = AccountAggregationResponse.builder();
        accountAggregation.accept(builder);
        return fromAccountAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #amiAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
     * </p>
     * 
     * @param amiAggregation
     *        An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
     */
    public static AggregationResponse fromAmiAggregation(AmiAggregationResponse amiAggregation) {
        return builder().amiAggregation(amiAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #amiAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
     * </p>
     * 
     * @param amiAggregation
     *        An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
     */
    public static AggregationResponse fromAmiAggregation(Consumer<AmiAggregationResponse.Builder> amiAggregation) {
        AmiAggregationResponse.Builder builder = AmiAggregationResponse.builder();
        amiAggregation.accept(builder);
        return fromAmiAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #awsEcrContainerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon ECR container images.
     * </p>
     * 
     * @param awsEcrContainerAggregation
     *        An object that contains details about an aggregation response based on Amazon ECR container images.
     */
    public static AggregationResponse fromAwsEcrContainerAggregation(AwsEcrContainerAggregationResponse awsEcrContainerAggregation) {
        return builder().awsEcrContainerAggregation(awsEcrContainerAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #awsEcrContainerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon ECR container images.
     * </p>
     * 
     * @param awsEcrContainerAggregation
     *        An object that contains details about an aggregation response based on Amazon ECR container images.
     */
    public static AggregationResponse fromAwsEcrContainerAggregation(
            Consumer<AwsEcrContainerAggregationResponse.Builder> awsEcrContainerAggregation) {
        AwsEcrContainerAggregationResponse.Builder builder = AwsEcrContainerAggregationResponse.builder();
        awsEcrContainerAggregation.accept(builder);
        return fromAwsEcrContainerAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2InstanceAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon EC2 instances.
     * </p>
     * 
     * @param ec2InstanceAggregation
     *        An object that contains details about an aggregation response based on Amazon EC2 instances.
     */
    public static AggregationResponse fromEc2InstanceAggregation(Ec2InstanceAggregationResponse ec2InstanceAggregation) {
        return builder().ec2InstanceAggregation(ec2InstanceAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #ec2InstanceAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon EC2 instances.
     * </p>
     * 
     * @param ec2InstanceAggregation
     *        An object that contains details about an aggregation response based on Amazon EC2 instances.
     */
    public static AggregationResponse fromEc2InstanceAggregation(
            Consumer<Ec2InstanceAggregationResponse.Builder> ec2InstanceAggregation) {
        Ec2InstanceAggregationResponse.Builder builder = Ec2InstanceAggregationResponse.builder();
        ec2InstanceAggregation.accept(builder);
        return fromEc2InstanceAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #findingTypeAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on finding types.
     * </p>
     * 
     * @param findingTypeAggregation
     *        An object that contains details about an aggregation response based on finding types.
     */
    public static AggregationResponse fromFindingTypeAggregation(FindingTypeAggregationResponse findingTypeAggregation) {
        return builder().findingTypeAggregation(findingTypeAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #findingTypeAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on finding types.
     * </p>
     * 
     * @param findingTypeAggregation
     *        An object that contains details about an aggregation response based on finding types.
     */
    public static AggregationResponse fromFindingTypeAggregation(
            Consumer<FindingTypeAggregationResponse.Builder> findingTypeAggregation) {
        FindingTypeAggregationResponse.Builder builder = FindingTypeAggregationResponse.builder();
        findingTypeAggregation.accept(builder);
        return fromFindingTypeAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #imageLayerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on container image layers.
     * </p>
     * 
     * @param imageLayerAggregation
     *        An object that contains details about an aggregation response based on container image layers.
     */
    public static AggregationResponse fromImageLayerAggregation(ImageLayerAggregationResponse imageLayerAggregation) {
        return builder().imageLayerAggregation(imageLayerAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #imageLayerAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on container image layers.
     * </p>
     * 
     * @param imageLayerAggregation
     *        An object that contains details about an aggregation response based on container image layers.
     */
    public static AggregationResponse fromImageLayerAggregation(
            Consumer<ImageLayerAggregationResponse.Builder> imageLayerAggregation) {
        ImageLayerAggregationResponse.Builder builder = ImageLayerAggregationResponse.builder();
        imageLayerAggregation.accept(builder);
        return fromImageLayerAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #packageAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on operating system package type.
     * </p>
     * 
     * @param packageAggregation
     *        An object that contains details about an aggregation response based on operating system package type.
     */
    public static AggregationResponse fromPackageAggregation(PackageAggregationResponse packageAggregation) {
        return builder().packageAggregation(packageAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #packageAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on operating system package type.
     * </p>
     * 
     * @param packageAggregation
     *        An object that contains details about an aggregation response based on operating system package type.
     */
    public static AggregationResponse fromPackageAggregation(Consumer<PackageAggregationResponse.Builder> packageAggregation) {
        PackageAggregationResponse.Builder builder = PackageAggregationResponse.builder();
        packageAggregation.accept(builder);
        return fromPackageAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #repositoryAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon ECR repositories.
     * </p>
     * 
     * @param repositoryAggregation
     *        An object that contains details about an aggregation response based on Amazon ECR repositories.
     */
    public static AggregationResponse fromRepositoryAggregation(RepositoryAggregationResponse repositoryAggregation) {
        return builder().repositoryAggregation(repositoryAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #repositoryAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on Amazon ECR repositories.
     * </p>
     * 
     * @param repositoryAggregation
     *        An object that contains details about an aggregation response based on Amazon ECR repositories.
     */
    public static AggregationResponse fromRepositoryAggregation(
            Consumer<RepositoryAggregationResponse.Builder> repositoryAggregation) {
        RepositoryAggregationResponse.Builder builder = RepositoryAggregationResponse.builder();
        repositoryAggregation.accept(builder);
        return fromRepositoryAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #titleAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on finding title.
     * </p>
     * 
     * @param titleAggregation
     *        An object that contains details about an aggregation response based on finding title.
     */
    public static AggregationResponse fromTitleAggregation(TitleAggregationResponse titleAggregation) {
        return builder().titleAggregation(titleAggregation).build();
    }

    /**
     * Create an instance of this class with {@link #titleAggregation()} initialized to the given value.
     *
     * <p>
     * An object that contains details about an aggregation response based on finding title.
     * </p>
     * 
     * @param titleAggregation
     *        An object that contains details about an aggregation response based on finding title.
     */
    public static AggregationResponse fromTitleAggregation(Consumer<TitleAggregationResponse.Builder> titleAggregation) {
        TitleAggregationResponse.Builder builder = TitleAggregationResponse.builder();
        titleAggregation.accept(builder);
        return fromTitleAggregation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregationResponse, T> g) {
        return obj -> g.apply((AggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregationResponse> {
        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon Web Services account IDs.
         * </p>
         * 
         * @param accountAggregation
         *        An object that contains details about an aggregation response based on Amazon Web Services account
         *        IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregation(AccountAggregationResponse accountAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon Web Services account IDs.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link AccountAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountAggregationResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #accountAggregation(AccountAggregationResponse)}.
         * 
         * @param accountAggregation
         *        a consumer that will call methods on {@link AccountAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAggregation(AccountAggregationResponse)
         */
        default Builder accountAggregation(Consumer<AccountAggregationResponse.Builder> accountAggregation) {
            return accountAggregation(AccountAggregationResponse.builder().applyMutation(accountAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
         * </p>
         * 
         * @param amiAggregation
         *        An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiAggregation(AmiAggregationResponse amiAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon Machine Images (AMIs).
         * </p>
         * This is a convenience method that creates an instance of the {@link AmiAggregationResponse.Builder} avoiding
         * the need to create one manually via {@link AmiAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link AmiAggregationResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #amiAggregation(AmiAggregationResponse)}.
         * 
         * @param amiAggregation
         *        a consumer that will call methods on {@link AmiAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amiAggregation(AmiAggregationResponse)
         */
        default Builder amiAggregation(Consumer<AmiAggregationResponse.Builder> amiAggregation) {
            return amiAggregation(AmiAggregationResponse.builder().applyMutation(amiAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon ECR container images.
         * </p>
         * 
         * @param awsEcrContainerAggregation
         *        An object that contains details about an aggregation response based on Amazon ECR container images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcrContainerAggregation(AwsEcrContainerAggregationResponse awsEcrContainerAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon ECR container images.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcrContainerAggregationResponse.Builder} avoiding the need to create one manually via
         * {@link AwsEcrContainerAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEcrContainerAggregationResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #awsEcrContainerAggregation(AwsEcrContainerAggregationResponse)}.
         * 
         * @param awsEcrContainerAggregation
         *        a consumer that will call methods on {@link AwsEcrContainerAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcrContainerAggregation(AwsEcrContainerAggregationResponse)
         */
        default Builder awsEcrContainerAggregation(Consumer<AwsEcrContainerAggregationResponse.Builder> awsEcrContainerAggregation) {
            return awsEcrContainerAggregation(AwsEcrContainerAggregationResponse.builder()
                    .applyMutation(awsEcrContainerAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon EC2 instances.
         * </p>
         * 
         * @param ec2InstanceAggregation
         *        An object that contains details about an aggregation response based on Amazon EC2 instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceAggregation(Ec2InstanceAggregationResponse ec2InstanceAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon EC2 instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2InstanceAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link Ec2InstanceAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ec2InstanceAggregationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2InstanceAggregation(Ec2InstanceAggregationResponse)}.
         * 
         * @param ec2InstanceAggregation
         *        a consumer that will call methods on {@link Ec2InstanceAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceAggregation(Ec2InstanceAggregationResponse)
         */
        default Builder ec2InstanceAggregation(Consumer<Ec2InstanceAggregationResponse.Builder> ec2InstanceAggregation) {
            return ec2InstanceAggregation(Ec2InstanceAggregationResponse.builder().applyMutation(ec2InstanceAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on finding types.
         * </p>
         * 
         * @param findingTypeAggregation
         *        An object that contains details about an aggregation response based on finding types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingTypeAggregation(FindingTypeAggregationResponse findingTypeAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on finding types.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingTypeAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link FindingTypeAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link FindingTypeAggregationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #findingTypeAggregation(FindingTypeAggregationResponse)}.
         * 
         * @param findingTypeAggregation
         *        a consumer that will call methods on {@link FindingTypeAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingTypeAggregation(FindingTypeAggregationResponse)
         */
        default Builder findingTypeAggregation(Consumer<FindingTypeAggregationResponse.Builder> findingTypeAggregation) {
            return findingTypeAggregation(FindingTypeAggregationResponse.builder().applyMutation(findingTypeAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on container image layers.
         * </p>
         * 
         * @param imageLayerAggregation
         *        An object that contains details about an aggregation response based on container image layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageLayerAggregation(ImageLayerAggregationResponse imageLayerAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on container image layers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageLayerAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link ImageLayerAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageLayerAggregationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #imageLayerAggregation(ImageLayerAggregationResponse)}.
         * 
         * @param imageLayerAggregation
         *        a consumer that will call methods on {@link ImageLayerAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageLayerAggregation(ImageLayerAggregationResponse)
         */
        default Builder imageLayerAggregation(Consumer<ImageLayerAggregationResponse.Builder> imageLayerAggregation) {
            return imageLayerAggregation(ImageLayerAggregationResponse.builder().applyMutation(imageLayerAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on operating system package type.
         * </p>
         * 
         * @param packageAggregation
         *        An object that contains details about an aggregation response based on operating system package type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageAggregation(PackageAggregationResponse packageAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on operating system package type.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link PackageAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageAggregationResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #packageAggregation(PackageAggregationResponse)}.
         * 
         * @param packageAggregation
         *        a consumer that will call methods on {@link PackageAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageAggregation(PackageAggregationResponse)
         */
        default Builder packageAggregation(Consumer<PackageAggregationResponse.Builder> packageAggregation) {
            return packageAggregation(PackageAggregationResponse.builder().applyMutation(packageAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon ECR repositories.
         * </p>
         * 
         * @param repositoryAggregation
         *        An object that contains details about an aggregation response based on Amazon ECR repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryAggregation(RepositoryAggregationResponse repositoryAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on Amazon ECR repositories.
         * </p>
         * This is a convenience method that creates an instance of the {@link RepositoryAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link RepositoryAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepositoryAggregationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #repositoryAggregation(RepositoryAggregationResponse)}.
         * 
         * @param repositoryAggregation
         *        a consumer that will call methods on {@link RepositoryAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #repositoryAggregation(RepositoryAggregationResponse)
         */
        default Builder repositoryAggregation(Consumer<RepositoryAggregationResponse.Builder> repositoryAggregation) {
            return repositoryAggregation(RepositoryAggregationResponse.builder().applyMutation(repositoryAggregation).build());
        }

        /**
         * <p>
         * An object that contains details about an aggregation response based on finding title.
         * </p>
         * 
         * @param titleAggregation
         *        An object that contains details about an aggregation response based on finding title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleAggregation(TitleAggregationResponse titleAggregation);

        /**
         * <p>
         * An object that contains details about an aggregation response based on finding title.
         * </p>
         * This is a convenience method that creates an instance of the {@link TitleAggregationResponse.Builder}
         * avoiding the need to create one manually via {@link TitleAggregationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link TitleAggregationResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #titleAggregation(TitleAggregationResponse)}.
         * 
         * @param titleAggregation
         *        a consumer that will call methods on {@link TitleAggregationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleAggregation(TitleAggregationResponse)
         */
        default Builder titleAggregation(Consumer<TitleAggregationResponse.Builder> titleAggregation) {
            return titleAggregation(TitleAggregationResponse.builder().applyMutation(titleAggregation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountAggregationResponse accountAggregation;

        private AmiAggregationResponse amiAggregation;

        private AwsEcrContainerAggregationResponse awsEcrContainerAggregation;

        private Ec2InstanceAggregationResponse ec2InstanceAggregation;

        private FindingTypeAggregationResponse findingTypeAggregation;

        private ImageLayerAggregationResponse imageLayerAggregation;

        private PackageAggregationResponse packageAggregation;

        private RepositoryAggregationResponse repositoryAggregation;

        private TitleAggregationResponse titleAggregation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationResponse model) {
            accountAggregation(model.accountAggregation);
            amiAggregation(model.amiAggregation);
            awsEcrContainerAggregation(model.awsEcrContainerAggregation);
            ec2InstanceAggregation(model.ec2InstanceAggregation);
            findingTypeAggregation(model.findingTypeAggregation);
            imageLayerAggregation(model.imageLayerAggregation);
            packageAggregation(model.packageAggregation);
            repositoryAggregation(model.repositoryAggregation);
            titleAggregation(model.titleAggregation);
        }

        public final AccountAggregationResponse.Builder getAccountAggregation() {
            return accountAggregation != null ? accountAggregation.toBuilder() : null;
        }

        public final void setAccountAggregation(AccountAggregationResponse.BuilderImpl accountAggregation) {
            Object oldValue = this.accountAggregation;
            this.accountAggregation = accountAggregation != null ? accountAggregation.build() : null;
            handleUnionValueChange(Type.ACCOUNT_AGGREGATION, oldValue, this.accountAggregation);
        }

        @Override
        public final Builder accountAggregation(AccountAggregationResponse accountAggregation) {
            Object oldValue = this.accountAggregation;
            this.accountAggregation = accountAggregation;
            handleUnionValueChange(Type.ACCOUNT_AGGREGATION, oldValue, this.accountAggregation);
            return this;
        }

        public final AmiAggregationResponse.Builder getAmiAggregation() {
            return amiAggregation != null ? amiAggregation.toBuilder() : null;
        }

        public final void setAmiAggregation(AmiAggregationResponse.BuilderImpl amiAggregation) {
            Object oldValue = this.amiAggregation;
            this.amiAggregation = amiAggregation != null ? amiAggregation.build() : null;
            handleUnionValueChange(Type.AMI_AGGREGATION, oldValue, this.amiAggregation);
        }

        @Override
        public final Builder amiAggregation(AmiAggregationResponse amiAggregation) {
            Object oldValue = this.amiAggregation;
            this.amiAggregation = amiAggregation;
            handleUnionValueChange(Type.AMI_AGGREGATION, oldValue, this.amiAggregation);
            return this;
        }

        public final AwsEcrContainerAggregationResponse.Builder getAwsEcrContainerAggregation() {
            return awsEcrContainerAggregation != null ? awsEcrContainerAggregation.toBuilder() : null;
        }

        public final void setAwsEcrContainerAggregation(AwsEcrContainerAggregationResponse.BuilderImpl awsEcrContainerAggregation) {
            Object oldValue = this.awsEcrContainerAggregation;
            this.awsEcrContainerAggregation = awsEcrContainerAggregation != null ? awsEcrContainerAggregation.build() : null;
            handleUnionValueChange(Type.AWS_ECR_CONTAINER_AGGREGATION, oldValue, this.awsEcrContainerAggregation);
        }

        @Override
        public final Builder awsEcrContainerAggregation(AwsEcrContainerAggregationResponse awsEcrContainerAggregation) {
            Object oldValue = this.awsEcrContainerAggregation;
            this.awsEcrContainerAggregation = awsEcrContainerAggregation;
            handleUnionValueChange(Type.AWS_ECR_CONTAINER_AGGREGATION, oldValue, this.awsEcrContainerAggregation);
            return this;
        }

        public final Ec2InstanceAggregationResponse.Builder getEc2InstanceAggregation() {
            return ec2InstanceAggregation != null ? ec2InstanceAggregation.toBuilder() : null;
        }

        public final void setEc2InstanceAggregation(Ec2InstanceAggregationResponse.BuilderImpl ec2InstanceAggregation) {
            Object oldValue = this.ec2InstanceAggregation;
            this.ec2InstanceAggregation = ec2InstanceAggregation != null ? ec2InstanceAggregation.build() : null;
            handleUnionValueChange(Type.EC2_INSTANCE_AGGREGATION, oldValue, this.ec2InstanceAggregation);
        }

        @Override
        public final Builder ec2InstanceAggregation(Ec2InstanceAggregationResponse ec2InstanceAggregation) {
            Object oldValue = this.ec2InstanceAggregation;
            this.ec2InstanceAggregation = ec2InstanceAggregation;
            handleUnionValueChange(Type.EC2_INSTANCE_AGGREGATION, oldValue, this.ec2InstanceAggregation);
            return this;
        }

        public final FindingTypeAggregationResponse.Builder getFindingTypeAggregation() {
            return findingTypeAggregation != null ? findingTypeAggregation.toBuilder() : null;
        }

        public final void setFindingTypeAggregation(FindingTypeAggregationResponse.BuilderImpl findingTypeAggregation) {
            Object oldValue = this.findingTypeAggregation;
            this.findingTypeAggregation = findingTypeAggregation != null ? findingTypeAggregation.build() : null;
            handleUnionValueChange(Type.FINDING_TYPE_AGGREGATION, oldValue, this.findingTypeAggregation);
        }

        @Override
        public final Builder findingTypeAggregation(FindingTypeAggregationResponse findingTypeAggregation) {
            Object oldValue = this.findingTypeAggregation;
            this.findingTypeAggregation = findingTypeAggregation;
            handleUnionValueChange(Type.FINDING_TYPE_AGGREGATION, oldValue, this.findingTypeAggregation);
            return this;
        }

        public final ImageLayerAggregationResponse.Builder getImageLayerAggregation() {
            return imageLayerAggregation != null ? imageLayerAggregation.toBuilder() : null;
        }

        public final void setImageLayerAggregation(ImageLayerAggregationResponse.BuilderImpl imageLayerAggregation) {
            Object oldValue = this.imageLayerAggregation;
            this.imageLayerAggregation = imageLayerAggregation != null ? imageLayerAggregation.build() : null;
            handleUnionValueChange(Type.IMAGE_LAYER_AGGREGATION, oldValue, this.imageLayerAggregation);
        }

        @Override
        public final Builder imageLayerAggregation(ImageLayerAggregationResponse imageLayerAggregation) {
            Object oldValue = this.imageLayerAggregation;
            this.imageLayerAggregation = imageLayerAggregation;
            handleUnionValueChange(Type.IMAGE_LAYER_AGGREGATION, oldValue, this.imageLayerAggregation);
            return this;
        }

        public final PackageAggregationResponse.Builder getPackageAggregation() {
            return packageAggregation != null ? packageAggregation.toBuilder() : null;
        }

        public final void setPackageAggregation(PackageAggregationResponse.BuilderImpl packageAggregation) {
            Object oldValue = this.packageAggregation;
            this.packageAggregation = packageAggregation != null ? packageAggregation.build() : null;
            handleUnionValueChange(Type.PACKAGE_AGGREGATION, oldValue, this.packageAggregation);
        }

        @Override
        public final Builder packageAggregation(PackageAggregationResponse packageAggregation) {
            Object oldValue = this.packageAggregation;
            this.packageAggregation = packageAggregation;
            handleUnionValueChange(Type.PACKAGE_AGGREGATION, oldValue, this.packageAggregation);
            return this;
        }

        public final RepositoryAggregationResponse.Builder getRepositoryAggregation() {
            return repositoryAggregation != null ? repositoryAggregation.toBuilder() : null;
        }

        public final void setRepositoryAggregation(RepositoryAggregationResponse.BuilderImpl repositoryAggregation) {
            Object oldValue = this.repositoryAggregation;
            this.repositoryAggregation = repositoryAggregation != null ? repositoryAggregation.build() : null;
            handleUnionValueChange(Type.REPOSITORY_AGGREGATION, oldValue, this.repositoryAggregation);
        }

        @Override
        public final Builder repositoryAggregation(RepositoryAggregationResponse repositoryAggregation) {
            Object oldValue = this.repositoryAggregation;
            this.repositoryAggregation = repositoryAggregation;
            handleUnionValueChange(Type.REPOSITORY_AGGREGATION, oldValue, this.repositoryAggregation);
            return this;
        }

        public final TitleAggregationResponse.Builder getTitleAggregation() {
            return titleAggregation != null ? titleAggregation.toBuilder() : null;
        }

        public final void setTitleAggregation(TitleAggregationResponse.BuilderImpl titleAggregation) {
            Object oldValue = this.titleAggregation;
            this.titleAggregation = titleAggregation != null ? titleAggregation.build() : null;
            handleUnionValueChange(Type.TITLE_AGGREGATION, oldValue, this.titleAggregation);
        }

        @Override
        public final Builder titleAggregation(TitleAggregationResponse titleAggregation) {
            Object oldValue = this.titleAggregation;
            this.titleAggregation = titleAggregation;
            handleUnionValueChange(Type.TITLE_AGGREGATION, oldValue, this.titleAggregation);
            return this;
        }

        @Override
        public AggregationResponse build() {
            return new AggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AggregationResponse#type()
     */
    public enum Type {
        ACCOUNT_AGGREGATION,

        AMI_AGGREGATION,

        AWS_ECR_CONTAINER_AGGREGATION,

        EC2_INSTANCE_AGGREGATION,

        FINDING_TYPE_AGGREGATION,

        IMAGE_LAYER_AGGREGATION,

        PACKAGE_AGGREGATION,

        REPOSITORY_AGGREGATION,

        TITLE_AGGREGATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
