/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of a finding aggregation by Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2InstanceAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2InstanceAggregationResponse.Builder, Ec2InstanceAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(Ec2InstanceAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> AMI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ami")
            .getter(getter(Ec2InstanceAggregationResponse::ami)).setter(setter(Builder::ami))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ami").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceId").getter(getter(Ec2InstanceAggregationResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()).build();

    private static final SdkField<Map<String, String>> INSTANCE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("instanceTags")
            .getter(getter(Ec2InstanceAggregationResponse::instanceTags))
            .setter(setter(Builder::instanceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> NETWORK_FINDINGS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("networkFindings").getter(getter(Ec2InstanceAggregationResponse::networkFindings))
            .setter(setter(Builder::networkFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkFindings").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operatingSystem").getter(getter(Ec2InstanceAggregationResponse::operatingSystem))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystem").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(Ec2InstanceAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AMI_FIELD,
            INSTANCE_ID_FIELD, INSTANCE_TAGS_FIELD, NETWORK_FINDINGS_FIELD, OPERATING_SYSTEM_FIELD, SEVERITY_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String ami;

    private final String instanceId;

    private final Map<String, String> instanceTags;

    private final Long networkFindings;

    private final String operatingSystem;

    private final SeverityCounts severityCounts;

    private Ec2InstanceAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.ami = builder.ami;
        this.instanceId = builder.instanceId;
        this.instanceTags = builder.instanceTags;
        this.networkFindings = builder.networkFindings;
        this.operatingSystem = builder.operatingSystem;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The Amazon Web Services account the Amazon EC2 instance belongs to.
     * </p>
     * 
     * @return The Amazon Web Services account the Amazon EC2 instance belongs to.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) of the Amazon EC2 instance.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) of the Amazon EC2 instance.
     */
    public final String ami() {
        return ami;
    }

    /**
     * <p>
     * The Amazon EC2 instance ID.
     * </p>
     * 
     * @return The Amazon EC2 instance ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTags() {
        return instanceTags != null && !(instanceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags attached to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTags} method.
     * </p>
     * 
     * @return The tags attached to the instance.
     */
    public final Map<String, String> instanceTags() {
        return instanceTags;
    }

    /**
     * <p>
     * The number of network findings for the Amazon EC2 instance.
     * </p>
     * 
     * @return The number of network findings for the Amazon EC2 instance.
     */
    public final Long networkFindings() {
        return networkFindings;
    }

    /**
     * <p>
     * The operating system of the Amazon EC2 instance.
     * </p>
     * 
     * @return The operating system of the Amazon EC2 instance.
     */
    public final String operatingSystem() {
        return operatingSystem;
    }

    /**
     * <p>
     * An object that contains the count of matched findings per severity.
     * </p>
     * 
     * @return An object that contains the count of matched findings per severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(ami());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTags() ? instanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkFindings());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2InstanceAggregationResponse)) {
            return false;
        }
        Ec2InstanceAggregationResponse other = (Ec2InstanceAggregationResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(ami(), other.ami())
                && Objects.equals(instanceId(), other.instanceId()) && hasInstanceTags() == other.hasInstanceTags()
                && Objects.equals(instanceTags(), other.instanceTags())
                && Objects.equals(networkFindings(), other.networkFindings())
                && Objects.equals(operatingSystem(), other.operatingSystem())
                && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2InstanceAggregationResponse").add("AccountId", accountId()).add("Ami", ami())
                .add("InstanceId", instanceId()).add("InstanceTags", hasInstanceTags() ? instanceTags() : null)
                .add("NetworkFindings", networkFindings()).add("OperatingSystem", operatingSystem())
                .add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ami":
            return Optional.ofNullable(clazz.cast(ami()));
        case "instanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "instanceTags":
            return Optional.ofNullable(clazz.cast(instanceTags()));
        case "networkFindings":
            return Optional.ofNullable(clazz.cast(networkFindings()));
        case "operatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystem()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2InstanceAggregationResponse, T> g) {
        return obj -> g.apply((Ec2InstanceAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2InstanceAggregationResponse> {
        /**
         * <p>
         * The Amazon Web Services account the Amazon EC2 instance belongs to.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account the Amazon EC2 instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Machine Image (AMI) of the Amazon EC2 instance.
         * </p>
         * 
         * @param ami
         *        The Amazon Machine Image (AMI) of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ami(String ami);

        /**
         * <p>
         * The Amazon EC2 instance ID.
         * </p>
         * 
         * @param instanceId
         *        The Amazon EC2 instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The tags attached to the instance.
         * </p>
         * 
         * @param instanceTags
         *        The tags attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTags(Map<String, String> instanceTags);

        /**
         * <p>
         * The number of network findings for the Amazon EC2 instance.
         * </p>
         * 
         * @param networkFindings
         *        The number of network findings for the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkFindings(Long networkFindings);

        /**
         * <p>
         * The operating system of the Amazon EC2 instance.
         * </p>
         * 
         * @param operatingSystem
         *        The operating system of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * An object that contains the count of matched findings per severity.
         * </p>
         * 
         * @param severityCounts
         *        An object that contains the count of matched findings per severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * An object that contains the count of matched findings per severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String ami;

        private String instanceId;

        private Map<String, String> instanceTags = DefaultSdkAutoConstructMap.getInstance();

        private Long networkFindings;

        private String operatingSystem;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2InstanceAggregationResponse model) {
            accountId(model.accountId);
            ami(model.ami);
            instanceId(model.instanceId);
            instanceTags(model.instanceTags);
            networkFindings(model.networkFindings);
            operatingSystem(model.operatingSystem);
            severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAmi() {
            return ami;
        }

        public final void setAmi(String ami) {
            this.ami = ami;
        }

        @Override
        public final Builder ami(String ami) {
            this.ami = ami;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, String> getInstanceTags() {
            if (instanceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return instanceTags;
        }

        public final void setInstanceTags(Map<String, String> instanceTags) {
            this.instanceTags = TagMapCopier.copy(instanceTags);
        }

        @Override
        public final Builder instanceTags(Map<String, String> instanceTags) {
            this.instanceTags = TagMapCopier.copy(instanceTags);
            return this;
        }

        public final Long getNetworkFindings() {
            return networkFindings;
        }

        public final void setNetworkFindings(Long networkFindings) {
            this.networkFindings = networkFindings;
        }

        @Override
        public final Builder networkFindings(Long networkFindings) {
            this.networkFindings = networkFindings;
            return this;
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public Ec2InstanceAggregationResponse build() {
            return new Ec2InstanceAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
