/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingAggregationsResponse extends Inspector2Response implements
        ToCopyableBuilder<ListFindingAggregationsResponse.Builder, ListFindingAggregationsResponse> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationType").getter(getter(ListFindingAggregationsResponse::aggregationTypeAsString))
            .setter(setter(Builder::aggregationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingAggregationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AggregationResponse>> RESPONSES_FIELD = SdkField
            .<List<AggregationResponse>> builder(MarshallingType.LIST)
            .memberName("responses")
            .getter(getter(ListFindingAggregationsResponse::responses))
            .setter(setter(Builder::responses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD,
            NEXT_TOKEN_FIELD, RESPONSES_FIELD));

    private final String aggregationType;

    private final String nextToken;

    private final List<AggregationResponse> responses;

    private ListFindingAggregationsResponse(BuilderImpl builder) {
        super(builder);
        this.aggregationType = builder.aggregationType;
        this.nextToken = builder.nextToken;
        this.responses = builder.responses;
    }

    /**
     * <p>
     * The type of aggregation to perform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return The type of aggregation to perform.
     * @see AggregationType
     */
    public final AggregationType aggregationType() {
        return AggregationType.fromValue(aggregationType);
    }

    /**
     * <p>
     * The type of aggregation to perform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return The type of aggregation to perform.
     * @see AggregationType
     */
    public final String aggregationTypeAsString() {
        return aggregationType;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from
     * the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code>
     *         value returned from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Responses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResponses() {
        return responses != null && !(responses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Objects that contain the results of an aggregation operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponses} method.
     * </p>
     * 
     * @return Objects that contain the results of an aggregation operation.
     */
    public final List<AggregationResponse> responses() {
        return responses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponses() ? responses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingAggregationsResponse)) {
            return false;
        }
        ListFindingAggregationsResponse other = (ListFindingAggregationsResponse) obj;
        return Objects.equals(aggregationTypeAsString(), other.aggregationTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && hasResponses() == other.hasResponses()
                && Objects.equals(responses(), other.responses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingAggregationsResponse").add("AggregationType", aggregationTypeAsString())
                .add("NextToken", nextToken()).add("Responses", hasResponses() ? responses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregationType":
            return Optional.ofNullable(clazz.cast(aggregationTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "responses":
            return Optional.ofNullable(clazz.cast(responses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingAggregationsResponse, T> g) {
        return obj -> g.apply((ListFindingAggregationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFindingAggregationsResponse> {
        /**
         * <p>
         * The type of aggregation to perform.
         * </p>
         * 
         * @param aggregationType
         *        The type of aggregation to perform.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder aggregationType(String aggregationType);

        /**
         * <p>
         * The type of aggregation to perform.
         * </p>
         * 
         * @param aggregationType
         *        The type of aggregation to perform.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder aggregationType(AggregationType aggregationType);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value
         * returned from the previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the
         *        <code>NextToken</code> value returned from the previous request to continue listing results after the
         *        first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Objects that contain the results of an aggregation operation.
         * </p>
         * 
         * @param responses
         *        Objects that contain the results of an aggregation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Collection<AggregationResponse> responses);

        /**
         * <p>
         * Objects that contain the results of an aggregation operation.
         * </p>
         * 
         * @param responses
         *        Objects that contain the results of an aggregation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(AggregationResponse... responses);

        /**
         * <p>
         * Objects that contain the results of an aggregation operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AggregationResponse>.Builder}
         * avoiding the need to create one manually via {@link List<AggregationResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AggregationResponse>.Builder#build()} is called immediately
         * and its result is passed to {@link #responses(List<AggregationResponse>)}.
         * 
         * @param responses
         *        a consumer that will call methods on {@link List<AggregationResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responses(List<AggregationResponse>)
         */
        Builder responses(Consumer<AggregationResponse.Builder>... responses);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String aggregationType;

        private String nextToken;

        private List<AggregationResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingAggregationsResponse model) {
            super(model);
            aggregationType(model.aggregationType);
            nextToken(model.nextToken);
            responses(model.responses);
        }

        public final String getAggregationType() {
            return aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AggregationResponse.Builder> getResponses() {
            List<AggregationResponse.Builder> result = AggregationResponseListCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<AggregationResponse.BuilderImpl> responses) {
            this.responses = AggregationResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        public final Builder responses(Collection<AggregationResponse> responses) {
            this.responses = AggregationResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(AggregationResponse... responses) {
            responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responses(Consumer<AggregationResponse.Builder>... responses) {
            responses(Stream.of(responses).map(c -> AggregationResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFindingAggregationsResponse build() {
            return new ListFindingAggregationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
