/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoverageStatisticsRequest extends Inspector2Request implements
        ToCopyableBuilder<ListCoverageStatisticsRequest.Builder, ListCoverageStatisticsRequest> {
    private static final SdkField<CoverageFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<CoverageFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(ListCoverageStatisticsRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(CoverageFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<String> GROUP_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupBy").getter(getter(ListCoverageStatisticsRequest::groupByAsString))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCoverageStatisticsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CRITERIA_FIELD,
            GROUP_BY_FIELD, NEXT_TOKEN_FIELD));

    private final CoverageFilterCriteria filterCriteria;

    private final String groupBy;

    private final String nextToken;

    private ListCoverageStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.filterCriteria = builder.filterCriteria;
        this.groupBy = builder.groupBy;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An object that contains details on the filters to apply to the coverage data for your environment.
     * </p>
     * 
     * @return An object that contains details on the filters to apply to the coverage data for your environment.
     */
    public final CoverageFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The value to group the results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupBy} will
     * return {@link GroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByAsString}.
     * </p>
     * 
     * @return The value to group the results by.
     * @see GroupKey
     */
    public final GroupKey groupBy() {
        return GroupKey.fromValue(groupBy);
    }

    /**
     * <p>
     * The value to group the results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupBy} will
     * return {@link GroupKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupByAsString}.
     * </p>
     * 
     * @return The value to group the results by.
     * @see GroupKey
     */
    public final String groupByAsString() {
        return groupBy;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value returned from
     * the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the <code>NextToken</code>
     *         value returned from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageStatisticsRequest)) {
            return false;
        }
        ListCoverageStatisticsRequest other = (ListCoverageStatisticsRequest) obj;
        return Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(groupByAsString(), other.groupByAsString()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCoverageStatisticsRequest").add("FilterCriteria", filterCriteria())
                .add("GroupBy", groupByAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupByAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageStatisticsRequest, T> g) {
        return obj -> g.apply((ListCoverageStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListCoverageStatisticsRequest> {
        /**
         * <p>
         * An object that contains details on the filters to apply to the coverage data for your environment.
         * </p>
         * 
         * @param filterCriteria
         *        An object that contains details on the filters to apply to the coverage data for your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(CoverageFilterCriteria filterCriteria);

        /**
         * <p>
         * An object that contains details on the filters to apply to the coverage data for your environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link CoverageFilterCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoverageFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #filterCriteria(CoverageFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link CoverageFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(CoverageFilterCriteria)
         */
        default Builder filterCriteria(Consumer<CoverageFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(CoverageFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The value to group the results by.
         * </p>
         * 
         * @param groupBy
         *        The value to group the results by.
         * @see GroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupKey
         */
        Builder groupBy(String groupBy);

        /**
         * <p>
         * The value to group the results by.
         * </p>
         * 
         * @param groupBy
         *        The value to group the results by.
         * @see GroupKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupKey
         */
        Builder groupBy(GroupKey groupBy);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the <code>NextToken</code> value
         * returned from the previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the
         *        <code>NextToken</code> value returned from the previous request to continue listing results after the
         *        first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private CoverageFilterCriteria filterCriteria;

        private String groupBy;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageStatisticsRequest model) {
            super(model);
            filterCriteria(model.filterCriteria);
            groupBy(model.groupBy);
            nextToken(model.nextToken);
        }

        public final CoverageFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CoverageFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CoverageFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getGroupBy() {
            return groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupKey groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCoverageStatisticsRequest build() {
            return new ListCoverageStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
