/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingsReportStatusResponse extends Inspector2Response implements
        ToCopyableBuilder<GetFindingsReportStatusResponse.Builder, GetFindingsReportStatusResponse> {
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("destination").getter(getter(GetFindingsReportStatusResponse::destination))
            .setter(setter(Builder::destination)).constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(GetFindingsReportStatusResponse::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(GetFindingsReportStatusResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<FilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(GetFindingsReportStatusResponse::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(FilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<String> REPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportId").getter(getter(GetFindingsReportStatusResponse::reportId)).setter(setter(Builder::reportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetFindingsReportStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, FILTER_CRITERIA_FIELD, REPORT_ID_FIELD, STATUS_FIELD));

    private final Destination destination;

    private final String errorCode;

    private final String errorMessage;

    private final FilterCriteria filterCriteria;

    private final String reportId;

    private final String status;

    private GetFindingsReportStatusResponse(BuilderImpl builder) {
        super(builder);
        this.destination = builder.destination;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.filterCriteria = builder.filterCriteria;
        this.reportId = builder.reportId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The destination of the report.
     * </p>
     * 
     * @return The destination of the report.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * <p>
     * The error code of the report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ReportingErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code of the report.
     * @see ReportingErrorCode
     */
    public final ReportingErrorCode errorCode() {
        return ReportingErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code of the report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link ReportingErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code of the report.
     * @see ReportingErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The error message of the report.
     * </p>
     * 
     * @return The error message of the report.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The filter criteria associated with the report.
     * </p>
     * 
     * @return The filter criteria associated with the report.
     */
    public final FilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The ID of the report.
     * </p>
     * 
     * @return The ID of the report.
     */
    public final String reportId() {
        return reportId;
    }

    /**
     * <p>
     * The status of the report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExternalReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the report.
     * @see ExternalReportStatus
     */
    public final ExternalReportStatus status() {
        return ExternalReportStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExternalReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the report.
     * @see ExternalReportStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(reportId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsReportStatusResponse)) {
            return false;
        }
        GetFindingsReportStatusResponse other = (GetFindingsReportStatusResponse) obj;
        return Objects.equals(destination(), other.destination())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(filterCriteria(), other.filterCriteria()) && Objects.equals(reportId(), other.reportId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingsReportStatusResponse").add("Destination", destination())
                .add("ErrorCode", errorCodeAsString()).add("ErrorMessage", errorMessage())
                .add("FilterCriteria", filterCriteria()).add("ReportId", reportId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "reportId":
            return Optional.ofNullable(clazz.cast(reportId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsReportStatusResponse, T> g) {
        return obj -> g.apply((GetFindingsReportStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFindingsReportStatusResponse> {
        /**
         * <p>
         * The destination of the report.
         * </p>
         * 
         * @param destination
         *        The destination of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * The destination of the report.
         * </p>
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * The error code of the report.
         * </p>
         * 
         * @param errorCode
         *        The error code of the report.
         * @see ReportingErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportingErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code of the report.
         * </p>
         * 
         * @param errorCode
         *        The error code of the report.
         * @see ReportingErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportingErrorCode
         */
        Builder errorCode(ReportingErrorCode errorCode);

        /**
         * <p>
         * The error message of the report.
         * </p>
         * 
         * @param errorMessage
         *        The error message of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The filter criteria associated with the report.
         * </p>
         * 
         * @param filterCriteria
         *        The filter criteria associated with the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(FilterCriteria filterCriteria);

        /**
         * <p>
         * The filter criteria associated with the report.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterCriteria.Builder} avoiding the need
         * to create one manually via {@link FilterCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link FilterCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #filterCriteria(FilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link FilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(FilterCriteria)
         */
        default Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return filterCriteria(FilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The ID of the report.
         * </p>
         * 
         * @param reportId
         *        The ID of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportId(String reportId);

        /**
         * <p>
         * The status of the report.
         * </p>
         * 
         * @param status
         *        The status of the report.
         * @see ExternalReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalReportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the report.
         * </p>
         * 
         * @param status
         *        The status of the report.
         * @see ExternalReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalReportStatus
         */
        Builder status(ExternalReportStatus status);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private Destination destination;

        private String errorCode;

        private String errorMessage;

        private FilterCriteria filterCriteria;

        private String reportId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsReportStatusResponse model) {
            super(model);
            destination(model.destination);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            filterCriteria(model.filterCriteria);
            reportId(model.reportId);
            status(model.status);
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ReportingErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getReportId() {
            return reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExternalReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetFindingsReportStatusResponse build() {
            return new GetFindingsReportStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
