/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.inspector2.model.NumberFilter;
import software.amazon.awssdk.services.inspector2.model.StringFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageFilter> {
    private static final SdkField<StringFilter> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("architecture").getter(PackageFilter.getter(PackageFilter::architecture)).setter(PackageFilter.setter(Builder::architecture)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<NumberFilter> EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("epoch").getter(PackageFilter.getter(PackageFilter::epoch)).setter(PackageFilter.setter(Builder::epoch)).constructor(NumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epoch").build()}).build();
    private static final SdkField<StringFilter> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("name").getter(PackageFilter.getter(PackageFilter::name)).setter(PackageFilter.setter(Builder::name)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<StringFilter> RELEASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("release").getter(PackageFilter.getter(PackageFilter::release)).setter(PackageFilter.setter(Builder::release)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("release").build()}).build();
    private static final SdkField<StringFilter> SOURCE_LAYER_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceLayerHash").getter(PackageFilter.getter(PackageFilter::sourceLayerHash)).setter(PackageFilter.setter(Builder::sourceLayerHash)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLayerHash").build()}).build();
    private static final SdkField<StringFilter> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("version").getter(PackageFilter.getter(PackageFilter::version)).setter(PackageFilter.setter(Builder::version)).constructor(StringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD, EPOCH_FIELD, NAME_FIELD, RELEASE_FIELD, SOURCE_LAYER_HASH_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final StringFilter architecture;
    private final NumberFilter epoch;
    private final StringFilter name;
    private final StringFilter release;
    private final StringFilter sourceLayerHash;
    private final StringFilter version;

    private PackageFilter(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.epoch = builder.epoch;
        this.name = builder.name;
        this.release = builder.release;
        this.sourceLayerHash = builder.sourceLayerHash;
        this.version = builder.version;
    }

    public final StringFilter architecture() {
        return this.architecture;
    }

    public final NumberFilter epoch() {
        return this.epoch;
    }

    public final StringFilter name() {
        return this.name;
    }

    public final StringFilter release() {
        return this.release;
    }

    public final StringFilter sourceLayerHash() {
        return this.sourceLayerHash;
    }

    public final StringFilter version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.epoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.release());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLayerHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageFilter)) {
            return false;
        }
        PackageFilter other = (PackageFilter)obj;
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.epoch(), other.epoch()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.release(), other.release()) && Objects.equals(this.sourceLayerHash(), other.sourceLayerHash()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"PackageFilter").add("Architecture", (Object)this.architecture()).add("Epoch", (Object)this.epoch()).add("Name", (Object)this.name()).add("Release", (Object)this.release()).add("SourceLayerHash", (Object)this.sourceLayerHash()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "epoch": {
                return Optional.ofNullable(clazz.cast(this.epoch()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "release": {
                return Optional.ofNullable(clazz.cast(this.release()));
            }
            case "sourceLayerHash": {
                return Optional.ofNullable(clazz.cast(this.sourceLayerHash()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageFilter, T> g) {
        return obj -> g.apply((PackageFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StringFilter architecture;
        private NumberFilter epoch;
        private StringFilter name;
        private StringFilter release;
        private StringFilter sourceLayerHash;
        private StringFilter version;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageFilter model) {
            this.architecture(model.architecture);
            this.epoch(model.epoch);
            this.name(model.name);
            this.release(model.release);
            this.sourceLayerHash(model.sourceLayerHash);
            this.version(model.version);
        }

        public final StringFilter.Builder getArchitecture() {
            return this.architecture != null ? this.architecture.toBuilder() : null;
        }

        public final void setArchitecture(StringFilter.BuilderImpl architecture) {
            this.architecture = architecture != null ? architecture.build() : null;
        }

        @Override
        public final Builder architecture(StringFilter architecture) {
            this.architecture = architecture;
            return this;
        }

        public final NumberFilter.Builder getEpoch() {
            return this.epoch != null ? this.epoch.toBuilder() : null;
        }

        public final void setEpoch(NumberFilter.BuilderImpl epoch) {
            this.epoch = epoch != null ? epoch.build() : null;
        }

        @Override
        public final Builder epoch(NumberFilter epoch) {
            this.epoch = epoch;
            return this;
        }

        public final StringFilter.Builder getName() {
            return this.name != null ? this.name.toBuilder() : null;
        }

        public final void setName(StringFilter.BuilderImpl name) {
            this.name = name != null ? name.build() : null;
        }

        @Override
        public final Builder name(StringFilter name) {
            this.name = name;
            return this;
        }

        public final StringFilter.Builder getRelease() {
            return this.release != null ? this.release.toBuilder() : null;
        }

        public final void setRelease(StringFilter.BuilderImpl release) {
            this.release = release != null ? release.build() : null;
        }

        @Override
        public final Builder release(StringFilter release) {
            this.release = release;
            return this;
        }

        public final StringFilter.Builder getSourceLayerHash() {
            return this.sourceLayerHash != null ? this.sourceLayerHash.toBuilder() : null;
        }

        public final void setSourceLayerHash(StringFilter.BuilderImpl sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash != null ? sourceLayerHash.build() : null;
        }

        @Override
        public final Builder sourceLayerHash(StringFilter sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
            return this;
        }

        public final StringFilter.Builder getVersion() {
            return this.version != null ? this.version.toBuilder() : null;
        }

        public final void setVersion(StringFilter.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public final Builder version(StringFilter version) {
            this.version = version;
            return this;
        }

        public PackageFilter build() {
            return new PackageFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageFilter> {
        public Builder architecture(StringFilter var1);

        default public Builder architecture(Consumer<StringFilter.Builder> architecture) {
            return this.architecture((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(architecture)).build());
        }

        public Builder epoch(NumberFilter var1);

        default public Builder epoch(Consumer<NumberFilter.Builder> epoch) {
            return this.epoch((NumberFilter)((NumberFilter.Builder)NumberFilter.builder().applyMutation(epoch)).build());
        }

        public Builder name(StringFilter var1);

        default public Builder name(Consumer<StringFilter.Builder> name) {
            return this.name((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(name)).build());
        }

        public Builder release(StringFilter var1);

        default public Builder release(Consumer<StringFilter.Builder> release) {
            return this.release((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(release)).build());
        }

        public Builder sourceLayerHash(StringFilter var1);

        default public Builder sourceLayerHash(Consumer<StringFilter.Builder> sourceLayerHash) {
            return this.sourceLayerHash((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(sourceLayerHash)).build());
        }

        public Builder version(StringFilter var1);

        default public Builder version(Consumer<StringFilter.Builder> version) {
            return this.version((StringFilter)((StringFilter.Builder)StringFilter.builder().applyMutation(version)).build());
        }
    }
}

