/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationResponse extends Inspector2Response implements
        ToCopyableBuilder<GetConfigurationResponse.Builder, GetConfigurationResponse> {
    private static final SdkField<EcrConfigurationState> ECR_CONFIGURATION_FIELD = SdkField
            .<EcrConfigurationState> builder(MarshallingType.SDK_POJO).memberName("ecrConfiguration")
            .getter(getter(GetConfigurationResponse::ecrConfiguration)).setter(setter(Builder::ecrConfiguration))
            .constructor(EcrConfigurationState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_CONFIGURATION_FIELD));

    private final EcrConfigurationState ecrConfiguration;

    private GetConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.ecrConfiguration = builder.ecrConfiguration;
    }

    /**
     * <p>
     * Specifies how the ECR automated re-scan duration is currently configured for your environment.
     * </p>
     * 
     * @return Specifies how the ECR automated re-scan duration is currently configured for your environment.
     */
    public final EcrConfigurationState ecrConfiguration() {
        return ecrConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationResponse)) {
            return false;
        }
        GetConfigurationResponse other = (GetConfigurationResponse) obj;
        return Objects.equals(ecrConfiguration(), other.ecrConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationResponse").add("EcrConfiguration", ecrConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrConfiguration":
            return Optional.ofNullable(clazz.cast(ecrConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationResponse, T> g) {
        return obj -> g.apply((GetConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetConfigurationResponse> {
        /**
         * <p>
         * Specifies how the ECR automated re-scan duration is currently configured for your environment.
         * </p>
         * 
         * @param ecrConfiguration
         *        Specifies how the ECR automated re-scan duration is currently configured for your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrConfiguration(EcrConfigurationState ecrConfiguration);

        /**
         * <p>
         * Specifies how the ECR automated re-scan duration is currently configured for your environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrConfigurationState.Builder} avoiding
         * the need to create one manually via {@link EcrConfigurationState#builder()}.
         *
         * When the {@link Consumer} completes, {@link EcrConfigurationState.Builder#build()} is called immediately and
         * its result is passed to {@link #ecrConfiguration(EcrConfigurationState)}.
         * 
         * @param ecrConfiguration
         *        a consumer that will call methods on {@link EcrConfigurationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrConfiguration(EcrConfigurationState)
         */
        default Builder ecrConfiguration(Consumer<EcrConfigurationState.Builder> ecrConfiguration) {
            return ecrConfiguration(EcrConfigurationState.builder().applyMutation(ecrConfiguration).build());
        }
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private EcrConfigurationState ecrConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationResponse model) {
            super(model);
            ecrConfiguration(model.ecrConfiguration);
        }

        public final EcrConfigurationState.Builder getEcrConfiguration() {
            return ecrConfiguration != null ? ecrConfiguration.toBuilder() : null;
        }

        public final void setEcrConfiguration(EcrConfigurationState.BuilderImpl ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration != null ? ecrConfiguration.build() : null;
        }

        @Override
        public final Builder ecrConfiguration(EcrConfigurationState ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration;
            return this;
        }

        @Override
        public GetConfigurationResponse build() {
            return new GetConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
