/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the metadata for an Amazon ECR resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceScanMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceScanMetadata.Builder, ResourceScanMetadata> {
    private static final SdkField<Ec2Metadata> EC2_FIELD = SdkField.<Ec2Metadata> builder(MarshallingType.SDK_POJO)
            .memberName("ec2").getter(getter(ResourceScanMetadata::ec2)).setter(setter(Builder::ec2))
            .constructor(Ec2Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2").build()).build();

    private static final SdkField<EcrContainerImageMetadata> ECR_IMAGE_FIELD = SdkField
            .<EcrContainerImageMetadata> builder(MarshallingType.SDK_POJO).memberName("ecrImage")
            .getter(getter(ResourceScanMetadata::ecrImage)).setter(setter(Builder::ecrImage))
            .constructor(EcrContainerImageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImage").build()).build();

    private static final SdkField<EcrRepositoryMetadata> ECR_REPOSITORY_FIELD = SdkField
            .<EcrRepositoryMetadata> builder(MarshallingType.SDK_POJO).memberName("ecrRepository")
            .getter(getter(ResourceScanMetadata::ecrRepository)).setter(setter(Builder::ecrRepository))
            .constructor(EcrRepositoryMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepository").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_FIELD, ECR_IMAGE_FIELD,
            ECR_REPOSITORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Ec2Metadata ec2;

    private final EcrContainerImageMetadata ecrImage;

    private final EcrRepositoryMetadata ecrRepository;

    private ResourceScanMetadata(BuilderImpl builder) {
        this.ec2 = builder.ec2;
        this.ecrImage = builder.ecrImage;
        this.ecrRepository = builder.ecrRepository;
    }

    /**
     * <p>
     * An object that contains metadata details for an Amazon EC2 instance.
     * </p>
     * 
     * @return An object that contains metadata details for an Amazon EC2 instance.
     */
    public final Ec2Metadata ec2() {
        return ec2;
    }

    /**
     * <p>
     * An object that contains details about the container metadata for an Amazon ECR image.
     * </p>
     * 
     * @return An object that contains details about the container metadata for an Amazon ECR image.
     */
    public final EcrContainerImageMetadata ecrImage() {
        return ecrImage;
    }

    /**
     * <p>
     * An object that contains details about the repository an Amazon ECR image resides in.
     * </p>
     * 
     * @return An object that contains details about the repository an Amazon ECR image resides in.
     */
    public final EcrRepositoryMetadata ecrRepository() {
        return ecrRepository;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2());
        hashCode = 31 * hashCode + Objects.hashCode(ecrImage());
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepository());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceScanMetadata)) {
            return false;
        }
        ResourceScanMetadata other = (ResourceScanMetadata) obj;
        return Objects.equals(ec2(), other.ec2()) && Objects.equals(ecrImage(), other.ecrImage())
                && Objects.equals(ecrRepository(), other.ecrRepository());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceScanMetadata").add("Ec2", ec2()).add("EcrImage", ecrImage())
                .add("EcrRepository", ecrRepository()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2":
            return Optional.ofNullable(clazz.cast(ec2()));
        case "ecrImage":
            return Optional.ofNullable(clazz.cast(ecrImage()));
        case "ecrRepository":
            return Optional.ofNullable(clazz.cast(ecrRepository()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceScanMetadata, T> g) {
        return obj -> g.apply((ResourceScanMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceScanMetadata> {
        /**
         * <p>
         * An object that contains metadata details for an Amazon EC2 instance.
         * </p>
         * 
         * @param ec2
         *        An object that contains metadata details for an Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2(Ec2Metadata ec2);

        /**
         * <p>
         * An object that contains metadata details for an Amazon EC2 instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2Metadata.Builder} avoiding the need to
         * create one manually via {@link Ec2Metadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ec2Metadata.Builder#build()} is called immediately and its result
         * is passed to {@link #ec2(Ec2Metadata)}.
         * 
         * @param ec2
         *        a consumer that will call methods on {@link Ec2Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2(Ec2Metadata)
         */
        default Builder ec2(Consumer<Ec2Metadata.Builder> ec2) {
            return ec2(Ec2Metadata.builder().applyMutation(ec2).build());
        }

        /**
         * <p>
         * An object that contains details about the container metadata for an Amazon ECR image.
         * </p>
         * 
         * @param ecrImage
         *        An object that contains details about the container metadata for an Amazon ECR image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImage(EcrContainerImageMetadata ecrImage);

        /**
         * <p>
         * An object that contains details about the container metadata for an Amazon ECR image.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrContainerImageMetadata.Builder}
         * avoiding the need to create one manually via {@link EcrContainerImageMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link EcrContainerImageMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #ecrImage(EcrContainerImageMetadata)}.
         * 
         * @param ecrImage
         *        a consumer that will call methods on {@link EcrContainerImageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImage(EcrContainerImageMetadata)
         */
        default Builder ecrImage(Consumer<EcrContainerImageMetadata.Builder> ecrImage) {
            return ecrImage(EcrContainerImageMetadata.builder().applyMutation(ecrImage).build());
        }

        /**
         * <p>
         * An object that contains details about the repository an Amazon ECR image resides in.
         * </p>
         * 
         * @param ecrRepository
         *        An object that contains details about the repository an Amazon ECR image resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepository(EcrRepositoryMetadata ecrRepository);

        /**
         * <p>
         * An object that contains details about the repository an Amazon ECR image resides in.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrRepositoryMetadata.Builder} avoiding
         * the need to create one manually via {@link EcrRepositoryMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link EcrRepositoryMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #ecrRepository(EcrRepositoryMetadata)}.
         * 
         * @param ecrRepository
         *        a consumer that will call methods on {@link EcrRepositoryMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrRepository(EcrRepositoryMetadata)
         */
        default Builder ecrRepository(Consumer<EcrRepositoryMetadata.Builder> ecrRepository) {
            return ecrRepository(EcrRepositoryMetadata.builder().applyMutation(ecrRepository).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Ec2Metadata ec2;

        private EcrContainerImageMetadata ecrImage;

        private EcrRepositoryMetadata ecrRepository;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceScanMetadata model) {
            ec2(model.ec2);
            ecrImage(model.ecrImage);
            ecrRepository(model.ecrRepository);
        }

        public final Ec2Metadata.Builder getEc2() {
            return ec2 != null ? ec2.toBuilder() : null;
        }

        public final void setEc2(Ec2Metadata.BuilderImpl ec2) {
            this.ec2 = ec2 != null ? ec2.build() : null;
        }

        @Override
        public final Builder ec2(Ec2Metadata ec2) {
            this.ec2 = ec2;
            return this;
        }

        public final EcrContainerImageMetadata.Builder getEcrImage() {
            return ecrImage != null ? ecrImage.toBuilder() : null;
        }

        public final void setEcrImage(EcrContainerImageMetadata.BuilderImpl ecrImage) {
            this.ecrImage = ecrImage != null ? ecrImage.build() : null;
        }

        @Override
        public final Builder ecrImage(EcrContainerImageMetadata ecrImage) {
            this.ecrImage = ecrImage;
            return this;
        }

        public final EcrRepositoryMetadata.Builder getEcrRepository() {
            return ecrRepository != null ? ecrRepository.toBuilder() : null;
        }

        public final void setEcrRepository(EcrRepositoryMetadata.BuilderImpl ecrRepository) {
            this.ecrRepository = ecrRepository != null ? ecrRepository.build() : null;
        }

        @Override
        public final Builder ecrRepository(EcrRepositoryMetadata ecrRepository) {
            this.ecrRepository = ecrRepository;
            return this;
        }

        @Override
        public ResourceScanMetadata build() {
            return new ResourceScanMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
