/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationRequest extends Inspector2Request implements
        ToCopyableBuilder<UpdateConfigurationRequest.Builder, UpdateConfigurationRequest> {
    private static final SdkField<EcrConfiguration> ECR_CONFIGURATION_FIELD = SdkField
            .<EcrConfiguration> builder(MarshallingType.SDK_POJO).memberName("ecrConfiguration")
            .getter(getter(UpdateConfigurationRequest::ecrConfiguration)).setter(setter(Builder::ecrConfiguration))
            .constructor(EcrConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_CONFIGURATION_FIELD));

    private final EcrConfiguration ecrConfiguration;

    private UpdateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.ecrConfiguration = builder.ecrConfiguration;
    }

    /**
     * <p>
     * Specifies how the ECR automated re-scan will be updated for your environment.
     * </p>
     * 
     * @return Specifies how the ECR automated re-scan will be updated for your environment.
     */
    public final EcrConfiguration ecrConfiguration() {
        return ecrConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationRequest)) {
            return false;
        }
        UpdateConfigurationRequest other = (UpdateConfigurationRequest) obj;
        return Objects.equals(ecrConfiguration(), other.ecrConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConfigurationRequest").add("EcrConfiguration", ecrConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrConfiguration":
            return Optional.ofNullable(clazz.cast(ecrConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConfigurationRequest> {
        /**
         * <p>
         * Specifies how the ECR automated re-scan will be updated for your environment.
         * </p>
         * 
         * @param ecrConfiguration
         *        Specifies how the ECR automated re-scan will be updated for your environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrConfiguration(EcrConfiguration ecrConfiguration);

        /**
         * <p>
         * Specifies how the ECR automated re-scan will be updated for your environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcrConfiguration.Builder} avoiding the
         * need to create one manually via {@link EcrConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EcrConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #ecrConfiguration(EcrConfiguration)}.
         * 
         * @param ecrConfiguration
         *        a consumer that will call methods on {@link EcrConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrConfiguration(EcrConfiguration)
         */
        default Builder ecrConfiguration(Consumer<EcrConfiguration.Builder> ecrConfiguration) {
            return ecrConfiguration(EcrConfiguration.builder().applyMutation(ecrConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private EcrConfiguration ecrConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationRequest model) {
            super(model);
            ecrConfiguration(model.ecrConfiguration);
        }

        public final EcrConfiguration.Builder getEcrConfiguration() {
            return ecrConfiguration != null ? ecrConfiguration.toBuilder() : null;
        }

        public final void setEcrConfiguration(EcrConfiguration.BuilderImpl ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration != null ? ecrConfiguration.build() : null;
        }

        @Override
        public final Builder ecrConfiguration(EcrConfiguration ecrConfiguration) {
            this.ecrConfiguration = ecrConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationRequest build() {
            return new UpdateConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
