/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on the details of a package filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageFilter implements SdkPojo, Serializable, ToCopyableBuilder<PackageFilter.Builder, PackageFilter> {
    private static final SdkField<StringFilter> ARCHITECTURE_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("architecture").getter(getter(PackageFilter::architecture)).setter(setter(Builder::architecture))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<NumberFilter> EPOCH_FIELD = SdkField.<NumberFilter> builder(MarshallingType.SDK_POJO)
            .memberName("epoch").getter(getter(PackageFilter::epoch)).setter(setter(Builder::epoch))
            .constructor(NumberFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epoch").build()).build();

    private static final SdkField<StringFilter> NAME_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("name").getter(getter(PackageFilter::name)).setter(setter(Builder::name))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<StringFilter> RELEASE_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("release").getter(getter(PackageFilter::release)).setter(setter(Builder::release))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("release").build()).build();

    private static final SdkField<StringFilter> SOURCE_LAYER_HASH_FIELD = SdkField
            .<StringFilter> builder(MarshallingType.SDK_POJO).memberName("sourceLayerHash")
            .getter(getter(PackageFilter::sourceLayerHash)).setter(setter(Builder::sourceLayerHash))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLayerHash").build()).build();

    private static final SdkField<StringFilter> VERSION_FIELD = SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
            .memberName("version").getter(getter(PackageFilter::version)).setter(setter(Builder::version))
            .constructor(StringFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_FIELD,
            EPOCH_FIELD, NAME_FIELD, RELEASE_FIELD, SOURCE_LAYER_HASH_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final StringFilter architecture;

    private final NumberFilter epoch;

    private final StringFilter name;

    private final StringFilter release;

    private final StringFilter sourceLayerHash;

    private final StringFilter version;

    private PackageFilter(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.epoch = builder.epoch;
        this.name = builder.name;
        this.release = builder.release;
        this.sourceLayerHash = builder.sourceLayerHash;
        this.version = builder.version;
    }

    /**
     * <p>
     * An object that contains details on the package architecture type to filter on.
     * </p>
     * 
     * @return An object that contains details on the package architecture type to filter on.
     */
    public final StringFilter architecture() {
        return architecture;
    }

    /**
     * <p>
     * An object that contains details on the package epoch to filter on.
     * </p>
     * 
     * @return An object that contains details on the package epoch to filter on.
     */
    public final NumberFilter epoch() {
        return epoch;
    }

    /**
     * <p>
     * An object that contains details on the name of the package to filter on.
     * </p>
     * 
     * @return An object that contains details on the name of the package to filter on.
     */
    public final StringFilter name() {
        return name;
    }

    /**
     * <p>
     * An object that contains details on the package release to filter on.
     * </p>
     * 
     * @return An object that contains details on the package release to filter on.
     */
    public final StringFilter release() {
        return release;
    }

    /**
     * <p>
     * An object that contains details on the source layer hash to filter on.
     * </p>
     * 
     * @return An object that contains details on the source layer hash to filter on.
     */
    public final StringFilter sourceLayerHash() {
        return sourceLayerHash;
    }

    /**
     * <p>
     * The package version to filter on.
     * </p>
     * 
     * @return The package version to filter on.
     */
    public final StringFilter version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(epoch());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(release());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLayerHash());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageFilter)) {
            return false;
        }
        PackageFilter other = (PackageFilter) obj;
        return Objects.equals(architecture(), other.architecture()) && Objects.equals(epoch(), other.epoch())
                && Objects.equals(name(), other.name()) && Objects.equals(release(), other.release())
                && Objects.equals(sourceLayerHash(), other.sourceLayerHash()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageFilter").add("Architecture", architecture()).add("Epoch", epoch()).add("Name", name())
                .add("Release", release()).add("SourceLayerHash", sourceLayerHash()).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "epoch":
            return Optional.ofNullable(clazz.cast(epoch()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "release":
            return Optional.ofNullable(clazz.cast(release()));
        case "sourceLayerHash":
            return Optional.ofNullable(clazz.cast(sourceLayerHash()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageFilter, T> g) {
        return obj -> g.apply((PackageFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageFilter> {
        /**
         * <p>
         * An object that contains details on the package architecture type to filter on.
         * </p>
         * 
         * @param architecture
         *        An object that contains details on the package architecture type to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(StringFilter architecture);

        /**
         * <p>
         * An object that contains details on the package architecture type to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #architecture(StringFilter)}.
         * 
         * @param architecture
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #architecture(StringFilter)
         */
        default Builder architecture(Consumer<StringFilter.Builder> architecture) {
            return architecture(StringFilter.builder().applyMutation(architecture).build());
        }

        /**
         * <p>
         * An object that contains details on the package epoch to filter on.
         * </p>
         * 
         * @param epoch
         *        An object that contains details on the package epoch to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epoch(NumberFilter epoch);

        /**
         * <p>
         * An object that contains details on the package epoch to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumberFilter.Builder} avoiding the need
         * to create one manually via {@link NumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #epoch(NumberFilter)}.
         * 
         * @param epoch
         *        a consumer that will call methods on {@link NumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #epoch(NumberFilter)
         */
        default Builder epoch(Consumer<NumberFilter.Builder> epoch) {
            return epoch(NumberFilter.builder().applyMutation(epoch).build());
        }

        /**
         * <p>
         * An object that contains details on the name of the package to filter on.
         * </p>
         * 
         * @param name
         *        An object that contains details on the name of the package to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(StringFilter name);

        /**
         * <p>
         * An object that contains details on the name of the package to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #name(StringFilter)}.
         * 
         * @param name
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #name(StringFilter)
         */
        default Builder name(Consumer<StringFilter.Builder> name) {
            return name(StringFilter.builder().applyMutation(name).build());
        }

        /**
         * <p>
         * An object that contains details on the package release to filter on.
         * </p>
         * 
         * @param release
         *        An object that contains details on the package release to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder release(StringFilter release);

        /**
         * <p>
         * An object that contains details on the package release to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #release(StringFilter)}.
         * 
         * @param release
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #release(StringFilter)
         */
        default Builder release(Consumer<StringFilter.Builder> release) {
            return release(StringFilter.builder().applyMutation(release).build());
        }

        /**
         * <p>
         * An object that contains details on the source layer hash to filter on.
         * </p>
         * 
         * @param sourceLayerHash
         *        An object that contains details on the source layer hash to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLayerHash(StringFilter sourceLayerHash);

        /**
         * <p>
         * An object that contains details on the source layer hash to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceLayerHash(StringFilter)}.
         * 
         * @param sourceLayerHash
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceLayerHash(StringFilter)
         */
        default Builder sourceLayerHash(Consumer<StringFilter.Builder> sourceLayerHash) {
            return sourceLayerHash(StringFilter.builder().applyMutation(sourceLayerHash).build());
        }

        /**
         * <p>
         * The package version to filter on.
         * </p>
         * 
         * @param version
         *        The package version to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(StringFilter version);

        /**
         * <p>
         * The package version to filter on.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringFilter.Builder} avoiding the need
         * to create one manually via {@link StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #version(StringFilter)}.
         * 
         * @param version
         *        a consumer that will call methods on {@link StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #version(StringFilter)
         */
        default Builder version(Consumer<StringFilter.Builder> version) {
            return version(StringFilter.builder().applyMutation(version).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringFilter architecture;

        private NumberFilter epoch;

        private StringFilter name;

        private StringFilter release;

        private StringFilter sourceLayerHash;

        private StringFilter version;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageFilter model) {
            architecture(model.architecture);
            epoch(model.epoch);
            name(model.name);
            release(model.release);
            sourceLayerHash(model.sourceLayerHash);
            version(model.version);
        }

        public final StringFilter.Builder getArchitecture() {
            return architecture != null ? architecture.toBuilder() : null;
        }

        public final void setArchitecture(StringFilter.BuilderImpl architecture) {
            this.architecture = architecture != null ? architecture.build() : null;
        }

        @Override
        public final Builder architecture(StringFilter architecture) {
            this.architecture = architecture;
            return this;
        }

        public final NumberFilter.Builder getEpoch() {
            return epoch != null ? epoch.toBuilder() : null;
        }

        public final void setEpoch(NumberFilter.BuilderImpl epoch) {
            this.epoch = epoch != null ? epoch.build() : null;
        }

        @Override
        public final Builder epoch(NumberFilter epoch) {
            this.epoch = epoch;
            return this;
        }

        public final StringFilter.Builder getName() {
            return name != null ? name.toBuilder() : null;
        }

        public final void setName(StringFilter.BuilderImpl name) {
            this.name = name != null ? name.build() : null;
        }

        @Override
        public final Builder name(StringFilter name) {
            this.name = name;
            return this;
        }

        public final StringFilter.Builder getRelease() {
            return release != null ? release.toBuilder() : null;
        }

        public final void setRelease(StringFilter.BuilderImpl release) {
            this.release = release != null ? release.build() : null;
        }

        @Override
        public final Builder release(StringFilter release) {
            this.release = release;
            return this;
        }

        public final StringFilter.Builder getSourceLayerHash() {
            return sourceLayerHash != null ? sourceLayerHash.toBuilder() : null;
        }

        public final void setSourceLayerHash(StringFilter.BuilderImpl sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash != null ? sourceLayerHash.build() : null;
        }

        @Override
        public final Builder sourceLayerHash(StringFilter sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
            return this;
        }

        public final StringFilter.Builder getVersion() {
            return version != null ? version.toBuilder() : null;
        }

        public final void setVersion(StringFilter.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public final Builder version(StringFilter version) {
            this.version = version;
            return this;
        }

        @Override
        public PackageFilter build() {
            return new PackageFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
