/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the Amazon EC2 instance involved in a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2InstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2InstanceDetails.Builder, AwsEc2InstanceDetails> {
    private static final SdkField<String> IAM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamInstanceProfileArn").getter(getter(AwsEc2InstanceDetails::iamInstanceProfileArn))
            .setter(setter(Builder::iamInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfileArn").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageId").getter(getter(AwsEc2InstanceDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<List<String>> IP_V4_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipV4Addresses")
            .getter(getter(AwsEc2InstanceDetails::ipV4Addresses))
            .setter(setter(Builder::ipV4Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV4Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IP_V6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ipV6Addresses")
            .getter(getter(AwsEc2InstanceDetails::ipV6Addresses))
            .setter(setter(Builder::ipV6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipV6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyName").getter(getter(AwsEc2InstanceDetails::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()).build();

    private static final SdkField<Instant> LAUNCHED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("launchedAt").getter(getter(AwsEc2InstanceDetails::launchedAt)).setter(setter(Builder::launchedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedAt").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(AwsEc2InstanceDetails::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subnetId").getter(getter(AwsEc2InstanceDetails::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AwsEc2InstanceDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(AwsEc2InstanceDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IAM_INSTANCE_PROFILE_ARN_FIELD, IMAGE_ID_FIELD, IP_V4_ADDRESSES_FIELD, IP_V6_ADDRESSES_FIELD, KEY_NAME_FIELD,
            LAUNCHED_AT_FIELD, PLATFORM_FIELD, SUBNET_ID_FIELD, TYPE_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iamInstanceProfileArn;

    private final String imageId;

    private final List<String> ipV4Addresses;

    private final List<String> ipV6Addresses;

    private final String keyName;

    private final Instant launchedAt;

    private final String platform;

    private final String subnetId;

    private final String type;

    private final String vpcId;

    private AwsEc2InstanceDetails(BuilderImpl builder) {
        this.iamInstanceProfileArn = builder.iamInstanceProfileArn;
        this.imageId = builder.imageId;
        this.ipV4Addresses = builder.ipV4Addresses;
        this.ipV6Addresses = builder.ipV6Addresses;
        this.keyName = builder.keyName;
        this.launchedAt = builder.launchedAt;
        this.platform = builder.platform;
        this.subnetId = builder.subnetId;
        this.type = builder.type;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The IAM instance profile ARN of the Amazon EC2 instance.
     * </p>
     * 
     * @return The IAM instance profile ARN of the Amazon EC2 instance.
     */
    public final String iamInstanceProfileArn() {
        return iamInstanceProfileArn;
    }

    /**
     * <p>
     * The image ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The image ID of the Amazon EC2 instance.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpV4Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpV4Addresses() {
        return ipV4Addresses != null && !(ipV4Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 addresses of the Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpV4Addresses} method.
     * </p>
     * 
     * @return The IPv4 addresses of the Amazon EC2 instance.
     */
    public final List<String> ipV4Addresses() {
        return ipV4Addresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpV6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpV6Addresses() {
        return ipV6Addresses != null && !(ipV6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 addresses of the Amazon EC2 instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpV6Addresses} method.
     * </p>
     * 
     * @return The IPv6 addresses of the Amazon EC2 instance.
     */
    public final List<String> ipV6Addresses() {
        return ipV6Addresses;
    }

    /**
     * <p>
     * The name of the key pair used to launch the Amazon EC2 instance.
     * </p>
     * 
     * @return The name of the key pair used to launch the Amazon EC2 instance.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The date and time the Amazon EC2 instance was launched at.
     * </p>
     * 
     * @return The date and time the Amazon EC2 instance was launched at.
     */
    public final Instant launchedAt() {
        return launchedAt;
    }

    /**
     * <p>
     * The platform of the Amazon EC2 instance.
     * </p>
     * 
     * @return The platform of the Amazon EC2 instance.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The subnet ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The subnet ID of the Amazon EC2 instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The type of the Amazon EC2 instance.
     * </p>
     * 
     * @return The type of the Amazon EC2 instance.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The VPC ID of the Amazon EC2 instance.
     * </p>
     * 
     * @return The VPC ID of the Amazon EC2 instance.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpV4Addresses() ? ipV4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpV6Addresses() ? ipV6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(launchedAt());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2InstanceDetails)) {
            return false;
        }
        AwsEc2InstanceDetails other = (AwsEc2InstanceDetails) obj;
        return Objects.equals(iamInstanceProfileArn(), other.iamInstanceProfileArn())
                && Objects.equals(imageId(), other.imageId()) && hasIpV4Addresses() == other.hasIpV4Addresses()
                && Objects.equals(ipV4Addresses(), other.ipV4Addresses()) && hasIpV6Addresses() == other.hasIpV6Addresses()
                && Objects.equals(ipV6Addresses(), other.ipV6Addresses()) && Objects.equals(keyName(), other.keyName())
                && Objects.equals(launchedAt(), other.launchedAt()) && Objects.equals(platform(), other.platform())
                && Objects.equals(subnetId(), other.subnetId()) && Objects.equals(type(), other.type())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2InstanceDetails").add("IamInstanceProfileArn", iamInstanceProfileArn())
                .add("ImageId", imageId()).add("IpV4Addresses", hasIpV4Addresses() ? ipV4Addresses() : null)
                .add("IpV6Addresses", hasIpV6Addresses() ? ipV6Addresses() : null).add("KeyName", keyName())
                .add("LaunchedAt", launchedAt()).add("Platform", platform()).add("SubnetId", subnetId()).add("Type", type())
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iamInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(iamInstanceProfileArn()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ipV4Addresses":
            return Optional.ofNullable(clazz.cast(ipV4Addresses()));
        case "ipV6Addresses":
            return Optional.ofNullable(clazz.cast(ipV6Addresses()));
        case "keyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "launchedAt":
            return Optional.ofNullable(clazz.cast(launchedAt()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2InstanceDetails, T> g) {
        return obj -> g.apply((AwsEc2InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2InstanceDetails> {
        /**
         * <p>
         * The IAM instance profile ARN of the Amazon EC2 instance.
         * </p>
         * 
         * @param iamInstanceProfileArn
         *        The IAM instance profile ARN of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileArn(String iamInstanceProfileArn);

        /**
         * <p>
         * The image ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param imageId
         *        The image ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The IPv4 addresses of the Amazon EC2 instance.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IPv4 addresses of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(Collection<String> ipV4Addresses);

        /**
         * <p>
         * The IPv4 addresses of the Amazon EC2 instance.
         * </p>
         * 
         * @param ipV4Addresses
         *        The IPv4 addresses of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV4Addresses(String... ipV4Addresses);

        /**
         * <p>
         * The IPv6 addresses of the Amazon EC2 instance.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IPv6 addresses of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(Collection<String> ipV6Addresses);

        /**
         * <p>
         * The IPv6 addresses of the Amazon EC2 instance.
         * </p>
         * 
         * @param ipV6Addresses
         *        The IPv6 addresses of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipV6Addresses(String... ipV6Addresses);

        /**
         * <p>
         * The name of the key pair used to launch the Amazon EC2 instance.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair used to launch the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The date and time the Amazon EC2 instance was launched at.
         * </p>
         * 
         * @param launchedAt
         *        The date and time the Amazon EC2 instance was launched at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedAt(Instant launchedAt);

        /**
         * <p>
         * The platform of the Amazon EC2 instance.
         * </p>
         * 
         * @param platform
         *        The platform of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The subnet ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param subnetId
         *        The subnet ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The type of the Amazon EC2 instance.
         * </p>
         * 
         * @param type
         *        The type of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The VPC ID of the Amazon EC2 instance.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID of the Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String iamInstanceProfileArn;

        private String imageId;

        private List<String> ipV4Addresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> ipV6Addresses = DefaultSdkAutoConstructList.getInstance();

        private String keyName;

        private Instant launchedAt;

        private String platform;

        private String subnetId;

        private String type;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2InstanceDetails model) {
            iamInstanceProfileArn(model.iamInstanceProfileArn);
            imageId(model.imageId);
            ipV4Addresses(model.ipV4Addresses);
            ipV6Addresses(model.ipV6Addresses);
            keyName(model.keyName);
            launchedAt(model.launchedAt);
            platform(model.platform);
            subnetId(model.subnetId);
            type(model.type);
            vpcId(model.vpcId);
        }

        public final String getIamInstanceProfileArn() {
            return iamInstanceProfileArn;
        }

        public final void setIamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
        }

        @Override
        public final Builder iamInstanceProfileArn(String iamInstanceProfileArn) {
            this.iamInstanceProfileArn = iamInstanceProfileArn;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final Collection<String> getIpV4Addresses() {
            if (ipV4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipV4Addresses;
        }

        public final void setIpV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressListCopier.copy(ipV4Addresses);
        }

        @Override
        public final Builder ipV4Addresses(Collection<String> ipV4Addresses) {
            this.ipV4Addresses = IpV4AddressListCopier.copy(ipV4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV4Addresses(String... ipV4Addresses) {
            ipV4Addresses(Arrays.asList(ipV4Addresses));
            return this;
        }

        public final Collection<String> getIpV6Addresses() {
            if (ipV6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return ipV6Addresses;
        }

        public final void setIpV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressListCopier.copy(ipV6Addresses);
        }

        @Override
        public final Builder ipV6Addresses(Collection<String> ipV6Addresses) {
            this.ipV6Addresses = IpV6AddressListCopier.copy(ipV6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipV6Addresses(String... ipV6Addresses) {
            ipV6Addresses(Arrays.asList(ipV6Addresses));
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final Instant getLaunchedAt() {
            return launchedAt;
        }

        public final void setLaunchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(Instant launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public AwsEc2InstanceDetails build() {
            return new AwsEc2InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
