/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector2.Inspector2AsyncClient;
import software.amazon.awssdk.services.inspector2.model.DelegatedAdminAccount;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;

public class ListDelegatedAdminAccountsPublisher
implements SdkPublisher<ListDelegatedAdminAccountsResponse> {
    private final Inspector2AsyncClient client;
    private final ListDelegatedAdminAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDelegatedAdminAccountsPublisher(Inspector2AsyncClient client, ListDelegatedAdminAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDelegatedAdminAccountsPublisher(Inspector2AsyncClient client, ListDelegatedAdminAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDelegatedAdminAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDelegatedAdminAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DelegatedAdminAccount> delegatedAdminAccounts() {
        Function<ListDelegatedAdminAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.delegatedAdminAccounts() != null) {
                return response.delegatedAdminAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDelegatedAdminAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDelegatedAdminAccountsResponseFetcher
    implements AsyncPageFetcher<ListDelegatedAdminAccountsResponse> {
        private ListDelegatedAdminAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListDelegatedAdminAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDelegatedAdminAccountsResponse> nextPage(ListDelegatedAdminAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListDelegatedAdminAccountsPublisher.this.client.listDelegatedAdminAccounts(ListDelegatedAdminAccountsPublisher.this.firstRequest);
            }
            return ListDelegatedAdminAccountsPublisher.this.client.listDelegatedAdminAccounts((ListDelegatedAdminAccountsRequest)((Object)ListDelegatedAdminAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

