/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about a resource covered by Amazon Inspector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoveredResource implements SdkPojo, Serializable, ToCopyableBuilder<CoveredResource.Builder, CoveredResource> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CoveredResource::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(CoveredResource::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<ResourceScanMetadata> RESOURCE_METADATA_FIELD = SdkField
            .<ResourceScanMetadata> builder(MarshallingType.SDK_POJO).memberName("resourceMetadata")
            .getter(getter(CoveredResource::resourceMetadata)).setter(setter(Builder::resourceMetadata))
            .constructor(ResourceScanMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceMetadata").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(CoveredResource::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<ScanStatus> SCAN_STATUS_FIELD = SdkField.<ScanStatus> builder(MarshallingType.SDK_POJO)
            .memberName("scanStatus").getter(getter(CoveredResource::scanStatus)).setter(setter(Builder::scanStatus))
            .constructor(ScanStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatus").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanType").getter(getter(CoveredResource::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_METADATA_FIELD, RESOURCE_TYPE_FIELD, SCAN_STATUS_FIELD, SCAN_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String resourceId;

    private final ResourceScanMetadata resourceMetadata;

    private final String resourceType;

    private final ScanStatus scanStatus;

    private final String scanType;

    private CoveredResource(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.resourceId = builder.resourceId;
        this.resourceMetadata = builder.resourceMetadata;
        this.resourceType = builder.resourceType;
        this.scanStatus = builder.scanStatus;
        this.scanType = builder.scanType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the covered resource.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the covered resource.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The ID of the covered resource.
     * </p>
     * 
     * @return The ID of the covered resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * An object that contains details about the metadata.
     * </p>
     * 
     * @return An object that contains details about the metadata.
     */
    public final ResourceScanMetadata resourceMetadata() {
        return resourceMetadata;
    }

    /**
     * <p>
     * The type of the covered resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link CoverageResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the covered resource.
     * @see CoverageResourceType
     */
    public final CoverageResourceType resourceType() {
        return CoverageResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the covered resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link CoverageResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the covered resource.
     * @see CoverageResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The status of the scan covering the resource.
     * </p>
     * 
     * @return The status of the scan covering the resource.
     */
    public final ScanStatus scanStatus() {
        return scanStatus;
    }

    /**
     * <p>
     * The Amazon Inspector scan type covering the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The Amazon Inspector scan type covering the resource.
     * @see ScanType
     */
    public final ScanType scanType() {
        return ScanType.fromValue(scanType);
    }

    /**
     * <p>
     * The Amazon Inspector scan type covering the resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The Amazon Inspector scan type covering the resource.
     * @see ScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanStatus());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoveredResource)) {
            return false;
        }
        CoveredResource other = (CoveredResource) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceMetadata(), other.resourceMetadata())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(scanStatus(), other.scanStatus())
                && Objects.equals(scanTypeAsString(), other.scanTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoveredResource").add("AccountId", accountId()).add("ResourceId", resourceId())
                .add("ResourceMetadata", resourceMetadata()).add("ResourceType", resourceTypeAsString())
                .add("ScanStatus", scanStatus()).add("ScanType", scanTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceMetadata":
            return Optional.ofNullable(clazz.cast(resourceMetadata()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "scanStatus":
            return Optional.ofNullable(clazz.cast(scanStatus()));
        case "scanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoveredResource, T> g) {
        return obj -> g.apply((CoveredResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoveredResource> {
        /**
         * <p>
         * The Amazon Web Services account ID of the covered resource.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the covered resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The ID of the covered resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the covered resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * An object that contains details about the metadata.
         * </p>
         * 
         * @param resourceMetadata
         *        An object that contains details about the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceMetadata(ResourceScanMetadata resourceMetadata);

        /**
         * <p>
         * An object that contains details about the metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceScanMetadata.Builder} avoiding
         * the need to create one manually via {@link ResourceScanMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceScanMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceMetadata(ResourceScanMetadata)}.
         * 
         * @param resourceMetadata
         *        a consumer that will call methods on {@link ResourceScanMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceMetadata(ResourceScanMetadata)
         */
        default Builder resourceMetadata(Consumer<ResourceScanMetadata.Builder> resourceMetadata) {
            return resourceMetadata(ResourceScanMetadata.builder().applyMutation(resourceMetadata).build());
        }

        /**
         * <p>
         * The type of the covered resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the covered resource.
         * @see CoverageResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoverageResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the covered resource.
         * </p>
         * 
         * @param resourceType
         *        The type of the covered resource.
         * @see CoverageResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CoverageResourceType
         */
        Builder resourceType(CoverageResourceType resourceType);

        /**
         * <p>
         * The status of the scan covering the resource.
         * </p>
         * 
         * @param scanStatus
         *        The status of the scan covering the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatus(ScanStatus scanStatus);

        /**
         * <p>
         * The status of the scan covering the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScanStatus.Builder} avoiding the need to
         * create one manually via {@link ScanStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #scanStatus(ScanStatus)}.
         * 
         * @param scanStatus
         *        a consumer that will call methods on {@link ScanStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanStatus(ScanStatus)
         */
        default Builder scanStatus(Consumer<ScanStatus.Builder> scanStatus) {
            return scanStatus(ScanStatus.builder().applyMutation(scanStatus).build());
        }

        /**
         * <p>
         * The Amazon Inspector scan type covering the resource.
         * </p>
         * 
         * @param scanType
         *        The Amazon Inspector scan type covering the resource.
         * @see ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanType
         */
        Builder scanType(String scanType);

        /**
         * <p>
         * The Amazon Inspector scan type covering the resource.
         * </p>
         * 
         * @param scanType
         *        The Amazon Inspector scan type covering the resource.
         * @see ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanType
         */
        Builder scanType(ScanType scanType);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String resourceId;

        private ResourceScanMetadata resourceMetadata;

        private String resourceType;

        private ScanStatus scanStatus;

        private String scanType;

        private BuilderImpl() {
        }

        private BuilderImpl(CoveredResource model) {
            accountId(model.accountId);
            resourceId(model.resourceId);
            resourceMetadata(model.resourceMetadata);
            resourceType(model.resourceType);
            scanStatus(model.scanStatus);
            scanType(model.scanType);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final ResourceScanMetadata.Builder getResourceMetadata() {
            return resourceMetadata != null ? resourceMetadata.toBuilder() : null;
        }

        public final void setResourceMetadata(ResourceScanMetadata.BuilderImpl resourceMetadata) {
            this.resourceMetadata = resourceMetadata != null ? resourceMetadata.build() : null;
        }

        @Override
        public final Builder resourceMetadata(ResourceScanMetadata resourceMetadata) {
            this.resourceMetadata = resourceMetadata;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(CoverageResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final ScanStatus.Builder getScanStatus() {
            return scanStatus != null ? scanStatus.toBuilder() : null;
        }

        public final void setScanStatus(ScanStatus.BuilderImpl scanStatus) {
            this.scanStatus = scanStatus != null ? scanStatus.build() : null;
        }

        @Override
        public final Builder scanStatus(ScanStatus scanStatus) {
            this.scanStatus = scanStatus;
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        @Override
        public CoveredResource build() {
            return new CoveredResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
