/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a package vulnerability finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageVulnerabilityDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageVulnerabilityDetails.Builder, PackageVulnerabilityDetails> {
    private static final SdkField<List<CvssScore>> CVSS_FIELD = SdkField
            .<List<CvssScore>> builder(MarshallingType.LIST)
            .memberName("cvss")
            .getter(getter(PackageVulnerabilityDetails::cvss))
            .setter(setter(Builder::cvss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cvss").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CvssScore> builder(MarshallingType.SDK_POJO)
                                            .constructor(CvssScore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("referenceUrls")
            .getter(getter(PackageVulnerabilityDetails::referenceUrls))
            .setter(setter(Builder::referenceUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("relatedVulnerabilities")
            .getter(getter(PackageVulnerabilityDetails::relatedVulnerabilities))
            .setter(setter(Builder::relatedVulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedVulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(PackageVulnerabilityDetails::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceUrl").getter(getter(PackageVulnerabilityDetails::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrl").build()).build();

    private static final SdkField<Instant> VENDOR_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("vendorCreatedAt").getter(getter(PackageVulnerabilityDetails::vendorCreatedAt))
            .setter(setter(Builder::vendorCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorCreatedAt").build()).build();

    private static final SdkField<String> VENDOR_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vendorSeverity").getter(getter(PackageVulnerabilityDetails::vendorSeverity))
            .setter(setter(Builder::vendorSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorSeverity").build()).build();

    private static final SdkField<Instant> VENDOR_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("vendorUpdatedAt").getter(getter(PackageVulnerabilityDetails::vendorUpdatedAt))
            .setter(setter(Builder::vendorUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorUpdatedAt").build()).build();

    private static final SdkField<String> VULNERABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vulnerabilityId").getter(getter(PackageVulnerabilityDetails::vulnerabilityId))
            .setter(setter(Builder::vulnerabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityId").build()).build();

    private static final SdkField<List<VulnerablePackage>> VULNERABLE_PACKAGES_FIELD = SdkField
            .<List<VulnerablePackage>> builder(MarshallingType.LIST)
            .memberName("vulnerablePackages")
            .getter(getter(PackageVulnerabilityDetails::vulnerablePackages))
            .setter(setter(Builder::vulnerablePackages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerablePackages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VulnerablePackage> builder(MarshallingType.SDK_POJO)
                                            .constructor(VulnerablePackage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CVSS_FIELD,
            REFERENCE_URLS_FIELD, RELATED_VULNERABILITIES_FIELD, SOURCE_FIELD, SOURCE_URL_FIELD, VENDOR_CREATED_AT_FIELD,
            VENDOR_SEVERITY_FIELD, VENDOR_UPDATED_AT_FIELD, VULNERABILITY_ID_FIELD, VULNERABLE_PACKAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CvssScore> cvss;

    private final List<String> referenceUrls;

    private final List<String> relatedVulnerabilities;

    private final String source;

    private final String sourceUrl;

    private final Instant vendorCreatedAt;

    private final String vendorSeverity;

    private final Instant vendorUpdatedAt;

    private final String vulnerabilityId;

    private final List<VulnerablePackage> vulnerablePackages;

    private PackageVulnerabilityDetails(BuilderImpl builder) {
        this.cvss = builder.cvss;
        this.referenceUrls = builder.referenceUrls;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.source = builder.source;
        this.sourceUrl = builder.sourceUrl;
        this.vendorCreatedAt = builder.vendorCreatedAt;
        this.vendorSeverity = builder.vendorSeverity;
        this.vendorUpdatedAt = builder.vendorUpdatedAt;
        this.vulnerabilityId = builder.vulnerabilityId;
        this.vulnerablePackages = builder.vulnerablePackages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Cvss property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasCvss() {
        return cvss != null && !(cvss instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains details about the CVSS score of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCvss} method.
     * </p>
     * 
     * @return An object that contains details about the CVSS score of a finding.
     */
    public final List<CvssScore> cvss() {
        return cvss;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceUrls() {
        return referenceUrls != null && !(referenceUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more URLs that contain details about this vulnerability type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceUrls} method.
     * </p>
     * 
     * @return One or more URLs that contain details about this vulnerability type.
     */
    public final List<String> referenceUrls() {
        return referenceUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedVulnerabilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelatedVulnerabilities() {
        return relatedVulnerabilities != null && !(relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more vulnerabilities related to the one identified in this finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedVulnerabilities} method.
     * </p>
     * 
     * @return One or more vulnerabilities related to the one identified in this finding.
     */
    public final List<String> relatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * The source of the vulnerability information.
     * </p>
     * 
     * @return The source of the vulnerability information.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * A URL to the source of the vulnerability information.
     * </p>
     * 
     * @return A URL to the source of the vulnerability information.
     */
    public final String sourceUrl() {
        return sourceUrl;
    }

    /**
     * <p>
     * The date and time that this vulnerability was first added to the vendor's database.
     * </p>
     * 
     * @return The date and time that this vulnerability was first added to the vendor's database.
     */
    public final Instant vendorCreatedAt() {
        return vendorCreatedAt;
    }

    /**
     * <p>
     * The severity the vendor has given to this vulnerability type.
     * </p>
     * 
     * @return The severity the vendor has given to this vulnerability type.
     */
    public final String vendorSeverity() {
        return vendorSeverity;
    }

    /**
     * <p>
     * The date and time the vendor last updated this vulnerability in their database.
     * </p>
     * 
     * @return The date and time the vendor last updated this vulnerability in their database.
     */
    public final Instant vendorUpdatedAt() {
        return vendorUpdatedAt;
    }

    /**
     * <p>
     * The ID given to this vulnerability.
     * </p>
     * 
     * @return The ID given to this vulnerability.
     */
    public final String vulnerabilityId() {
        return vulnerabilityId;
    }

    /**
     * For responses, this returns true if the service returned a value for the VulnerablePackages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVulnerablePackages() {
        return vulnerablePackages != null && !(vulnerablePackages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The packages impacted by this vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVulnerablePackages} method.
     * </p>
     * 
     * @return The packages impacted by this vulnerability.
     */
    public final List<VulnerablePackage> vulnerablePackages() {
        return vulnerablePackages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCvss() ? cvss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceUrls() ? referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedVulnerabilities() ? relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(vendorCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vendorSeverity());
        hashCode = 31 * hashCode + Objects.hashCode(vendorUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerablePackages() ? vulnerablePackages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVulnerabilityDetails)) {
            return false;
        }
        PackageVulnerabilityDetails other = (PackageVulnerabilityDetails) obj;
        return hasCvss() == other.hasCvss() && Objects.equals(cvss(), other.cvss())
                && hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(referenceUrls(), other.referenceUrls())
                && hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities()
                && Objects.equals(relatedVulnerabilities(), other.relatedVulnerabilities())
                && Objects.equals(source(), other.source()) && Objects.equals(sourceUrl(), other.sourceUrl())
                && Objects.equals(vendorCreatedAt(), other.vendorCreatedAt())
                && Objects.equals(vendorSeverity(), other.vendorSeverity())
                && Objects.equals(vendorUpdatedAt(), other.vendorUpdatedAt())
                && Objects.equals(vulnerabilityId(), other.vulnerabilityId())
                && hasVulnerablePackages() == other.hasVulnerablePackages()
                && Objects.equals(vulnerablePackages(), other.vulnerablePackages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageVulnerabilityDetails").add("Cvss", hasCvss() ? cvss() : null)
                .add("ReferenceUrls", hasReferenceUrls() ? referenceUrls() : null)
                .add("RelatedVulnerabilities", hasRelatedVulnerabilities() ? relatedVulnerabilities() : null)
                .add("Source", source()).add("SourceUrl", sourceUrl()).add("VendorCreatedAt", vendorCreatedAt())
                .add("VendorSeverity", vendorSeverity()).add("VendorUpdatedAt", vendorUpdatedAt())
                .add("VulnerabilityId", vulnerabilityId())
                .add("VulnerablePackages", hasVulnerablePackages() ? vulnerablePackages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cvss":
            return Optional.ofNullable(clazz.cast(cvss()));
        case "referenceUrls":
            return Optional.ofNullable(clazz.cast(referenceUrls()));
        case "relatedVulnerabilities":
            return Optional.ofNullable(clazz.cast(relatedVulnerabilities()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "sourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        case "vendorCreatedAt":
            return Optional.ofNullable(clazz.cast(vendorCreatedAt()));
        case "vendorSeverity":
            return Optional.ofNullable(clazz.cast(vendorSeverity()));
        case "vendorUpdatedAt":
            return Optional.ofNullable(clazz.cast(vendorUpdatedAt()));
        case "vulnerabilityId":
            return Optional.ofNullable(clazz.cast(vulnerabilityId()));
        case "vulnerablePackages":
            return Optional.ofNullable(clazz.cast(vulnerablePackages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageVulnerabilityDetails, T> g) {
        return obj -> g.apply((PackageVulnerabilityDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageVulnerabilityDetails> {
        /**
         * <p>
         * An object that contains details about the CVSS score of a finding.
         * </p>
         * 
         * @param cvss
         *        An object that contains details about the CVSS score of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(Collection<CvssScore> cvss);

        /**
         * <p>
         * An object that contains details about the CVSS score of a finding.
         * </p>
         * 
         * @param cvss
         *        An object that contains details about the CVSS score of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(CvssScore... cvss);

        /**
         * <p>
         * An object that contains details about the CVSS score of a finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CvssScore.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.CvssScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CvssScore.Builder#build()} is called immediately and
         * its result is passed to {@link #cvss(List<CvssScore>)}.
         * 
         * @param cvss
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CvssScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cvss(java.util.Collection<CvssScore>)
         */
        Builder cvss(Consumer<CvssScore.Builder>... cvss);

        /**
         * <p>
         * One or more URLs that contain details about this vulnerability type.
         * </p>
         * 
         * @param referenceUrls
         *        One or more URLs that contain details about this vulnerability type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(Collection<String> referenceUrls);

        /**
         * <p>
         * One or more URLs that contain details about this vulnerability type.
         * </p>
         * 
         * @param referenceUrls
         *        One or more URLs that contain details about this vulnerability type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(String... referenceUrls);

        /**
         * <p>
         * One or more vulnerabilities related to the one identified in this finding.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        One or more vulnerabilities related to the one identified in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities);

        /**
         * <p>
         * One or more vulnerabilities related to the one identified in this finding.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        One or more vulnerabilities related to the one identified in this finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(String... relatedVulnerabilities);

        /**
         * <p>
         * The source of the vulnerability information.
         * </p>
         * 
         * @param source
         *        The source of the vulnerability information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * A URL to the source of the vulnerability information.
         * </p>
         * 
         * @param sourceUrl
         *        A URL to the source of the vulnerability information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        /**
         * <p>
         * The date and time that this vulnerability was first added to the vendor's database.
         * </p>
         * 
         * @param vendorCreatedAt
         *        The date and time that this vulnerability was first added to the vendor's database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorCreatedAt(Instant vendorCreatedAt);

        /**
         * <p>
         * The severity the vendor has given to this vulnerability type.
         * </p>
         * 
         * @param vendorSeverity
         *        The severity the vendor has given to this vulnerability type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorSeverity(String vendorSeverity);

        /**
         * <p>
         * The date and time the vendor last updated this vulnerability in their database.
         * </p>
         * 
         * @param vendorUpdatedAt
         *        The date and time the vendor last updated this vulnerability in their database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorUpdatedAt(Instant vendorUpdatedAt);

        /**
         * <p>
         * The ID given to this vulnerability.
         * </p>
         * 
         * @param vulnerabilityId
         *        The ID given to this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityId(String vulnerabilityId);

        /**
         * <p>
         * The packages impacted by this vulnerability.
         * </p>
         * 
         * @param vulnerablePackages
         *        The packages impacted by this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(Collection<VulnerablePackage> vulnerablePackages);

        /**
         * <p>
         * The packages impacted by this vulnerability.
         * </p>
         * 
         * @param vulnerablePackages
         *        The packages impacted by this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(VulnerablePackage... vulnerablePackages);

        /**
         * <p>
         * The packages impacted by this vulnerability.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.VulnerablePackage.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.VulnerablePackage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.VulnerablePackage.Builder#build()} is called
         * immediately and its result is passed to {@link #vulnerablePackages(List<VulnerablePackage>)}.
         * 
         * @param vulnerablePackages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.VulnerablePackage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerablePackages(java.util.Collection<VulnerablePackage>)
         */
        Builder vulnerablePackages(Consumer<VulnerablePackage.Builder>... vulnerablePackages);
    }

    static final class BuilderImpl implements Builder {
        private List<CvssScore> cvss = DefaultSdkAutoConstructList.getInstance();

        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private String source;

        private String sourceUrl;

        private Instant vendorCreatedAt;

        private String vendorSeverity;

        private Instant vendorUpdatedAt;

        private String vulnerabilityId;

        private List<VulnerablePackage> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVulnerabilityDetails model) {
            cvss(model.cvss);
            referenceUrls(model.referenceUrls);
            relatedVulnerabilities(model.relatedVulnerabilities);
            source(model.source);
            sourceUrl(model.sourceUrl);
            vendorCreatedAt(model.vendorCreatedAt);
            vendorSeverity(model.vendorSeverity);
            vendorUpdatedAt(model.vendorUpdatedAt);
            vulnerabilityId(model.vulnerabilityId);
            vulnerablePackages(model.vulnerablePackages);
        }

        public final List<CvssScore.Builder> getCvss() {
            List<CvssScore.Builder> result = CvssScoreListCopier.copyToBuilder(this.cvss);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCvss(Collection<CvssScore.BuilderImpl> cvss) {
            this.cvss = CvssScoreListCopier.copyFromBuilder(cvss);
        }

        @Override
        public final Builder cvss(Collection<CvssScore> cvss) {
            this.cvss = CvssScoreListCopier.copy(cvss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(CvssScore... cvss) {
            cvss(Arrays.asList(cvss));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Consumer<CvssScore.Builder>... cvss) {
            cvss(Stream.of(cvss).map(c -> CvssScore.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = NonEmptyStringListCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = NonEmptyStringListCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String... referenceUrls) {
            referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = VulnerabilityIdListCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = VulnerabilityIdListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String... relatedVulnerabilities) {
            relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final Instant getVendorCreatedAt() {
            return vendorCreatedAt;
        }

        public final void setVendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
        }

        @Override
        public final Builder vendorCreatedAt(Instant vendorCreatedAt) {
            this.vendorCreatedAt = vendorCreatedAt;
            return this;
        }

        public final String getVendorSeverity() {
            return vendorSeverity;
        }

        public final void setVendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
        }

        @Override
        public final Builder vendorSeverity(String vendorSeverity) {
            this.vendorSeverity = vendorSeverity;
            return this;
        }

        public final Instant getVendorUpdatedAt() {
            return vendorUpdatedAt;
        }

        public final void setVendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
        }

        @Override
        public final Builder vendorUpdatedAt(Instant vendorUpdatedAt) {
            this.vendorUpdatedAt = vendorUpdatedAt;
            return this;
        }

        public final String getVulnerabilityId() {
            return vulnerabilityId;
        }

        public final void setVulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
        }

        @Override
        public final Builder vulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
            return this;
        }

        public final List<VulnerablePackage.Builder> getVulnerablePackages() {
            List<VulnerablePackage.Builder> result = VulnerablePackageListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerablePackages(Collection<VulnerablePackage.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = VulnerablePackageListCopier.copyFromBuilder(vulnerablePackages);
        }

        @Override
        public final Builder vulnerablePackages(Collection<VulnerablePackage> vulnerablePackages) {
            this.vulnerablePackages = VulnerablePackageListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(VulnerablePackage... vulnerablePackages) {
            vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<VulnerablePackage.Builder>... vulnerablePackages) {
            vulnerablePackages(Stream.of(vulnerablePackages).map(c -> VulnerablePackage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PackageVulnerabilityDetails build() {
            return new PackageVulnerabilityDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
