/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.inspector2.internal.Inspector2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.inspector2.model.AccessDeniedException;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.AssociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.BadRequestException;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetAccountStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetCodeSnippetResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFindingDetailsResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetFreeTrialInfoResponse;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest;
import software.amazon.awssdk.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CancelSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.ConflictException;
import software.amazon.awssdk.services.inspector2.model.CreateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateFindingsReportResponse;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.CreateSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterRequest;
import software.amazon.awssdk.services.inspector2.model.DeleteFilterResponse;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.DisableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.DisableRequest;
import software.amazon.awssdk.services.inspector2.model.DisableResponse;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberRequest;
import software.amazon.awssdk.services.inspector2.model.DisassociateMemberResponse;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.EnableDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.EnableRequest;
import software.amazon.awssdk.services.inspector2.model.EnableResponse;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountRequest;
import software.amazon.awssdk.services.inspector2.model.GetDelegatedAdminAccountResponse;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.GetEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.GetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusRequest;
import software.amazon.awssdk.services.inspector2.model.GetFindingsReportStatusResponse;
import software.amazon.awssdk.services.inspector2.model.GetMemberRequest;
import software.amazon.awssdk.services.inspector2.model.GetMemberResponse;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportRequest;
import software.amazon.awssdk.services.inspector2.model.GetSbomExportResponse;
import software.amazon.awssdk.services.inspector2.model.Inspector2Exception;
import software.amazon.awssdk.services.inspector2.model.InternalServerException;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsRequest;
import software.amazon.awssdk.services.inspector2.model.ListAccountPermissionsResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageResponse;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsRequest;
import software.amazon.awssdk.services.inspector2.model.ListCoverageStatisticsResponse;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsRequest;
import software.amazon.awssdk.services.inspector2.model.ListDelegatedAdminAccountsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFiltersRequest;
import software.amazon.awssdk.services.inspector2.model.ListFiltersResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingAggregationsResponse;
import software.amazon.awssdk.services.inspector2.model.ListFindingsRequest;
import software.amazon.awssdk.services.inspector2.model.ListFindingsResponse;
import software.amazon.awssdk.services.inspector2.model.ListMembersRequest;
import software.amazon.awssdk.services.inspector2.model.ListMembersResponse;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.inspector2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsRequest;
import software.amazon.awssdk.services.inspector2.model.ListUsageTotalsResponse;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.ResetEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesRequest;
import software.amazon.awssdk.services.inspector2.model.SearchVulnerabilitiesResponse;
import software.amazon.awssdk.services.inspector2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.inspector2.model.TagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.TagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.ThrottlingException;
import software.amazon.awssdk.services.inspector2.model.UntagResourceRequest;
import software.amazon.awssdk.services.inspector2.model.UntagResourceResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateEncryptionKeyResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateFilterResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.inspector2.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.inspector2.model.ValidationException;
import software.amazon.awssdk.services.inspector2.transform.AssociateMemberRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetAccountStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetCodeSnippetRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetFindingDetailsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetFreeTrialInfoRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchGetMemberEc2DeepInspectionStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.BatchUpdateMemberEc2DeepInspectionStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CancelFindingsReportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CancelSbomExportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CreateFilterRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CreateFindingsReportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.CreateSbomExportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DeleteFilterRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DescribeOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DisableDelegatedAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DisableRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.DisassociateMemberRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.EnableDelegatedAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.EnableRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetDelegatedAdminAccountRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetEc2DeepInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetFindingsReportStatusRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetMemberRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.GetSbomExportRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListAccountPermissionsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListCoverageRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListCoverageStatisticsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListDelegatedAdminAccountsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListFiltersRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListFindingAggregationsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ListUsageTotalsRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.ResetEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.SearchVulnerabilitiesRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateEc2DeepInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateFilterRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateOrgEc2DeepInspectionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.inspector2.transform.UpdateOrganizationConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link Inspector2AsyncClient}.
 *
 * @see Inspector2AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInspector2AsyncClient implements Inspector2AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultInspector2AsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final Inspector2ServiceClientConfiguration serviceClientConfiguration;

    protected DefaultInspector2AsyncClient(Inspector2ServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response
     * indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check
     * if the association completed by using <a
     * href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html">ListMembers</a> for multiple
     * accounts or <a href="https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html">GetMembers</a> for
     * a single account.
     * </p>
     *
     * @param associateMemberRequest
     * @return A Java Future containing the result of the AssociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.AssociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/AssociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberResponse> associateMember(AssociateMemberRequest associateMemberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberRequest, AssociateMemberResponse>()
                            .withOperationName("AssociateMember")
                            .withMarshaller(new AssociateMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateMemberRequest));
            CompletableFuture<AssociateMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     * </p>
     *
     * @param batchGetAccountStatusRequest
     * @return A Java Future containing the result of the BatchGetAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetAccountStatusResponse> batchGetAccountStatus(
            BatchGetAccountStatusRequest batchGetAccountStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetAccountStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetAccountStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAccountStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetAccountStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetAccountStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetAccountStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetAccountStatusRequest, BatchGetAccountStatusResponse>()
                            .withOperationName("BatchGetAccountStatus")
                            .withMarshaller(new BatchGetAccountStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetAccountStatusRequest));
            CompletableFuture<BatchGetAccountStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     * </p>
     *
     * @param batchGetCodeSnippetRequest
     * @return A Java Future containing the result of the BatchGetCodeSnippet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetCodeSnippet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetCodeSnippet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetCodeSnippetResponse> batchGetCodeSnippet(
            BatchGetCodeSnippetRequest batchGetCodeSnippetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetCodeSnippetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetCodeSnippetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCodeSnippet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetCodeSnippetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetCodeSnippetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetCodeSnippetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetCodeSnippetRequest, BatchGetCodeSnippetResponse>()
                            .withOperationName("BatchGetCodeSnippet")
                            .withMarshaller(new BatchGetCodeSnippetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetCodeSnippetRequest));
            CompletableFuture<BatchGetCodeSnippetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets vulnerability details for findings.
     * </p>
     *
     * @param batchGetFindingDetailsRequest
     * @return A Java Future containing the result of the BatchGetFindingDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetFindingDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFindingDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetFindingDetailsResponse> batchGetFindingDetails(
            BatchGetFindingDetailsRequest batchGetFindingDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetFindingDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetFindingDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetFindingDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetFindingDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetFindingDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetFindingDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetFindingDetailsRequest, BatchGetFindingDetailsResponse>()
                            .withOperationName("BatchGetFindingDetails")
                            .withMarshaller(new BatchGetFindingDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetFindingDetailsRequest));
            CompletableFuture<BatchGetFindingDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets free trial status for multiple Amazon Web Services accounts.
     * </p>
     *
     * @param batchGetFreeTrialInfoRequest
     * @return A Java Future containing the result of the BatchGetFreeTrialInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetFreeTrialInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetFreeTrialInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetFreeTrialInfoResponse> batchGetFreeTrialInfo(
            BatchGetFreeTrialInfoRequest batchGetFreeTrialInfoRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetFreeTrialInfoRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetFreeTrialInfoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetFreeTrialInfo");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetFreeTrialInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetFreeTrialInfoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetFreeTrialInfoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetFreeTrialInfoRequest, BatchGetFreeTrialInfoResponse>()
                            .withOperationName("BatchGetFreeTrialInfo")
                            .withMarshaller(new BatchGetFreeTrialInfoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetFreeTrialInfoRequest));
            CompletableFuture<BatchGetFreeTrialInfoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your
     * organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchGetMemberEc2DeepInspectionStatusRequest
     * @return A Java Future containing the result of the BatchGetMemberEc2DeepInspectionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchGetMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchGetMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetMemberEc2DeepInspectionStatusResponse> batchGetMemberEc2DeepInspectionStatus(
            BatchGetMemberEc2DeepInspectionStatusRequest batchGetMemberEc2DeepInspectionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetMemberEc2DeepInspectionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetMemberEc2DeepInspectionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetMemberEc2DeepInspectionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetMemberEc2DeepInspectionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchGetMemberEc2DeepInspectionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetMemberEc2DeepInspectionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetMemberEc2DeepInspectionStatusRequest, BatchGetMemberEc2DeepInspectionStatusResponse>()
                            .withOperationName("BatchGetMemberEc2DeepInspectionStatus")
                            .withMarshaller(new BatchGetMemberEc2DeepInspectionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetMemberEc2DeepInspectionStatusRequest));
            CompletableFuture<BatchGetMemberEc2DeepInspectionStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization.
     * You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     * </p>
     *
     * @param batchUpdateMemberEc2DeepInspectionStatusRequest
     * @return A Java Future containing the result of the BatchUpdateMemberEc2DeepInspectionStatus operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.BatchUpdateMemberEc2DeepInspectionStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/BatchUpdateMemberEc2DeepInspectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateMemberEc2DeepInspectionStatusResponse> batchUpdateMemberEc2DeepInspectionStatus(
            BatchUpdateMemberEc2DeepInspectionStatusRequest batchUpdateMemberEc2DeepInspectionStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchUpdateMemberEc2DeepInspectionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchUpdateMemberEc2DeepInspectionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateMemberEc2DeepInspectionStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateMemberEc2DeepInspectionStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, BatchUpdateMemberEc2DeepInspectionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateMemberEc2DeepInspectionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateMemberEc2DeepInspectionStatusRequest, BatchUpdateMemberEc2DeepInspectionStatusResponse>()
                            .withOperationName("BatchUpdateMemberEc2DeepInspectionStatus")
                            .withMarshaller(new BatchUpdateMemberEc2DeepInspectionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchUpdateMemberEc2DeepInspectionStatusRequest));
            CompletableFuture<BatchUpdateMemberEc2DeepInspectionStatusResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels the given findings report.
     * </p>
     *
     * @param cancelFindingsReportRequest
     * @return A Java Future containing the result of the CancelFindingsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CancelFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelFindingsReportResponse> cancelFindingsReport(
            CancelFindingsReportRequest cancelFindingsReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelFindingsReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelFindingsReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelFindingsReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelFindingsReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelFindingsReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelFindingsReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelFindingsReportRequest, CancelFindingsReportResponse>()
                            .withOperationName("CancelFindingsReport")
                            .withMarshaller(new CancelFindingsReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelFindingsReportRequest));
            CompletableFuture<CancelFindingsReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a software bill of materials (SBOM) report.
     * </p>
     *
     * @param cancelSbomExportRequest
     * @return A Java Future containing the result of the CancelSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CancelSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CancelSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSbomExportResponse> cancelSbomExport(CancelSbomExportRequest cancelSbomExportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSbomExportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSbomExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSbomExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelSbomExportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelSbomExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelSbomExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSbomExportRequest, CancelSbomExportResponse>()
                            .withOperationName("CancelSbomExport")
                            .withMarshaller(new CancelSbomExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSbomExportRequest));
            CompletableFuture<CancelSbomExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a filter resource using specified filter criteria. When the filter action is set to <code>SUPPRESS</code>
     * this action creates a suppression rule.
     * </p>
     *
     * @param createFilterRequest
     * @return A Java Future containing the result of the CreateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded your service quota. To perform the requested action,
     *         remove some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>BadRequestException One or more tags submitted as part of the request is not valid.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFilterResponse> createFilter(CreateFilterRequest createFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFilterRequest, CreateFilterResponse>()
                            .withOperationName("CreateFilter").withMarshaller(new CreateFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFilterRequest));
            CompletableFuture<CreateFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a finding report. By default only <code>ACTIVE</code> findings are returned in the report. To see
     * <code>SUPRESSED</code> or <code>CLOSED</code> findings you must specify a value for the
     * <code>findingStatus</code> filter criteria.
     * </p>
     *
     * @param createFindingsReportRequest
     * @return A Java Future containing the result of the CreateFindingsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateFindingsReport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateFindingsReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFindingsReportResponse> createFindingsReport(
            CreateFindingsReportRequest createFindingsReportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFindingsReportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFindingsReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFindingsReport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFindingsReportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFindingsReportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFindingsReportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFindingsReportRequest, CreateFindingsReportResponse>()
                            .withOperationName("CreateFindingsReport")
                            .withMarshaller(new CreateFindingsReportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFindingsReportRequest));
            CompletableFuture<CreateFindingsReportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a software bill of materials (SBOM) report.
     * </p>
     *
     * @param createSbomExportRequest
     * @return A Java Future containing the result of the CreateSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.CreateSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/CreateSbomExport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSbomExportResponse> createSbomExport(CreateSbomExportRequest createSbomExportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSbomExportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSbomExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSbomExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSbomExportResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSbomExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSbomExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSbomExportRequest, CreateSbomExportResponse>()
                            .withOperationName("CreateSbomExport")
                            .withMarshaller(new CreateSbomExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSbomExportRequest));
            CompletableFuture<CreateSbomExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a filter resource.
     * </p>
     *
     * @param deleteFilterRequest
     * @return A Java Future containing the result of the DeleteFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DeleteFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DeleteFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFilterResponse> deleteFilter(DeleteFilterRequest deleteFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFilterRequest, DeleteFilterResponse>()
                            .withOperationName("DeleteFilter").withMarshaller(new DeleteFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFilterRequest));
            CompletableFuture<DeleteFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigurationResponse> describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse>()
                            .withOperationName("DescribeOrganizationConfiguration")
                            .withMarshaller(new DescribeOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationConfigurationRequest));
            CompletableFuture<DescribeOrganizationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an
     * account disables the Amazon Inspector service.
     * </p>
     *
     * @param disableRequest
     * @return A Java Future containing the result of the Disable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.Disable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Disable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableResponse> disable(DisableRequest disableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Disable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableRequest, DisableResponse>().withOperationName("Disable")
                            .withMarshaller(new DisableRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(disableRequest));
            CompletableFuture<DisableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param disableDelegatedAdminAccountRequest
     * @return A Java Future containing the result of the DisableDelegatedAdminAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DisableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableDelegatedAdminAccountResponse> disableDelegatedAdminAccount(
            DisableDelegatedAdminAccountRequest disableDelegatedAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableDelegatedAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableDelegatedAdminAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableDelegatedAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableDelegatedAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableDelegatedAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableDelegatedAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableDelegatedAdminAccountRequest, DisableDelegatedAdminAccountResponse>()
                            .withOperationName("DisableDelegatedAdminAccount")
                            .withMarshaller(new DisableDelegatedAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableDelegatedAdminAccountRequest));
            CompletableFuture<DisableDelegatedAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     * </p>
     *
     * @param disassociateMemberRequest
     * @return A Java Future containing the result of the DisassociateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.DisassociateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/DisassociateMember" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberResponse> disassociateMember(DisassociateMemberRequest disassociateMemberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberRequest, DisassociateMemberResponse>()
                            .withOperationName("DisassociateMember")
                            .withMarshaller(new DisassociateMemberRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateMemberRequest));
            CompletableFuture<DisassociateMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     * </p>
     *
     * @param enableRequest
     * @return A Java Future containing the result of the Enable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.Enable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/Enable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableResponse> enable(EnableRequest enableRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Enable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableRequest, EnableResponse>().withOperationName("Enable")
                            .withMarshaller(new EnableRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableRequest));
            CompletableFuture<EnableResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     * </p>
     *
     * @param enableDelegatedAdminAccountRequest
     * @return A Java Future containing the result of the EnableDelegatedAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException A conflict occurred.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.EnableDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/EnableDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableDelegatedAdminAccountResponse> enableDelegatedAdminAccount(
            EnableDelegatedAdminAccountRequest enableDelegatedAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableDelegatedAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableDelegatedAdminAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableDelegatedAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableDelegatedAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableDelegatedAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableDelegatedAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableDelegatedAdminAccountRequest, EnableDelegatedAdminAccountResponse>()
                            .withOperationName("EnableDelegatedAdminAccount")
                            .withMarshaller(new EnableDelegatedAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableDelegatedAdminAccountRequest));
            CompletableFuture<EnableDelegatedAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves setting configurations for Inspector scans.
     * </p>
     *
     * @param getConfigurationRequest
     * @return A Java Future containing the result of the GetConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConfigurationResponse> getConfiguration(GetConfigurationRequest getConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConfigurationRequest, GetConfigurationResponse>()
                            .withOperationName("GetConfiguration")
                            .withMarshaller(new GetConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getConfigurationRequest));
            CompletableFuture<GetConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param getDelegatedAdminAccountRequest
     * @return A Java Future containing the result of the GetDelegatedAdminAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetDelegatedAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetDelegatedAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDelegatedAdminAccountResponse> getDelegatedAdminAccount(
            GetDelegatedAdminAccountRequest getDelegatedAdminAccountRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDelegatedAdminAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDelegatedAdminAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDelegatedAdminAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDelegatedAdminAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDelegatedAdminAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDelegatedAdminAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDelegatedAdminAccountRequest, GetDelegatedAdminAccountResponse>()
                            .withOperationName("GetDelegatedAdminAccount")
                            .withMarshaller(new GetDelegatedAdminAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDelegatedAdminAccountRequest));
            CompletableFuture<GetDelegatedAdminAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your
     * account.
     * </p>
     *
     * @param getEc2DeepInspectionConfigurationRequest
     * @return A Java Future containing the result of the GetEc2DeepInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEc2DeepInspectionConfigurationResponse> getEc2DeepInspectionConfiguration(
            GetEc2DeepInspectionConfigurationRequest getEc2DeepInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEc2DeepInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEc2DeepInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEc2DeepInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEc2DeepInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetEc2DeepInspectionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEc2DeepInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEc2DeepInspectionConfigurationRequest, GetEc2DeepInspectionConfigurationResponse>()
                            .withOperationName("GetEc2DeepInspectionConfiguration")
                            .withMarshaller(new GetEc2DeepInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEc2DeepInspectionConfigurationRequest));
            CompletableFuture<GetEc2DeepInspectionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an encryption key.
     * </p>
     *
     * @param getEncryptionKeyRequest
     * @return A Java Future containing the result of the GetEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEncryptionKeyResponse> getEncryptionKey(GetEncryptionKeyRequest getEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEncryptionKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEncryptionKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEncryptionKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEncryptionKeyRequest, GetEncryptionKeyResponse>()
                            .withOperationName("GetEncryptionKey")
                            .withMarshaller(new GetEncryptionKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEncryptionKeyRequest));
            CompletableFuture<GetEncryptionKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status of a findings report.
     * </p>
     *
     * @param getFindingsReportStatusRequest
     * @return A Java Future containing the result of the GetFindingsReportStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetFindingsReportStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetFindingsReportStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFindingsReportStatusResponse> getFindingsReportStatus(
            GetFindingsReportStatusRequest getFindingsReportStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFindingsReportStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFindingsReportStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFindingsReportStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFindingsReportStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFindingsReportStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFindingsReportStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFindingsReportStatusRequest, GetFindingsReportStatusResponse>()
                            .withOperationName("GetFindingsReportStatus")
                            .withMarshaller(new GetFindingsReportStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFindingsReportStatusRequest));
            CompletableFuture<GetFindingsReportStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets member information for your organization.
     * </p>
     *
     * @param getMemberRequest
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMemberResponse> getMember(GetMemberRequest getMemberRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMemberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMember");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMemberResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMemberResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMemberRequest, GetMemberResponse>().withOperationName("GetMember")
                            .withMarshaller(new GetMemberRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMemberRequest));
            CompletableFuture<GetMemberResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details of a software bill of materials (SBOM) report.
     * </p>
     *
     * @param getSbomExportRequest
     * @return A Java Future containing the result of the GetSbomExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.GetSbomExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/GetSbomExport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSbomExportResponse> getSbomExport(GetSbomExportRequest getSbomExportRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSbomExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSbomExportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSbomExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSbomExportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSbomExportResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSbomExportResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSbomExportRequest, GetSbomExportResponse>()
                            .withOperationName("GetSbomExport")
                            .withMarshaller(new GetSbomExportRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSbomExportRequest));
            CompletableFuture<GetSbomExportResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the permissions an account has to configure Amazon Inspector.
     * </p>
     *
     * @param listAccountPermissionsRequest
     * @return A Java Future containing the result of the ListAccountPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListAccountPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListAccountPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccountPermissionsResponse> listAccountPermissions(
            ListAccountPermissionsRequest listAccountPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccountPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccountPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccountPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccountPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccountPermissionsRequest, ListAccountPermissionsResponse>()
                            .withOperationName("ListAccountPermissions")
                            .withMarshaller(new ListAccountPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccountPermissionsRequest));
            CompletableFuture<ListAccountPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists coverage details for you environment.
     * </p>
     *
     * @param listCoverageRequest
     * @return A Java Future containing the result of the ListCoverage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoverageResponse> listCoverage(ListCoverageRequest listCoverageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCoverageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCoverageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCoverage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoverageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCoverageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCoverageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCoverageRequest, ListCoverageResponse>()
                            .withOperationName("ListCoverage").withMarshaller(new ListCoverageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCoverageRequest));
            CompletableFuture<ListCoverageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage statistics for your environment.
     * </p>
     *
     * @param listCoverageStatisticsRequest
     * @return A Java Future containing the result of the ListCoverageStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListCoverageStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListCoverageStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoverageStatisticsResponse> listCoverageStatistics(
            ListCoverageStatisticsRequest listCoverageStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCoverageStatisticsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCoverageStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCoverageStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoverageStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCoverageStatisticsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCoverageStatisticsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCoverageStatisticsRequest, ListCoverageStatisticsResponse>()
                            .withOperationName("ListCoverageStatistics")
                            .withMarshaller(new ListCoverageStatisticsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCoverageStatisticsRequest));
            CompletableFuture<ListCoverageStatisticsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     * </p>
     *
     * @param listDelegatedAdminAccountsRequest
     * @return A Java Future containing the result of the ListDelegatedAdminAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListDelegatedAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListDelegatedAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDelegatedAdminAccountsResponse> listDelegatedAdminAccounts(
            ListDelegatedAdminAccountsRequest listDelegatedAdminAccountsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDelegatedAdminAccountsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDelegatedAdminAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDelegatedAdminAccounts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDelegatedAdminAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDelegatedAdminAccountsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDelegatedAdminAccountsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDelegatedAdminAccountsRequest, ListDelegatedAdminAccountsResponse>()
                            .withOperationName("ListDelegatedAdminAccounts")
                            .withMarshaller(new ListDelegatedAdminAccountsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDelegatedAdminAccountsRequest));
            CompletableFuture<ListDelegatedAdminAccountsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the filters associated with your account.
     * </p>
     *
     * @param listFiltersRequest
     * @return A Java Future containing the result of the ListFilters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFilters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFiltersResponse> listFilters(ListFiltersRequest listFiltersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFiltersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFiltersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFilters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFiltersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFiltersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFiltersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFiltersRequest, ListFiltersResponse>()
                            .withOperationName("ListFilters").withMarshaller(new ListFiltersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFiltersRequest));
            CompletableFuture<ListFiltersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists aggregated finding data for your environment based on specific criteria.
     * </p>
     *
     * @param listFindingAggregationsRequest
     * @return A Java Future containing the result of the ListFindingAggregations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindingAggregations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindingAggregations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingAggregationsResponse> listFindingAggregations(
            ListFindingAggregationsRequest listFindingAggregationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFindingAggregationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFindingAggregationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFindingAggregations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingAggregationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFindingAggregationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingAggregationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingAggregationsRequest, ListFindingAggregationsResponse>()
                            .withOperationName("ListFindingAggregations")
                            .withMarshaller(new ListFindingAggregationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFindingAggregationsRequest));
            CompletableFuture<ListFindingAggregationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists findings for your environment.
     * </p>
     *
     * @param listFindingsRequest
     * @return A Java Future containing the result of the ListFindings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListFindings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFindingsResponse> listFindings(ListFindingsRequest listFindingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFindingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFindings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFindingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFindingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFindingsRequest, ListFindingsResponse>()
                            .withOperationName("ListFindings").withMarshaller(new ListFindingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFindingsRequest));
            CompletableFuture<ListFindingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMembersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembersRequest, ListMembersResponse>()
                            .withOperationName("ListMembers").withMarshaller(new ListMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMembersRequest));
            CompletableFuture<ListMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags attached to a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the Amazon Inspector usage totals over the last 30 days.
     * </p>
     *
     * @param listUsageTotalsRequest
     * @return A Java Future containing the result of the ListUsageTotals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ListUsageTotals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ListUsageTotals" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsageTotalsResponse> listUsageTotals(ListUsageTotalsRequest listUsageTotalsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsageTotalsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsageTotalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsageTotals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsageTotalsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUsageTotalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsageTotalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsageTotalsRequest, ListUsageTotalsResponse>()
                            .withOperationName("ListUsageTotals")
                            .withMarshaller(new ListUsageTotalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUsageTotalsRequest));
            CompletableFuture<ListUsageTotalsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned
     * key.
     * </p>
     *
     * @param resetEncryptionKeyRequest
     * @return A Java Future containing the result of the ResetEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.ResetEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ResetEncryptionKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetEncryptionKeyResponse> resetEncryptionKey(ResetEncryptionKeyRequest resetEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetEncryptionKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetEncryptionKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetEncryptionKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetEncryptionKeyRequest, ResetEncryptionKeyResponse>()
                            .withOperationName("ResetEncryptionKey")
                            .withMarshaller(new ResetEncryptionKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetEncryptionKeyRequest));
            CompletableFuture<ResetEncryptionKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     * </p>
     *
     * @param searchVulnerabilitiesRequest
     * @return A Java Future containing the result of the SearchVulnerabilities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.SearchVulnerabilities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/SearchVulnerabilities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchVulnerabilitiesResponse> searchVulnerabilities(
            SearchVulnerabilitiesRequest searchVulnerabilitiesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchVulnerabilitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchVulnerabilitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchVulnerabilities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchVulnerabilitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchVulnerabilitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchVulnerabilitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchVulnerabilitiesRequest, SearchVulnerabilitiesResponse>()
                            .withOperationName("SearchVulnerabilities")
                            .withMarshaller(new SearchVulnerabilitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(searchVulnerabilitiesRequest));
            CompletableFuture<SearchVulnerabilitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException One or more tags submitted as part of the request is not valid.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector
     * delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization
     * cannot update this setting.
     * </p>
     *
     * @param updateConfigurationRequest
     * @return A Java Future containing the result of the UpdateConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConfigurationResponse> updateConfiguration(
            UpdateConfigurationRequest updateConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConfigurationRequest, UpdateConfigurationResponse>()
                            .withOperationName("UpdateConfiguration")
                            .withMarshaller(new UpdateConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateConfigurationRequest));
            CompletableFuture<UpdateConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     * </p>
     *
     * @param updateEc2DeepInspectionConfigurationRequest
     * @return A Java Future containing the result of the UpdateEc2DeepInspectionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateEc2DeepInspectionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEc2DeepInspectionConfigurationResponse> updateEc2DeepInspectionConfiguration(
            UpdateEc2DeepInspectionConfigurationRequest updateEc2DeepInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEc2DeepInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateEc2DeepInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEc2DeepInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEc2DeepInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateEc2DeepInspectionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEc2DeepInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEc2DeepInspectionConfigurationRequest, UpdateEc2DeepInspectionConfigurationResponse>()
                            .withOperationName("UpdateEc2DeepInspectionConfiguration")
                            .withMarshaller(new UpdateEc2DeepInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEc2DeepInspectionConfigurationRequest));
            CompletableFuture<UpdateEc2DeepInspectionConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an encryption key. A <code>ResourceNotFoundException</code> means that an AWS owned key is being used for
     * encryption.
     * </p>
     *
     * @param updateEncryptionKeyRequest
     * @return A Java Future containing the result of the UpdateEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEncryptionKeyResponse> updateEncryptionKey(
            UpdateEncryptionKeyRequest updateEncryptionKeyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEncryptionKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEncryptionKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEncryptionKey");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEncryptionKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEncryptionKeyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEncryptionKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEncryptionKeyRequest, UpdateEncryptionKeyResponse>()
                            .withOperationName("UpdateEncryptionKey")
                            .withMarshaller(new UpdateEncryptionKeyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEncryptionKeyRequest));
            CompletableFuture<UpdateEncryptionKeyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Specifies the action that is to be applied to the findings that match the filter.
     * </p>
     *
     * @param updateFilterRequest
     * @return A Java Future containing the result of the UpdateFilter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The operation tried to access an invalid resource. Make sure the resource
     *         is specified correctly.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFilterResponse> updateFilter(UpdateFilterRequest updateFilterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFilterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFilter");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFilterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFilterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFilterRequest, UpdateFilterResponse>()
                            .withOperationName("UpdateFilter").withMarshaller(new UpdateFilterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFilterRequest));
            CompletableFuture<UpdateFilterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector
     * delegated administrator to use this API.
     * </p>
     *
     * @param updateOrgEc2DeepInspectionConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrgEc2DeepInspectionConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateOrgEc2DeepInspectionConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrgEc2DeepInspectionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOrgEc2DeepInspectionConfigurationResponse> updateOrgEc2DeepInspectionConfiguration(
            UpdateOrgEc2DeepInspectionConfigurationRequest updateOrgEc2DeepInspectionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOrgEc2DeepInspectionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOrgEc2DeepInspectionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOrgEc2DeepInspectionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOrgEc2DeepInspectionConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateOrgEc2DeepInspectionConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOrgEc2DeepInspectionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOrgEc2DeepInspectionConfigurationRequest, UpdateOrgEc2DeepInspectionConfigurationResponse>()
                            .withOperationName("UpdateOrgEc2DeepInspectionConfiguration")
                            .withMarshaller(new UpdateOrgEc2DeepInspectionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOrgEc2DeepInspectionConfigurationRequest));
            CompletableFuture<UpdateOrgEc2DeepInspectionConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configurations for your Amazon Inspector organization.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return A Java Future containing the result of the UpdateOrganizationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The request has failed validation due to missing required fields or having
     *         invalid inputs.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException The request has failed due to an internal failure of the Amazon Inspector
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Inspector2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample Inspector2AsyncClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOrganizationConfigurationResponse> updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOrganizationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOrganizationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Inspector2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOrganizationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOrganizationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOrganizationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateOrganizationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse>()
                            .withOperationName("UpdateOrganizationConfiguration")
                            .withMarshaller(new UpdateOrganizationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOrganizationConfigurationRequest));
            CompletableFuture<UpdateOrganizationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final Inspector2ServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Inspector2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        Inspector2ServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = Inspector2ServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
