/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Ec2Platform {
    WINDOWS("WINDOWS"),
    LINUX("LINUX"),
    UNKNOWN("UNKNOWN"),
    MACOS("MACOS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ec2Platform> VALUE_MAP;
    private final String value;

    private Ec2Platform(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Ec2Platform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Ec2Platform> knownValues() {
        EnumSet<Ec2Platform> knownValues = EnumSet.allOf(Ec2Platform.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Ec2Platform.class, Ec2Platform::toString);
    }
}

