/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Ec2DeepInspectionStatus {
    ACTIVATED("ACTIVATED"),
    DEACTIVATED("DEACTIVATED"),
    PENDING("PENDING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Ec2DeepInspectionStatus> VALUE_MAP;
    private final String value;

    private Ec2DeepInspectionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Ec2DeepInspectionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Ec2DeepInspectionStatus> knownValues() {
        EnumSet<Ec2DeepInspectionStatus> knownValues = EnumSet.allOf(Ec2DeepInspectionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Ec2DeepInspectionStatus.class, Ec2DeepInspectionStatus::toString);
    }
}

