/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of a finding aggregation by AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmiAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<AmiAggregationResponse.Builder, AmiAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AmiAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Long> AFFECTED_INSTANCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("affectedInstances").getter(getter(AmiAggregationResponse::affectedInstances))
            .setter(setter(Builder::affectedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedInstances").build()).build();

    private static final SdkField<String> AMI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ami")
            .getter(getter(AmiAggregationResponse::ami)).setter(setter(Builder::ami))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ami").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(AmiAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            AFFECTED_INSTANCES_FIELD, AMI_FIELD, SEVERITY_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Long affectedInstances;

    private final String ami;

    private final SeverityCounts severityCounts;

    private AmiAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.affectedInstances = builder.affectedInstances;
        this.ami = builder.ami;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the AMI.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the AMI.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The IDs of Amazon EC2 instances using this AMI.
     * </p>
     * 
     * @return The IDs of Amazon EC2 instances using this AMI.
     */
    public final Long affectedInstances() {
        return affectedInstances;
    }

    /**
     * <p>
     * The ID of the AMI that findings were aggregated for.
     * </p>
     * 
     * @return The ID of the AMI that findings were aggregated for.
     */
    public final String ami() {
        return ami;
    }

    /**
     * <p>
     * An object that contains the count of matched findings per severity.
     * </p>
     * 
     * @return An object that contains the count of matched findings per severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(affectedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(ami());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiAggregationResponse)) {
            return false;
        }
        AmiAggregationResponse other = (AmiAggregationResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(affectedInstances(), other.affectedInstances())
                && Objects.equals(ami(), other.ami()) && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmiAggregationResponse").add("AccountId", accountId())
                .add("AffectedInstances", affectedInstances()).add("Ami", ami()).add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "affectedInstances":
            return Optional.ofNullable(clazz.cast(affectedInstances()));
        case "ami":
            return Optional.ofNullable(clazz.cast(ami()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmiAggregationResponse, T> g) {
        return obj -> g.apply((AmiAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmiAggregationResponse> {
        /**
         * <p>
         * The Amazon Web Services account ID for the AMI.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The IDs of Amazon EC2 instances using this AMI.
         * </p>
         * 
         * @param affectedInstances
         *        The IDs of Amazon EC2 instances using this AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedInstances(Long affectedInstances);

        /**
         * <p>
         * The ID of the AMI that findings were aggregated for.
         * </p>
         * 
         * @param ami
         *        The ID of the AMI that findings were aggregated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ami(String ami);

        /**
         * <p>
         * An object that contains the count of matched findings per severity.
         * </p>
         * 
         * @param severityCounts
         *        An object that contains the count of matched findings per severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * An object that contains the count of matched findings per severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Long affectedInstances;

        private String ami;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiAggregationResponse model) {
            accountId(model.accountId);
            affectedInstances(model.affectedInstances);
            ami(model.ami);
            severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Long getAffectedInstances() {
            return affectedInstances;
        }

        public final void setAffectedInstances(Long affectedInstances) {
            this.affectedInstances = affectedInstances;
        }

        @Override
        public final Builder affectedInstances(Long affectedInstances) {
            this.affectedInstances = affectedInstances;
            return this;
        }

        public final String getAmi() {
            return ami;
        }

        public final void setAmi(String ami) {
            this.ami = ami;
        }

        @Override
        public final Builder ami(String ami) {
            this.ami = ami;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public AmiAggregationResponse build() {
            return new AmiAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
