/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scan results aggregated by checks filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisScanResultsAggregatedByChecksFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<CisScanResultsAggregatedByChecksFilterCriteria.Builder, CisScanResultsAggregatedByChecksFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> ACCOUNT_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("accountIdFilters")
            .getter(getter(CisScanResultsAggregatedByChecksFilterCriteria::accountIdFilters))
            .setter(setter(Builder::accountIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> CHECK_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("checkIdFilters")
            .getter(getter(CisScanResultsAggregatedByChecksFilterCriteria::checkIdFilters))
            .setter(setter(Builder::checkIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisNumberFilter>> FAILED_RESOURCES_FILTERS_FIELD = SdkField
            .<List<CisNumberFilter>> builder(MarshallingType.LIST)
            .memberName("failedResourcesFilters")
            .getter(getter(CisScanResultsAggregatedByChecksFilterCriteria::failedResourcesFilters))
            .setter(setter(Builder::failedResourcesFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedResourcesFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> PLATFORM_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("platformFilters")
            .getter(getter(CisScanResultsAggregatedByChecksFilterCriteria::platformFilters))
            .setter(setter(Builder::platformFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisSecurityLevelFilter>> SECURITY_LEVEL_FILTERS_FIELD = SdkField
            .<List<CisSecurityLevelFilter>> builder(MarshallingType.LIST)
            .memberName("securityLevelFilters")
            .getter(getter(CisScanResultsAggregatedByChecksFilterCriteria::securityLevelFilters))
            .setter(setter(Builder::securityLevelFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevelFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisSecurityLevelFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisSecurityLevelFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> TITLE_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("titleFilters")
            .getter(getter(CisScanResultsAggregatedByChecksFilterCriteria::titleFilters))
            .setter(setter(Builder::titleFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("titleFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FILTERS_FIELD,
            CHECK_ID_FILTERS_FIELD, FAILED_RESOURCES_FILTERS_FIELD, PLATFORM_FILTERS_FIELD, SECURITY_LEVEL_FILTERS_FIELD,
            TITLE_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CisStringFilter> accountIdFilters;

    private final List<CisStringFilter> checkIdFilters;

    private final List<CisNumberFilter> failedResourcesFilters;

    private final List<CisStringFilter> platformFilters;

    private final List<CisSecurityLevelFilter> securityLevelFilters;

    private final List<CisStringFilter> titleFilters;

    private CisScanResultsAggregatedByChecksFilterCriteria(BuilderImpl builder) {
        this.accountIdFilters = builder.accountIdFilters;
        this.checkIdFilters = builder.checkIdFilters;
        this.failedResourcesFilters = builder.failedResourcesFilters;
        this.platformFilters = builder.platformFilters;
        this.securityLevelFilters = builder.securityLevelFilters;
        this.titleFilters = builder.titleFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdFilters() {
        return accountIdFilters != null && !(accountIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's account ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdFilters} method.
     * </p>
     * 
     * @return The criteria's account ID filters.
     */
    public final List<CisStringFilter> accountIdFilters() {
        return accountIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the CheckIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCheckIdFilters() {
        return checkIdFilters != null && !(checkIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's check ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCheckIdFilters} method.
     * </p>
     * 
     * @return The criteria's check ID filters.
     */
    public final List<CisStringFilter> checkIdFilters() {
        return checkIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedResourcesFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedResourcesFilters() {
        return failedResourcesFilters != null && !(failedResourcesFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's failed resources filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedResourcesFilters} method.
     * </p>
     * 
     * @return The criteria's failed resources filters.
     */
    public final List<CisNumberFilter> failedResourcesFilters() {
        return failedResourcesFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlatformFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlatformFilters() {
        return platformFilters != null && !(platformFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's platform filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatformFilters} method.
     * </p>
     * 
     * @return The criteria's platform filters.
     */
    public final List<CisStringFilter> platformFilters() {
        return platformFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityLevelFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityLevelFilters() {
        return securityLevelFilters != null && !(securityLevelFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's security level filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityLevelFilters} method.
     * </p>
     * 
     * @return The criteria's security level filters.
     */
    public final List<CisSecurityLevelFilter> securityLevelFilters() {
        return securityLevelFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TitleFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTitleFilters() {
        return titleFilters != null && !(titleFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's title filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTitleFilters} method.
     * </p>
     * 
     * @return The criteria's title filters.
     */
    public final List<CisStringFilter> titleFilters() {
        return titleFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdFilters() ? accountIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckIdFilters() ? checkIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedResourcesFilters() ? failedResourcesFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatformFilters() ? platformFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityLevelFilters() ? securityLevelFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTitleFilters() ? titleFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultsAggregatedByChecksFilterCriteria)) {
            return false;
        }
        CisScanResultsAggregatedByChecksFilterCriteria other = (CisScanResultsAggregatedByChecksFilterCriteria) obj;
        return hasAccountIdFilters() == other.hasAccountIdFilters()
                && Objects.equals(accountIdFilters(), other.accountIdFilters())
                && hasCheckIdFilters() == other.hasCheckIdFilters() && Objects.equals(checkIdFilters(), other.checkIdFilters())
                && hasFailedResourcesFilters() == other.hasFailedResourcesFilters()
                && Objects.equals(failedResourcesFilters(), other.failedResourcesFilters())
                && hasPlatformFilters() == other.hasPlatformFilters()
                && Objects.equals(platformFilters(), other.platformFilters())
                && hasSecurityLevelFilters() == other.hasSecurityLevelFilters()
                && Objects.equals(securityLevelFilters(), other.securityLevelFilters())
                && hasTitleFilters() == other.hasTitleFilters() && Objects.equals(titleFilters(), other.titleFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisScanResultsAggregatedByChecksFilterCriteria")
                .add("AccountIdFilters", hasAccountIdFilters() ? accountIdFilters() : null)
                .add("CheckIdFilters", hasCheckIdFilters() ? checkIdFilters() : null)
                .add("FailedResourcesFilters", hasFailedResourcesFilters() ? failedResourcesFilters() : null)
                .add("PlatformFilters", hasPlatformFilters() ? platformFilters() : null)
                .add("SecurityLevelFilters", hasSecurityLevelFilters() ? securityLevelFilters() : null)
                .add("TitleFilters", hasTitleFilters() ? titleFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIdFilters":
            return Optional.ofNullable(clazz.cast(accountIdFilters()));
        case "checkIdFilters":
            return Optional.ofNullable(clazz.cast(checkIdFilters()));
        case "failedResourcesFilters":
            return Optional.ofNullable(clazz.cast(failedResourcesFilters()));
        case "platformFilters":
            return Optional.ofNullable(clazz.cast(platformFilters()));
        case "securityLevelFilters":
            return Optional.ofNullable(clazz.cast(securityLevelFilters()));
        case "titleFilters":
            return Optional.ofNullable(clazz.cast(titleFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultsAggregatedByChecksFilterCriteria, T> g) {
        return obj -> g.apply((CisScanResultsAggregatedByChecksFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisScanResultsAggregatedByChecksFilterCriteria> {
        /**
         * <p>
         * The criteria's account ID filters.
         * </p>
         * 
         * @param accountIdFilters
         *        The criteria's account ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdFilters(Collection<CisStringFilter> accountIdFilters);

        /**
         * <p>
         * The criteria's account ID filters.
         * </p>
         * 
         * @param accountIdFilters
         *        The criteria's account ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdFilters(CisStringFilter... accountIdFilters);

        /**
         * <p>
         * The criteria's account ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #accountIdFilters(List<CisStringFilter>)}.
         * 
         * @param accountIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder accountIdFilters(Consumer<CisStringFilter.Builder>... accountIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * 
         * @param checkIdFilters
         *        The criteria's check ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * 
         * @param checkIdFilters
         *        The criteria's check ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdFilters(CisStringFilter... checkIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #checkIdFilters(List<CisStringFilter>)}.
         * 
         * @param checkIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder checkIdFilters(Consumer<CisStringFilter.Builder>... checkIdFilters);

        /**
         * <p>
         * The criteria's failed resources filters.
         * </p>
         * 
         * @param failedResourcesFilters
         *        The criteria's failed resources filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedResourcesFilters(Collection<CisNumberFilter> failedResourcesFilters);

        /**
         * <p>
         * The criteria's failed resources filters.
         * </p>
         * 
         * @param failedResourcesFilters
         *        The criteria's failed resources filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedResourcesFilters(CisNumberFilter... failedResourcesFilters);

        /**
         * <p>
         * The criteria's failed resources filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #failedResourcesFilters(List<CisNumberFilter>)}.
         * 
         * @param failedResourcesFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedResourcesFilters(java.util.Collection<CisNumberFilter>)
         */
        Builder failedResourcesFilters(Consumer<CisNumberFilter.Builder>... failedResourcesFilters);

        /**
         * <p>
         * The criteria's platform filters.
         * </p>
         * 
         * @param platformFilters
         *        The criteria's platform filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformFilters(Collection<CisStringFilter> platformFilters);

        /**
         * <p>
         * The criteria's platform filters.
         * </p>
         * 
         * @param platformFilters
         *        The criteria's platform filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformFilters(CisStringFilter... platformFilters);

        /**
         * <p>
         * The criteria's platform filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #platformFilters(List<CisStringFilter>)}.
         * 
         * @param platformFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformFilters(java.util.Collection<CisStringFilter>)
         */
        Builder platformFilters(Consumer<CisStringFilter.Builder>... platformFilters);

        /**
         * <p>
         * The criteria's security level filters.
         * </p>
         * 
         * @param securityLevelFilters
         *        The criteria's security level filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityLevelFilters(Collection<CisSecurityLevelFilter> securityLevelFilters);

        /**
         * <p>
         * The criteria's security level filters.
         * </p>
         * 
         * @param securityLevelFilters
         *        The criteria's security level filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityLevelFilters(CisSecurityLevelFilter... securityLevelFilters);

        /**
         * <p>
         * The criteria's security level filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #securityLevelFilters(List<CisSecurityLevelFilter>)}.
         * 
         * @param securityLevelFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisSecurityLevelFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityLevelFilters(java.util.Collection<CisSecurityLevelFilter>)
         */
        Builder securityLevelFilters(Consumer<CisSecurityLevelFilter.Builder>... securityLevelFilters);

        /**
         * <p>
         * The criteria's title filters.
         * </p>
         * 
         * @param titleFilters
         *        The criteria's title filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleFilters(Collection<CisStringFilter> titleFilters);

        /**
         * <p>
         * The criteria's title filters.
         * </p>
         * 
         * @param titleFilters
         *        The criteria's title filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleFilters(CisStringFilter... titleFilters);

        /**
         * <p>
         * The criteria's title filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #titleFilters(List<CisStringFilter>)}.
         * 
         * @param titleFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleFilters(java.util.Collection<CisStringFilter>)
         */
        Builder titleFilters(Consumer<CisStringFilter.Builder>... titleFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<CisStringFilter> accountIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> checkIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisNumberFilter> failedResourcesFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> platformFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisSecurityLevelFilter> securityLevelFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> titleFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultsAggregatedByChecksFilterCriteria model) {
            accountIdFilters(model.accountIdFilters);
            checkIdFilters(model.checkIdFilters);
            failedResourcesFilters(model.failedResourcesFilters);
            platformFilters(model.platformFilters);
            securityLevelFilters(model.securityLevelFilters);
            titleFilters(model.titleFilters);
        }

        public final List<CisStringFilter.Builder> getAccountIdFilters() {
            List<CisStringFilter.Builder> result = OneAccountIdFilterListCopier.copyToBuilder(this.accountIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIdFilters(Collection<CisStringFilter.BuilderImpl> accountIdFilters) {
            this.accountIdFilters = OneAccountIdFilterListCopier.copyFromBuilder(accountIdFilters);
        }

        @Override
        public final Builder accountIdFilters(Collection<CisStringFilter> accountIdFilters) {
            this.accountIdFilters = OneAccountIdFilterListCopier.copy(accountIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(CisStringFilter... accountIdFilters) {
            accountIdFilters(Arrays.asList(accountIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(Consumer<CisStringFilter.Builder>... accountIdFilters) {
            accountIdFilters(Stream.of(accountIdFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getCheckIdFilters() {
            List<CisStringFilter.Builder> result = CheckIdFilterListCopier.copyToBuilder(this.checkIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckIdFilters(Collection<CisStringFilter.BuilderImpl> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copyFromBuilder(checkIdFilters);
        }

        @Override
        public final Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copy(checkIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(CisStringFilter... checkIdFilters) {
            checkIdFilters(Arrays.asList(checkIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(Consumer<CisStringFilter.Builder>... checkIdFilters) {
            checkIdFilters(Stream.of(checkIdFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisNumberFilter.Builder> getFailedResourcesFilters() {
            List<CisNumberFilter.Builder> result = CisNumberFilterListCopier.copyToBuilder(this.failedResourcesFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedResourcesFilters(Collection<CisNumberFilter.BuilderImpl> failedResourcesFilters) {
            this.failedResourcesFilters = CisNumberFilterListCopier.copyFromBuilder(failedResourcesFilters);
        }

        @Override
        public final Builder failedResourcesFilters(Collection<CisNumberFilter> failedResourcesFilters) {
            this.failedResourcesFilters = CisNumberFilterListCopier.copy(failedResourcesFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedResourcesFilters(CisNumberFilter... failedResourcesFilters) {
            failedResourcesFilters(Arrays.asList(failedResourcesFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedResourcesFilters(Consumer<CisNumberFilter.Builder>... failedResourcesFilters) {
            failedResourcesFilters(Stream.of(failedResourcesFilters).map(c -> CisNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getPlatformFilters() {
            List<CisStringFilter.Builder> result = PlatformFilterListCopier.copyToBuilder(this.platformFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformFilters(Collection<CisStringFilter.BuilderImpl> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copyFromBuilder(platformFilters);
        }

        @Override
        public final Builder platformFilters(Collection<CisStringFilter> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copy(platformFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(CisStringFilter... platformFilters) {
            platformFilters(Arrays.asList(platformFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(Consumer<CisStringFilter.Builder>... platformFilters) {
            platformFilters(Stream.of(platformFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisSecurityLevelFilter.Builder> getSecurityLevelFilters() {
            List<CisSecurityLevelFilter.Builder> result = CisSecurityLevelFilterListCopier
                    .copyToBuilder(this.securityLevelFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityLevelFilters(Collection<CisSecurityLevelFilter.BuilderImpl> securityLevelFilters) {
            this.securityLevelFilters = CisSecurityLevelFilterListCopier.copyFromBuilder(securityLevelFilters);
        }

        @Override
        public final Builder securityLevelFilters(Collection<CisSecurityLevelFilter> securityLevelFilters) {
            this.securityLevelFilters = CisSecurityLevelFilterListCopier.copy(securityLevelFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityLevelFilters(CisSecurityLevelFilter... securityLevelFilters) {
            securityLevelFilters(Arrays.asList(securityLevelFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityLevelFilters(Consumer<CisSecurityLevelFilter.Builder>... securityLevelFilters) {
            securityLevelFilters(Stream.of(securityLevelFilters)
                    .map(c -> CisSecurityLevelFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTitleFilters() {
            List<CisStringFilter.Builder> result = TitleFilterListCopier.copyToBuilder(this.titleFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTitleFilters(Collection<CisStringFilter.BuilderImpl> titleFilters) {
            this.titleFilters = TitleFilterListCopier.copyFromBuilder(titleFilters);
        }

        @Override
        public final Builder titleFilters(Collection<CisStringFilter> titleFilters) {
            this.titleFilters = TitleFilterListCopier.copy(titleFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titleFilters(CisStringFilter... titleFilters) {
            titleFilters(Arrays.asList(titleFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder titleFilters(Consumer<CisStringFilter.Builder>... titleFilters) {
            titleFilters(Stream.of(titleFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CisScanResultsAggregatedByChecksFilterCriteria build() {
            return new CisScanResultsAggregatedByChecksFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
