/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the state of your ECR re-scan duration settings. The ECR re-scan duration defines how long an ECR image
 * will be actively scanned by Amazon Inspector. When the number of days since an image was last pushed exceeds the
 * duration configured for image pull date, and the duration configured for image pull date, the monitoring state of
 * that image becomes <code>inactive</code> and all associated findings are scheduled for closure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcrRescanDurationState implements SdkPojo, Serializable,
        ToCopyableBuilder<EcrRescanDurationState.Builder, EcrRescanDurationState> {
    private static final SdkField<String> PULL_DATE_RESCAN_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pullDateRescanDuration").getter(getter(EcrRescanDurationState::pullDateRescanDurationAsString))
            .setter(setter(Builder::pullDateRescanDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullDateRescanDuration").build())
            .build();

    private static final SdkField<String> RESCAN_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rescanDuration").getter(getter(EcrRescanDurationState::rescanDurationAsString))
            .setter(setter(Builder::rescanDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rescanDuration").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EcrRescanDurationState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(EcrRescanDurationState::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PULL_DATE_RESCAN_DURATION_FIELD, RESCAN_DURATION_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pullDateRescanDuration;

    private final String rescanDuration;

    private final String status;

    private final Instant updatedAt;

    private EcrRescanDurationState(BuilderImpl builder) {
        this.pullDateRescanDuration = builder.pullDateRescanDuration;
        this.rescanDuration = builder.rescanDuration;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The rescan duration configured for image pull date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullDateRescanDuration} will return {@link EcrPullDateRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pullDateRescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image pull date.
     * @see EcrPullDateRescanDuration
     */
    public final EcrPullDateRescanDuration pullDateRescanDuration() {
        return EcrPullDateRescanDuration.fromValue(pullDateRescanDuration);
    }

    /**
     * <p>
     * The rescan duration configured for image pull date.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #pullDateRescanDuration} will return {@link EcrPullDateRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #pullDateRescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image pull date.
     * @see EcrPullDateRescanDuration
     */
    public final String pullDateRescanDurationAsString() {
        return pullDateRescanDuration;
    }

    /**
     * <p>
     * The rescan duration configured for image push date.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rescanDuration}
     * will return {@link EcrRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image push date.
     * 
     *         <pre>
     * <code> &lt;/p&gt; </code>
     * @see EcrRescanDuration
     */
    public final EcrRescanDuration rescanDuration() {
        return EcrRescanDuration.fromValue(rescanDuration);
    }

    /**
     * <p>
     * The rescan duration configured for image push date.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rescanDuration}
     * will return {@link EcrRescanDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rescanDurationAsString}.
     * </p>
     * 
     * @return The rescan duration configured for image push date.
     * 
     *         <pre>
     * <code> &lt;/p&gt; </code>
     * @see EcrRescanDuration
     */
    public final String rescanDurationAsString() {
        return rescanDuration;
    }

    /**
     * <p>
     * The status of changes to the ECR automated re-scan duration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EcrRescanDurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of changes to the ECR automated re-scan duration.
     * @see EcrRescanDurationStatus
     */
    public final EcrRescanDurationStatus status() {
        return EcrRescanDurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of changes to the ECR automated re-scan duration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EcrRescanDurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of changes to the ECR automated re-scan duration.
     * @see EcrRescanDurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp representing when the last time the ECR scan duration setting was changed.
     * </p>
     * 
     * @return A timestamp representing when the last time the ECR scan duration setting was changed.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pullDateRescanDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rescanDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcrRescanDurationState)) {
            return false;
        }
        EcrRescanDurationState other = (EcrRescanDurationState) obj;
        return Objects.equals(pullDateRescanDurationAsString(), other.pullDateRescanDurationAsString())
                && Objects.equals(rescanDurationAsString(), other.rescanDurationAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcrRescanDurationState").add("PullDateRescanDuration", pullDateRescanDurationAsString())
                .add("RescanDuration", rescanDurationAsString()).add("Status", statusAsString()).add("UpdatedAt", updatedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullDateRescanDuration":
            return Optional.ofNullable(clazz.cast(pullDateRescanDurationAsString()));
        case "rescanDuration":
            return Optional.ofNullable(clazz.cast(rescanDurationAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcrRescanDurationState, T> g) {
        return obj -> g.apply((EcrRescanDurationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcrRescanDurationState> {
        /**
         * <p>
         * The rescan duration configured for image pull date.
         * </p>
         * 
         * @param pullDateRescanDuration
         *        The rescan duration configured for image pull date.
         * @see EcrPullDateRescanDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrPullDateRescanDuration
         */
        Builder pullDateRescanDuration(String pullDateRescanDuration);

        /**
         * <p>
         * The rescan duration configured for image pull date.
         * </p>
         * 
         * @param pullDateRescanDuration
         *        The rescan duration configured for image pull date.
         * @see EcrPullDateRescanDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrPullDateRescanDuration
         */
        Builder pullDateRescanDuration(EcrPullDateRescanDuration pullDateRescanDuration);

        /**
         * <p>
         * The rescan duration configured for image push date.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param rescanDuration
         *        The rescan duration configured for image push date.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @see EcrRescanDuration @return Returns a reference to this object so that
         *        method calls can be chained together. @see EcrRescanDuration
         */
        Builder rescanDuration(String rescanDuration);

        /**
         * <p>
         * The rescan duration configured for image push date.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param rescanDuration
         *        The rescan duration configured for image push date.
         * 
         *        <pre>
         * 
         *        <code> &lt;/p&gt; </code> @see EcrRescanDuration @return Returns a reference to this object so that
         *        method calls can be chained together. @see EcrRescanDuration
         */
        Builder rescanDuration(EcrRescanDuration rescanDuration);

        /**
         * <p>
         * The status of changes to the ECR automated re-scan duration.
         * </p>
         * 
         * @param status
         *        The status of changes to the ECR automated re-scan duration.
         * @see EcrRescanDurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrRescanDurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of changes to the ECR automated re-scan duration.
         * </p>
         * 
         * @param status
         *        The status of changes to the ECR automated re-scan duration.
         * @see EcrRescanDurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcrRescanDurationStatus
         */
        Builder status(EcrRescanDurationStatus status);

        /**
         * <p>
         * A timestamp representing when the last time the ECR scan duration setting was changed.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp representing when the last time the ECR scan duration setting was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String pullDateRescanDuration;

        private String rescanDuration;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EcrRescanDurationState model) {
            pullDateRescanDuration(model.pullDateRescanDuration);
            rescanDuration(model.rescanDuration);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getPullDateRescanDuration() {
            return pullDateRescanDuration;
        }

        public final void setPullDateRescanDuration(String pullDateRescanDuration) {
            this.pullDateRescanDuration = pullDateRescanDuration;
        }

        @Override
        public final Builder pullDateRescanDuration(String pullDateRescanDuration) {
            this.pullDateRescanDuration = pullDateRescanDuration;
            return this;
        }

        @Override
        public final Builder pullDateRescanDuration(EcrPullDateRescanDuration pullDateRescanDuration) {
            this.pullDateRescanDuration(pullDateRescanDuration == null ? null : pullDateRescanDuration.toString());
            return this;
        }

        public final String getRescanDuration() {
            return rescanDuration;
        }

        public final void setRescanDuration(String rescanDuration) {
            this.rescanDuration = rescanDuration;
        }

        @Override
        public final Builder rescanDuration(String rescanDuration) {
            this.rescanDuration = rescanDuration;
            return this;
        }

        @Override
        public final Builder rescanDuration(EcrRescanDuration rescanDuration) {
            this.rescanDuration(rescanDuration == null ? null : rescanDuration.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EcrRescanDurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EcrRescanDurationState build() {
            return new EcrRescanDurationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
