/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define a findings aggregation based on Amazon Web Services Lambda functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionAggregation.Builder, LambdaFunctionAggregation> {
    private static final SdkField<List<StringFilter>> FUNCTION_NAMES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("functionNames")
            .getter(getter(LambdaFunctionAggregation::functionNames))
            .setter(setter(Builder::functionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MapFilter>> FUNCTION_TAGS_FIELD = SdkField
            .<List<MapFilter>> builder(MarshallingType.LIST)
            .memberName("functionTags")
            .getter(getter(LambdaFunctionAggregation::functionTags))
            .setter(setter(Builder::functionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(MapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceIds")
            .getter(getter(LambdaFunctionAggregation::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> RUNTIMES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("runtimes")
            .getter(getter(LambdaFunctionAggregation::runtimes))
            .setter(setter(Builder::runtimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(LambdaFunctionAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(LambdaFunctionAggregation::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAMES_FIELD,
            FUNCTION_TAGS_FIELD, RESOURCE_IDS_FIELD, RUNTIMES_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> functionNames;

    private final List<MapFilter> functionTags;

    private final List<StringFilter> resourceIds;

    private final List<StringFilter> runtimes;

    private final String sortBy;

    private final String sortOrder;

    private LambdaFunctionAggregation(BuilderImpl builder) {
        this.functionNames = builder.functionNames;
        this.functionTags = builder.functionTags;
        this.resourceIds = builder.resourceIds;
        this.runtimes = builder.runtimes;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionNames() {
        return functionNames != null && !(functionNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Lambda function names to include in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionNames} method.
     * </p>
     * 
     * @return The Amazon Web Services Lambda function names to include in the aggregation results.
     */
    public final List<StringFilter> functionNames() {
        return functionNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFunctionTags() {
        return functionTags != null && !(functionTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to include in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionTags} method.
     * </p>
     * 
     * @return The tags to include in the aggregation results.
     */
    public final List<MapFilter> functionTags() {
        return functionTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource IDs to include in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return The resource IDs to include in the aggregation results.
     */
    public final List<StringFilter> resourceIds() {
        return resourceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Runtimes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuntimes() {
        return runtimes != null && !(runtimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuntimes} method.
     * </p>
     * 
     * @return Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
     */
    public final List<StringFilter> runtimes() {
        return runtimes;
    }

    /**
     * <p>
     * The finding severity to use for sorting the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link LambdaFunctionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The finding severity to use for sorting the results.
     * @see LambdaFunctionSortBy
     */
    public final LambdaFunctionSortBy sortBy() {
        return LambdaFunctionSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The finding severity to use for sorting the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link LambdaFunctionSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The finding severity to use for sorting the results.
     * @see LambdaFunctionSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order to use for sorting the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to use for sorting the results.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to use for sorting the results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to use for sorting the results.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionNames() ? functionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionTags() ? functionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuntimes() ? runtimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAggregation)) {
            return false;
        }
        LambdaFunctionAggregation other = (LambdaFunctionAggregation) obj;
        return hasFunctionNames() == other.hasFunctionNames() && Objects.equals(functionNames(), other.functionNames())
                && hasFunctionTags() == other.hasFunctionTags() && Objects.equals(functionTags(), other.functionTags())
                && hasResourceIds() == other.hasResourceIds() && Objects.equals(resourceIds(), other.resourceIds())
                && hasRuntimes() == other.hasRuntimes() && Objects.equals(runtimes(), other.runtimes())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionAggregation").add("FunctionNames", hasFunctionNames() ? functionNames() : null)
                .add("FunctionTags", hasFunctionTags() ? functionTags() : null)
                .add("ResourceIds", hasResourceIds() ? resourceIds() : null).add("Runtimes", hasRuntimes() ? runtimes() : null)
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionNames":
            return Optional.ofNullable(clazz.cast(functionNames()));
        case "functionTags":
            return Optional.ofNullable(clazz.cast(functionTags()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "runtimes":
            return Optional.ofNullable(clazz.cast(runtimes()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionAggregation, T> g) {
        return obj -> g.apply((LambdaFunctionAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionAggregation> {
        /**
         * <p>
         * The Amazon Web Services Lambda function names to include in the aggregation results.
         * </p>
         * 
         * @param functionNames
         *        The Amazon Web Services Lambda function names to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionNames(Collection<StringFilter> functionNames);

        /**
         * <p>
         * The Amazon Web Services Lambda function names to include in the aggregation results.
         * </p>
         * 
         * @param functionNames
         *        The Amazon Web Services Lambda function names to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionNames(StringFilter... functionNames);

        /**
         * <p>
         * The Amazon Web Services Lambda function names to include in the aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #functionNames(List<StringFilter>)}.
         * 
         * @param functionNames
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionNames(java.util.Collection<StringFilter>)
         */
        Builder functionNames(Consumer<StringFilter.Builder>... functionNames);

        /**
         * <p>
         * The tags to include in the aggregation results.
         * </p>
         * 
         * @param functionTags
         *        The tags to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionTags(Collection<MapFilter> functionTags);

        /**
         * <p>
         * The tags to include in the aggregation results.
         * </p>
         * 
         * @param functionTags
         *        The tags to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionTags(MapFilter... functionTags);

        /**
         * <p>
         * The tags to include in the aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.MapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #functionTags(List<MapFilter>)}.
         * 
         * @param functionTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.MapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionTags(java.util.Collection<MapFilter>)
         */
        Builder functionTags(Consumer<MapFilter.Builder>... functionTags);

        /**
         * <p>
         * The resource IDs to include in the aggregation results.
         * </p>
         * 
         * @param resourceIds
         *        The resource IDs to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<StringFilter> resourceIds);

        /**
         * <p>
         * The resource IDs to include in the aggregation results.
         * </p>
         * 
         * @param resourceIds
         *        The resource IDs to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(StringFilter... resourceIds);

        /**
         * <p>
         * The resource IDs to include in the aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceIds(List<StringFilter>)}.
         * 
         * @param resourceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIds(java.util.Collection<StringFilter>)
         */
        Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds);

        /**
         * <p>
         * Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
         * </p>
         * 
         * @param runtimes
         *        Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimes(Collection<StringFilter> runtimes);

        /**
         * <p>
         * Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
         * </p>
         * 
         * @param runtimes
         *        Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimes(StringFilter... runtimes);

        /**
         * <p>
         * Returns findings aggregated by Amazon Web Services Lambda function runtime environments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #runtimes(List<StringFilter>)}.
         * 
         * @param runtimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimes(java.util.Collection<StringFilter>)
         */
        Builder runtimes(Consumer<StringFilter.Builder>... runtimes);

        /**
         * <p>
         * The finding severity to use for sorting the results.
         * </p>
         * 
         * @param sortBy
         *        The finding severity to use for sorting the results.
         * @see LambdaFunctionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The finding severity to use for sorting the results.
         * </p>
         * 
         * @param sortBy
         *        The finding severity to use for sorting the results.
         * @see LambdaFunctionSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionSortBy
         */
        Builder sortBy(LambdaFunctionSortBy sortBy);

        /**
         * <p>
         * The order to use for sorting the results.
         * </p>
         * 
         * @param sortOrder
         *        The order to use for sorting the results.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to use for sorting the results.
         * </p>
         * 
         * @param sortOrder
         *        The order to use for sorting the results.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> functionNames = DefaultSdkAutoConstructList.getInstance();

        private List<MapFilter> functionTags = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> runtimes = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAggregation model) {
            functionNames(model.functionNames);
            functionTags(model.functionTags);
            resourceIds(model.resourceIds);
            runtimes(model.runtimes);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final List<StringFilter.Builder> getFunctionNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.functionNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionNames(Collection<StringFilter.BuilderImpl> functionNames) {
            this.functionNames = StringFilterListCopier.copyFromBuilder(functionNames);
        }

        @Override
        public final Builder functionNames(Collection<StringFilter> functionNames) {
            this.functionNames = StringFilterListCopier.copy(functionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionNames(StringFilter... functionNames) {
            functionNames(Arrays.asList(functionNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionNames(Consumer<StringFilter.Builder>... functionNames) {
            functionNames(Stream.of(functionNames).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MapFilter.Builder> getFunctionTags() {
            List<MapFilter.Builder> result = MapFilterListCopier.copyToBuilder(this.functionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionTags(Collection<MapFilter.BuilderImpl> functionTags) {
            this.functionTags = MapFilterListCopier.copyFromBuilder(functionTags);
        }

        @Override
        public final Builder functionTags(Collection<MapFilter> functionTags) {
            this.functionTags = MapFilterListCopier.copy(functionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionTags(MapFilter... functionTags) {
            functionTags(Arrays.asList(functionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionTags(Consumer<MapFilter.Builder>... functionTags) {
            functionTags(Stream.of(functionTags).map(c -> MapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds) {
            resourceIds(Stream.of(resourceIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getRuntimes() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.runtimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimes(Collection<StringFilter.BuilderImpl> runtimes) {
            this.runtimes = StringFilterListCopier.copyFromBuilder(runtimes);
        }

        @Override
        public final Builder runtimes(Collection<StringFilter> runtimes) {
            this.runtimes = StringFilterListCopier.copy(runtimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimes(StringFilter... runtimes) {
            runtimes(Arrays.asList(runtimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimes(Consumer<StringFilter.Builder>... runtimes) {
            runtimes(Stream.of(runtimes).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(LambdaFunctionSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public LambdaFunctionAggregation build() {
            return new LambdaFunctionAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
