/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of an Amazon Web Services Lambda function layer finding aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaLayerAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaLayerAggregationResponse.Builder, LambdaLayerAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(LambdaLayerAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionName").getter(getter(LambdaLayerAggregationResponse::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<String> LAYER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("layerArn").getter(getter(LambdaLayerAggregationResponse::layerArn)).setter(setter(Builder::layerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(LambdaLayerAggregationResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(LambdaLayerAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            FUNCTION_NAME_FIELD, LAYER_ARN_FIELD, RESOURCE_ID_FIELD, SEVERITY_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String functionName;

    private final String layerArn;

    private final String resourceId;

    private final SeverityCounts severityCounts;

    private LambdaLayerAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.functionName = builder.functionName;
        this.layerArn = builder.layerArn;
        this.resourceId = builder.resourceId;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The account ID of the Amazon Web Services Lambda function layer.
     * </p>
     * 
     * @return The account ID of the Amazon Web Services Lambda function layer.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The names of the Amazon Web Services Lambda functions associated with the layers.
     * </p>
     * 
     * @return The names of the Amazon Web Services Lambda functions associated with the layers.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
     */
    public final String layerArn() {
        return layerArn;
    }

    /**
     * <p>
     * The Resource ID of the Amazon Web Services Lambda function layer.
     * </p>
     * 
     * @return The Resource ID of the Amazon Web Services Lambda function layer.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * Returns the value of the SeverityCounts property for this object.
     * 
     * @return The value of the SeverityCounts property for this object.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(layerArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaLayerAggregationResponse)) {
            return false;
        }
        LambdaLayerAggregationResponse other = (LambdaLayerAggregationResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(layerArn(), other.layerArn()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaLayerAggregationResponse").add("AccountId", accountId())
                .add("FunctionName", functionName()).add("LayerArn", layerArn()).add("ResourceId", resourceId())
                .add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "functionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "layerArn":
            return Optional.ofNullable(clazz.cast(layerArn()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaLayerAggregationResponse, T> g) {
        return obj -> g.apply((LambdaLayerAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaLayerAggregationResponse> {
        /**
         * <p>
         * The account ID of the Amazon Web Services Lambda function layer.
         * </p>
         * 
         * @param accountId
         *        The account ID of the Amazon Web Services Lambda function layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The names of the Amazon Web Services Lambda functions associated with the layers.
         * </p>
         * 
         * @param functionName
         *        The names of the Amazon Web Services Lambda functions associated with the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
         * </p>
         * 
         * @param layerArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerArn(String layerArn);

        /**
         * <p>
         * The Resource ID of the Amazon Web Services Lambda function layer.
         * </p>
         * 
         * @param resourceId
         *        The Resource ID of the Amazon Web Services Lambda function layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * Sets the value of the SeverityCounts property for this object.
         *
         * @param severityCounts
         *        The new value for the SeverityCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * Sets the value of the SeverityCounts property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String functionName;

        private String layerArn;

        private String resourceId;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaLayerAggregationResponse model) {
            accountId(model.accountId);
            functionName(model.functionName);
            layerArn(model.layerArn);
            resourceId(model.resourceId);
            severityCounts(model.severityCounts);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getLayerArn() {
            return layerArn;
        }

        public final void setLayerArn(String layerArn) {
            this.layerArn = layerArn;
        }

        @Override
        public final Builder layerArn(String layerArn) {
            this.layerArn = layerArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public LambdaLayerAggregationResponse build() {
            return new LambdaLayerAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
