/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendCisSessionHealthRequest extends Inspector2Request implements
        ToCopyableBuilder<SendCisSessionHealthRequest.Builder, SendCisSessionHealthRequest> {
    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanJobId").getter(getter(SendCisSessionHealthRequest::scanJobId)).setter(setter(Builder::scanJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanJobId").build()).build();

    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionToken").getter(getter(SendCisSessionHealthRequest::sessionToken))
            .setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_JOB_ID_FIELD,
            SESSION_TOKEN_FIELD));

    private final String scanJobId;

    private final String sessionToken;

    private SendCisSessionHealthRequest(BuilderImpl builder) {
        super(builder);
        this.scanJobId = builder.scanJobId;
        this.sessionToken = builder.sessionToken;
    }

    /**
     * <p>
     * A unique identifier for the scan job.
     * </p>
     * 
     * @return A unique identifier for the scan job.
     */
    public final String scanJobId() {
        return scanJobId;
    }

    /**
     * <p>
     * The unique token that identifies the CIS session.
     * </p>
     * 
     * @return The unique token that identifies the CIS session.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCisSessionHealthRequest)) {
            return false;
        }
        SendCisSessionHealthRequest other = (SendCisSessionHealthRequest) obj;
        return Objects.equals(scanJobId(), other.scanJobId()) && Objects.equals(sessionToken(), other.sessionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendCisSessionHealthRequest").add("ScanJobId", scanJobId()).add("SessionToken", sessionToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanJobId":
            return Optional.ofNullable(clazz.cast(scanJobId()));
        case "sessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendCisSessionHealthRequest, T> g) {
        return obj -> g.apply((SendCisSessionHealthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, SendCisSessionHealthRequest> {
        /**
         * <p>
         * A unique identifier for the scan job.
         * </p>
         * 
         * @param scanJobId
         *        A unique identifier for the scan job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanJobId(String scanJobId);

        /**
         * <p>
         * The unique token that identifies the CIS session.
         * </p>
         * 
         * @param sessionToken
         *        The unique token that identifies the CIS session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String scanJobId;

        private String sessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCisSessionHealthRequest model) {
            super(model);
            scanJobId(model.scanJobId);
            sessionToken(model.sessionToken);
        }

        public final String getScanJobId() {
            return scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendCisSessionHealthRequest build() {
            return new SendCisSessionHealthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
